/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.ai;

import com.oracle.coherence.ai.Vector;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.util.ExternalizableHelper;
import jakarta.json.bind.annotation.JsonbProperty;
import jakarta.json.bind.annotation.JsonbTransient;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.BitSet;
import java.util.Objects;

public final class BitVector
implements Vector<BitSet> {
    @JsonbProperty(value="bits")
    private BitSet m_bits;

    public BitVector() {
        this(new BitSet());
    }

    public BitVector(long[] array) {
        this(BitSet.valueOf(array));
    }

    public BitVector(byte[] array) {
        this(BitSet.valueOf(array));
    }

    public BitVector(BitSet bits) {
        this.m_bits = bits;
    }

    @Override
    public int dimensions() {
        return this.m_bits.size();
    }

    @Override
    @JsonbTransient
    public BitSet get() {
        return this.m_bits;
    }

    @Override
    public BitVector binaryQuant() {
        return this;
    }

    @Override
    public void readExternal(PofReader in) throws IOException {
        long[] an = in.readLongArray(0);
        this.m_bits = BitSet.valueOf(an);
    }

    @Override
    public void writeExternal(PofWriter out) throws IOException {
        out.writeLongArray(0, this.m_bits.toLongArray(), true);
    }

    @Override
    public void readExternal(DataInput in) throws IOException {
        long[] an = ExternalizableHelper.readLongArray(in);
        this.m_bits = BitSet.valueOf(an);
    }

    @Override
    public void writeExternal(DataOutput out) throws IOException {
        long[] an = this.m_bits.toLongArray();
        out.writeInt(an.length);
        for (long a : an) {
            out.writeLong(a);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BitVector bitVector = (BitVector)o;
        return Objects.equals(this.m_bits, bitVector.m_bits);
    }

    public int hashCode() {
        return Objects.hashCode(this.m_bits);
    }

    public String toString() {
        return "BitVector{m_bits=" + String.valueOf(this.m_bits) + "}";
    }
}

