/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.util;

import com.tangosol.coherence.config.Config;
import com.tangosol.net.CacheFactory;
import java.util.function.Function;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class VirtualThreads {
    public static final String PROPERTY_ENABLED = "coherence.virtualthreads.enabled";
    public static final Function<String, String> PROPERTY_SERVICE_ENABLED = sServiceName -> String.format("coherence.service.%s.virtualthreads.enabled", sServiceName);

    public static Thread makeThread(ThreadGroup group, Runnable runnable, String sName) {
        Thread.Builder.OfVirtual builder = Thread.ofVirtual();
        if (sName != null) {
            builder.name(sName);
        }
        return builder.unstarted(runnable);
    }

    public static boolean isSupported() {
        return System.getSecurityManager() == null;
    }

    public static boolean isEnabled() {
        return CacheFactory.getCluster().getDependencies().isVirtualThreadsEnabled();
    }

    public static boolean isEnabled(String sServiceName) {
        return sServiceName == null ? VirtualThreads.isEnabled() : Config.getBoolean(PROPERTY_SERVICE_ENABLED.apply(sServiceName), VirtualThreads.isEnabled());
    }
}

