/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bedrock.runtime.java.options;

import com.oracle.bedrock.Option;
import com.oracle.bedrock.OptionsByType;
import com.oracle.bedrock.lang.ExpressionEvaluator;
import com.oracle.bedrock.runtime.java.options.Freeforms;
import com.oracle.bedrock.runtime.java.options.JvmOption;
import java.util.ArrayList;

public class Freeform
implements JvmOption,
Option.Collectable {
    private ArrayList<String> values = new ArrayList();

    public Freeform(String ... values) {
        if (values != null) {
            for (String value : values) {
                if (value == null) continue;
                this.values.add(value.trim());
            }
        }
    }

    public Class<? extends Option.Collector> getCollectorClass() {
        return Freeforms.class;
    }

    @Override
    public Iterable<String> resolve(OptionsByType optionsByType) {
        ExpressionEvaluator evaluator = new ExpressionEvaluator(optionsByType);
        ArrayList<String> result = new ArrayList<String>(this.values.size());
        for (String value : this.values) {
            result.add((String)evaluator.evaluate(value, String.class));
        }
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Freeform)) {
            return false;
        }
        Freeform freeform = (Freeform)o;
        return this.values != null ? this.values.equals(freeform.values) : freeform.values == null;
    }

    public int hashCode() {
        return this.values != null ? this.values.hashCode() : 0;
    }
}

