/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.oms.logmessage;

import java.io.UnsupportedEncodingException;

public class ByteString {
    private int len;
    private int offset;
    private byte[] bytes;

    public ByteString(byte[] bytes, int len) {
        this.bytes = bytes;
        this.len = len;
    }

    public ByteString(byte[] bytes, int offset, int len) {
        this.bytes = bytes;
        this.len = len;
        this.offset = offset;
    }

    public String toString(String encoding) {
        if (this.len == 0) {
            return "";
        }
        if ("binary".equalsIgnoreCase(encoding)) {
            throw new IllegalArgumentException("field encoding: binary, use getBytes() instead of toString()");
        }
        String realEncoding = encoding;
        if (encoding.isEmpty() || "null".equalsIgnoreCase(encoding)) {
            realEncoding = "ASCII";
        } else if ("utf8mb4".equalsIgnoreCase(encoding)) {
            realEncoding = "utf8";
        } else if ("latin1".equalsIgnoreCase(encoding)) {
            realEncoding = "cp1252";
        } else if ("latin2".equalsIgnoreCase(encoding)) {
            realEncoding = "iso-8859-2";
        }
        try {
            return new String(this.bytes, this.offset, this.len, realEncoding);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public String toString() {
        if (this.len == 0) {
            return "";
        }
        byte[] byteArray = this.bytes;
        char[] charArray = new char[this.len];
        for (int i = 0; i < this.len; ++i) {
            charArray[i] = (char)byteArray[i + this.offset];
        }
        return String.valueOf(charArray);
    }

    public byte[] getBytes() {
        byte[] t = new byte[this.len];
        System.arraycopy(this.bytes, this.offset, t, 0, this.len);
        return t;
    }

    public int getLen() {
        return this.len;
    }

    public int getOffset() {
        return this.offset;
    }

    public byte[] getRawBytes() {
        return this.bytes;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ByteString)) {
            return false;
        }
        ByteString other = (ByteString)obj;
        if (this.getLen() != other.getLen()) {
            return false;
        }
        for (int i = 0; i < this.getLen(); ++i) {
            byte x = this.bytes[this.offset + i];
            byte y = other.getRawBytes()[other.getOffset() + i];
            if (x == y) continue;
            return false;
        }
        return true;
    }
}

