/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.governator.configuration;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Maps;
import com.netflix.config.ConfigurationManager;
import com.netflix.config.DynamicPropertyFactory;
import com.netflix.config.PropertyWrapper;
import com.netflix.governator.configuration.AbstractObjectConfigurationProvider;
import com.netflix.governator.configuration.ConfigurationKey;
import com.netflix.governator.configuration.ConfigurationOwnershipPolicies;
import com.netflix.governator.configuration.ConfigurationOwnershipPolicy;
import com.netflix.governator.configuration.DateWithDefaultProperty;
import com.netflix.governator.configuration.Property;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.configuration.AbstractConfiguration;

public class ArchaiusConfigurationProvider
extends AbstractObjectConfigurationProvider {
    private final Map<String, String> variableValues;
    private final AbstractConfiguration configurationManager;
    private final DynamicPropertyFactory propertyFactory;
    private final ConfigurationOwnershipPolicy ownershipPolicy;

    public static Builder builder() {
        return new Builder();
    }

    @Deprecated
    public ArchaiusConfigurationProvider() {
        this(new HashMap<String, String>());
    }

    @Deprecated
    public ArchaiusConfigurationProvider(Map<String, String> variableValues) {
        this.variableValues = Maps.newHashMap(variableValues);
        this.configurationManager = ConfigurationManager.getConfigInstance();
        this.propertyFactory = DynamicPropertyFactory.getInstance();
        this.ownershipPolicy = new ConfigurationOwnershipPolicy(){

            public boolean has(ConfigurationKey key, Map<String, String> variables) {
                return ArchaiusConfigurationProvider.this.configurationManager.containsKey(key.getKey(variables));
            }
        };
    }

    private ArchaiusConfigurationProvider(Builder builder) {
        super(builder.objectMapper);
        this.variableValues = builder.variableValues;
        this.configurationManager = builder.configurationManager;
        this.propertyFactory = builder.propertyFactory;
        this.ownershipPolicy = builder.ownershipPolicy;
    }

    protected static Property<?> getDynamicProperty(Class<?> type, String key, String defaultValue, DynamicPropertyFactory propertyFactory) {
        if (type.isAssignableFrom(String.class)) {
            return new PropertyWrapperProperty(propertyFactory.getStringProperty(key, defaultValue));
        }
        if (type.isAssignableFrom(Integer.class)) {
            return new PropertyWrapperProperty(propertyFactory.getIntProperty(key, defaultValue == null ? 0 : Integer.parseInt(defaultValue)));
        }
        if (type.isAssignableFrom(Double.class)) {
            return new PropertyWrapperProperty(propertyFactory.getDoubleProperty(key, defaultValue == null ? 0.0 : Double.parseDouble(defaultValue)));
        }
        if (type.isAssignableFrom(Long.class)) {
            return new PropertyWrapperProperty(propertyFactory.getLongProperty(key, defaultValue == null ? 0L : Long.parseLong(defaultValue)));
        }
        if (type.isAssignableFrom(Boolean.class)) {
            return new PropertyWrapperProperty(propertyFactory.getBooleanProperty(key, defaultValue == null ? false : Boolean.parseBoolean(defaultValue)));
        }
        throw new RuntimeException("Unsupported value type " + type.getCanonicalName());
    }

    public void setVariable(String name, String value) {
        this.variableValues.put(name, value);
    }

    public boolean has(ConfigurationKey key) {
        return this.ownershipPolicy.has(key, this.variableValues);
    }

    public Property<Boolean> getBooleanProperty(ConfigurationKey key, Boolean defaultValue) {
        return new PropertyWrapperProperty<Boolean>((PropertyWrapper<Boolean>)this.propertyFactory.getBooleanProperty(key.getKey(this.variableValues), defaultValue.booleanValue()));
    }

    public Property<Integer> getIntegerProperty(ConfigurationKey key, Integer defaultValue) {
        return new PropertyWrapperProperty<Integer>((PropertyWrapper<Integer>)this.propertyFactory.getIntProperty(key.getKey(this.variableValues), defaultValue.intValue()));
    }

    public Property<Long> getLongProperty(ConfigurationKey key, Long defaultValue) {
        return new PropertyWrapperProperty<Long>((PropertyWrapper<Long>)this.propertyFactory.getLongProperty(key.getKey(this.variableValues), defaultValue.longValue()));
    }

    public Property<Double> getDoubleProperty(ConfigurationKey key, Double defaultValue) {
        return new PropertyWrapperProperty<Double>((PropertyWrapper<Double>)this.propertyFactory.getDoubleProperty(key.getKey(this.variableValues), defaultValue.doubleValue()));
    }

    public Property<String> getStringProperty(ConfigurationKey key, String defaultValue) {
        return new PropertyWrapperProperty<String>((PropertyWrapper<String>)this.propertyFactory.getStringProperty(key.getKey(this.variableValues), defaultValue));
    }

    public Property<Date> getDateProperty(ConfigurationKey key, Date defaultValue) {
        return new DateWithDefaultProperty(this.getStringProperty(key, null), defaultValue);
    }

    public static class PropertyWrapperProperty<T>
    extends Property<T> {
        private final PropertyWrapper<T> wrapper;

        public PropertyWrapperProperty(PropertyWrapper<T> wrapper) {
            this.wrapper = wrapper;
        }

        public T get() {
            return (T)this.wrapper.getValue();
        }
    }

    public static class Builder {
        private Map<String, String> variableValues = Maps.newHashMap();
        private AbstractConfiguration configurationManager = ConfigurationManager.getConfigInstance();
        private DynamicPropertyFactory propertyFactory = DynamicPropertyFactory.getInstance();
        private ConfigurationOwnershipPolicy ownershipPolicy = ConfigurationOwnershipPolicies.ownsAll();
        private ObjectMapper objectMapper = new ObjectMapper();

        public Builder withVariableValues(Map<String, String> variableValues) {
            this.variableValues = variableValues;
            return this;
        }

        public Builder withConfigurationManager(AbstractConfiguration configurationManager) {
            this.configurationManager = configurationManager;
            return this;
        }

        public Builder withPropertyFactory(DynamicPropertyFactory propertyFactory) {
            this.propertyFactory = propertyFactory;
            return this;
        }

        public Builder withOwnershipPolicy(ConfigurationOwnershipPolicy policy) {
            this.ownershipPolicy = policy;
            return this;
        }

        public Builder withObjectMapper(ObjectMapper objectMapper) {
            this.objectMapper = objectMapper;
            return this;
        }

        public ArchaiusConfigurationProvider build() {
            if (this.ownershipPolicy == null) {
                this.ownershipPolicy = new ConfigurationOwnershipPolicy(){

                    public boolean has(ConfigurationKey key, Map<String, String> variables) {
                        return configurationManager.containsKey(key.getKey(variableValues));
                    }
                };
            }
            return new ArchaiusConfigurationProvider(this);
        }

        private Builder() {
        }
    }
}

