/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.eureka.resources;

import com.netflix.appinfo.EurekaAccept;
import com.netflix.eureka.EurekaServerContext;
import com.netflix.eureka.EurekaServerContextHolder;
import com.netflix.eureka.registry.Key;
import com.netflix.eureka.resources.AbstractVIPResource;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@Path(value="/{version}/svips")
@Produces(value={"application/xml", "application/json"})
public class SecureVIPResource
extends AbstractVIPResource {
    @Inject
    SecureVIPResource(EurekaServerContext server) {
        super(server);
    }

    public SecureVIPResource() {
        this(EurekaServerContextHolder.getInstance().getServerContext());
    }

    @GET
    @Path(value="{svipAddress}")
    public Response statusUpdate(@PathParam(value="version") String version, @PathParam(value="svipAddress") String svipAddress, @HeaderParam(value="Accept") String acceptHeader, @HeaderParam(value="X-Eureka-Accept") String eurekaAccept) {
        return this.getVipResponse(version, svipAddress, acceptHeader, EurekaAccept.fromString((String)eurekaAccept), Key.EntityType.SVIP);
    }
}

