/*
 * Decompiled with CFR 0.152.
 */
package com.netease.nim.server.sdk.im.v2.mute;

import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONWriter;
import com.netease.nim.server.sdk.core.Result;
import com.netease.nim.server.sdk.core.YunxinApiHttpClient;
import com.netease.nim.server.sdk.core.YunxinApiResponse;
import com.netease.nim.server.sdk.core.exception.YunxinSdkException;
import com.netease.nim.server.sdk.core.http.HttpMethod;
import com.netease.nim.server.sdk.im.v2.mute.IMuteV2Service;
import com.netease.nim.server.sdk.im.v2.mute.request.AddMuteContactRequestV2;
import com.netease.nim.server.sdk.im.v2.mute.request.ListMuteContactsRequestV2;
import com.netease.nim.server.sdk.im.v2.mute.request.RemoveMuteContactRequestV2;
import com.netease.nim.server.sdk.im.v2.mute.response.AddMuteContactResponseV2;
import com.netease.nim.server.sdk.im.v2.mute.response.ListMuteContactsResponseV2;
import com.netease.nim.server.sdk.im.v2.mute.response.RemoveMuteContactResponseV2;
import com.netease.nim.server.sdk.im.v2.util.ResultUtils;
import java.util.HashMap;

public class MuteV2Service
implements IMuteV2Service {
    private final YunxinApiHttpClient httpClient;

    public MuteV2Service(YunxinApiHttpClient httpClient) {
        this.httpClient = httpClient;
    }

    @Override
    public Result<AddMuteContactResponseV2> addMuteContact(AddMuteContactRequestV2 request) throws YunxinSdkException {
        String requestBody = JSONObject.toJSONString((Object)request, (JSONWriter.Feature[])new JSONWriter.Feature[0]);
        YunxinApiResponse apiResponse = this.httpClient.executeV2Api(HttpMethod.POST, "/im/v2/mute_contacts", "/im/v2/mute_contacts", null, requestBody);
        return ResultUtils.convert(apiResponse, AddMuteContactResponseV2.class);
    }

    @Override
    public Result<RemoveMuteContactResponseV2> removeMuteContact(RemoveMuteContactRequestV2 request) throws YunxinSdkException {
        String path = "/im/v2/mute_contacts/{account_id}".replace("{account_id}", request.getAccountId());
        HashMap<String, String> queryParams = new HashMap<String, String>();
        queryParams.put("contact_account_id", request.getContactAccountId());
        YunxinApiResponse apiResponse = this.httpClient.executeV2Api(HttpMethod.DELETE, "/im/v2/mute_contacts/{account_id}", path, queryParams, null);
        return ResultUtils.convert(apiResponse, RemoveMuteContactResponseV2.class);
    }

    @Override
    public Result<ListMuteContactsResponseV2> listMuteContacts(ListMuteContactsRequestV2 request) throws YunxinSdkException {
        HashMap<String, String> queryParams = new HashMap<String, String>();
        queryParams.put("account_id", request.getAccountId());
        if (request.getPageToken() != null) {
            queryParams.put("page_token", request.getPageToken());
        }
        if (request.getLimit() != null) {
            queryParams.put("limit", request.getLimit().toString());
        }
        YunxinApiResponse apiResponse = this.httpClient.executeV2Api(HttpMethod.GET, "/im/v2/mute_contacts", "/im/v2/mute_contacts", queryParams, null);
        return ResultUtils.convert(apiResponse, ListMuteContactsResponseV2.class);
    }
}

