/*
 * Decompiled with CFR 0.152.
 */
package com.netease.nim.server.sdk.im.v2.conversation_unread;

import com.netease.nim.server.sdk.core.Result;
import com.netease.nim.server.sdk.core.YunxinApiHttpClient;
import com.netease.nim.server.sdk.core.YunxinApiResponse;
import com.netease.nim.server.sdk.core.exception.YunxinSdkException;
import com.netease.nim.server.sdk.core.http.HttpMethod;
import com.netease.nim.server.sdk.im.v2.conversation_unread.IConversationUnreadV2Service;
import com.netease.nim.server.sdk.im.v2.conversation_unread.request.ClearConversationUnreadRequestV2;
import com.netease.nim.server.sdk.im.v2.conversation_unread.request.OverViewsConversationRequestV2;
import com.netease.nim.server.sdk.im.v2.conversation_unread.response.ClearConversationUnreadResponseV2;
import com.netease.nim.server.sdk.im.v2.conversation_unread.response.OverViewsConversationResponseV2;
import com.netease.nim.server.sdk.im.v2.util.ResultUtils;

public class ConversationUnreadV2Service
implements IConversationUnreadV2Service {
    private final YunxinApiHttpClient httpClient;

    public ConversationUnreadV2Service(YunxinApiHttpClient httpClient) {
        this.httpClient = httpClient;
    }

    @Override
    public Result<OverViewsConversationResponseV2> getConversationOverview(OverViewsConversationRequestV2 request) throws YunxinSdkException {
        String path = "/im/v2/conversation_overviews/{account_id}".replace("{account_id}", request.getAccountId());
        YunxinApiResponse apiResponse = this.httpClient.executeV2Api(HttpMethod.GET, "/im/v2/conversation_overviews/{account_id}", path, null, null);
        return ResultUtils.convert(apiResponse, OverViewsConversationResponseV2.class);
    }

    @Override
    public Result<ClearConversationUnreadResponseV2> clearConversationUnread(ClearConversationUnreadRequestV2 request) throws YunxinSdkException {
        String path = "/im/v2/conversations/{conversation_id}/actions/clear_conversation_unread".replace("{conversation_id}", request.getConversationId());
        YunxinApiResponse apiResponse = this.httpClient.executeV2Api(HttpMethod.PATCH, "/im/v2/conversations/{conversation_id}/actions/clear_conversation_unread", path, null, null);
        return ResultUtils.convert(apiResponse, ClearConversationUnreadResponseV2.class);
    }
}

