/*
 * Decompiled with CFR 0.152.
 */
package com.netease.nim.server.sdk.im.v2.account;

import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONWriter;
import com.netease.nim.server.sdk.core.Result;
import com.netease.nim.server.sdk.core.YunxinApiHttpClient;
import com.netease.nim.server.sdk.core.YunxinApiResponse;
import com.netease.nim.server.sdk.core.exception.YunxinSdkException;
import com.netease.nim.server.sdk.core.http.HttpMethod;
import com.netease.nim.server.sdk.im.v2.account.IAccountV2Service;
import com.netease.nim.server.sdk.im.v2.account.request.BatchQueryAccountsRequestV2;
import com.netease.nim.server.sdk.im.v2.account.request.CreateAccountRequestV2;
import com.netease.nim.server.sdk.im.v2.account.request.DisableAccountRequestV2;
import com.netease.nim.server.sdk.im.v2.account.request.GetAccountDetailsRequestV2;
import com.netease.nim.server.sdk.im.v2.account.request.KickAccountRequestV2;
import com.netease.nim.server.sdk.im.v2.account.request.RefreshTokenRequestV2;
import com.netease.nim.server.sdk.im.v2.account.request.SetPushConfigRequestV2;
import com.netease.nim.server.sdk.im.v2.account.request.UpdateAccountRequestV2;
import com.netease.nim.server.sdk.im.v2.account.response.BatchQueryAccountsResponseV2;
import com.netease.nim.server.sdk.im.v2.account.response.CreateAccountResponseV2;
import com.netease.nim.server.sdk.im.v2.account.response.DisableAccountResponseV2;
import com.netease.nim.server.sdk.im.v2.account.response.GetAccountDetailsResponseV2;
import com.netease.nim.server.sdk.im.v2.account.response.KickAccountResponseV2;
import com.netease.nim.server.sdk.im.v2.account.response.RefreshTokenResponseV2;
import com.netease.nim.server.sdk.im.v2.account.response.SetPushConfigResponseV2;
import com.netease.nim.server.sdk.im.v2.account.response.UpdateAccountResponseV2;
import com.netease.nim.server.sdk.im.v2.util.ResultUtils;
import java.util.HashMap;
import java.util.List;

public class AccountV2Service
implements IAccountV2Service {
    private final YunxinApiHttpClient httpClient;

    public AccountV2Service(YunxinApiHttpClient httpClient) {
        this.httpClient = httpClient;
    }

    @Override
    public Result<CreateAccountResponseV2> createAccount(CreateAccountRequestV2 request) throws YunxinSdkException {
        String data = JSONObject.toJSONString((Object)request, (JSONWriter.Feature[])new JSONWriter.Feature[0]);
        YunxinApiResponse apiResponse = this.httpClient.executeV2Api(HttpMethod.POST, "/im/v2/accounts", "/im/v2/accounts", null, data);
        return ResultUtils.convert(apiResponse, CreateAccountResponseV2.class);
    }

    @Override
    public Result<UpdateAccountResponseV2> updateAccount(UpdateAccountRequestV2 request) throws YunxinSdkException {
        JSONObject data = JSONObject.parseObject((String)JSONObject.toJSONString((Object)request, (JSONWriter.Feature[])new JSONWriter.Feature[0]));
        data.remove((Object)"account_id");
        String path = "/im/v2/accounts/{account_id}".replace("{account_id}", request.getAccountId());
        YunxinApiResponse apiResponse = this.httpClient.executeV2Api(HttpMethod.PATCH, "/im/v2/accounts/{account_id}", path, null, data.toString());
        return ResultUtils.convert(apiResponse, UpdateAccountResponseV2.class);
    }

    @Override
    public Result<BatchQueryAccountsResponseV2> batchQueryAccounts(BatchQueryAccountsRequestV2 request) throws YunxinSdkException {
        HashMap<String, String> map = new HashMap<String, String>();
        List<String> accountList = request.getAccountList();
        StringBuilder builder = new StringBuilder();
        for (String account : accountList) {
            builder.append(account).append(",");
        }
        if (builder.length() > 0) {
            builder.deleteCharAt(builder.length() - 1);
        }
        map.put("account_ids", builder.toString());
        YunxinApiResponse apiResponse = this.httpClient.executeV2Api(HttpMethod.GET, "/im/v2/accounts", "/im/v2/accounts", map, null);
        return ResultUtils.convert(apiResponse, BatchQueryAccountsResponseV2.class);
    }

    @Override
    public Result<DisableAccountResponseV2> disableAccount(DisableAccountRequestV2 request) throws YunxinSdkException {
        JSONObject data = new JSONObject();
        data.put((Object)"enabled", (Object)request.getEnabled());
        if (request.getNeedKick() != null) {
            data.put((Object)"need_kick", (Object)request.getNeedKick());
        }
        if (request.getKickNotifyExtension() != null) {
            data.put((Object)"kick_notify_extension", (Object)request.getKickNotifyExtension());
        }
        String path = "/im/v2/accounts/{account_id}/actions/disable".replace("{account_id}", request.getAccountId());
        YunxinApiResponse apiResponse = this.httpClient.executeV2Api(HttpMethod.PATCH, "/im/v2/accounts/{account_id}/actions/disable", path, null, data.toString());
        return ResultUtils.convert(apiResponse, DisableAccountResponseV2.class);
    }

    @Override
    public Result<SetPushConfigResponseV2> setPushConfig(SetPushConfigRequestV2 request) throws YunxinSdkException {
        JSONObject data = new JSONObject();
        data.put((Object)"push_enabled_when_desktop_online", (Object)request.getPushEnabledWhenDesktopOnline());
        String path = "/im/v2/accounts/{account_id}/actions/push_config".replace("{account_id}", request.getAccountId());
        YunxinApiResponse apiResponse = this.httpClient.executeV2Api(HttpMethod.PATCH, "/im/v2/accounts/{account_id}/actions/push_config", path, null, data.toString());
        return ResultUtils.convert(apiResponse, SetPushConfigResponseV2.class);
    }

    @Override
    public Result<GetAccountDetailsResponseV2> getAccountDetails(GetAccountDetailsRequestV2 request) throws YunxinSdkException {
        String path = "/im/v2/accounts/{account_id}".replace("{account_id}", request.getAccountId());
        YunxinApiResponse apiResponse = this.httpClient.executeV2Api(HttpMethod.GET, "/im/v2/accounts/{account_id}", path, null, null);
        return ResultUtils.convert(apiResponse, GetAccountDetailsResponseV2.class);
    }

    @Override
    public Result<KickAccountResponseV2> kickAccount(KickAccountRequestV2 request) throws YunxinSdkException {
        JSONObject data = new JSONObject();
        data.put((Object)"type", (Object)request.getType());
        if (request.getDeviceIdList() != null && !request.getDeviceIdList().isEmpty()) {
            data.put((Object)"device_id_list", request.getDeviceIdList());
        }
        if (request.getKickNotifyExtension() != null) {
            data.put((Object)"kick_notify_extension", (Object)request.getKickNotifyExtension());
        }
        String path = "/im/v2/accounts/{account_id}/actions/kick".replace("{account_id}", request.getAccountId());
        YunxinApiResponse apiResponse = this.httpClient.executeV2Api(HttpMethod.POST, "/im/v2/accounts/{account_id}/actions/kick", path, null, data.toString());
        return ResultUtils.convert(apiResponse, KickAccountResponseV2.class);
    }

    @Override
    public Result<RefreshTokenResponseV2> refreshToken(RefreshTokenRequestV2 request) throws YunxinSdkException {
        String path = "/im/v2/accounts/{account_id}/actions/refresh_token".replace("{account_id}", request.getAccountId());
        YunxinApiResponse apiResponse = this.httpClient.executeV2Api(HttpMethod.PATCH, "/im/v2/accounts/{account_id}/actions/refresh_token", path, null, null);
        return ResultUtils.convert(apiResponse, RefreshTokenResponseV2.class);
    }
}

