/*
 * Decompiled with CFR 0.152.
 */
package com.netease.nim.server.sdk.im.v1.team;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.JSONWriter;
import com.netease.nim.server.sdk.core.Result;
import com.netease.nim.server.sdk.core.YunxinApiHttpClient;
import com.netease.nim.server.sdk.core.YunxinApiResponse;
import com.netease.nim.server.sdk.core.exception.YunxinSdkException;
import com.netease.nim.server.sdk.im.v1.annotation.YunxinParamUtils;
import com.netease.nim.server.sdk.im.v1.team.ITeamV1Service;
import com.netease.nim.server.sdk.im.v1.team.request.AddManagerTeamRequestV1;
import com.netease.nim.server.sdk.im.v1.team.request.AddTeamRequestV1;
import com.netease.nim.server.sdk.im.v1.team.request.BatchQueryOnlineTeamMemberCountRequestV1;
import com.netease.nim.server.sdk.im.v1.team.request.ChangeOwnerTeamRequestV1;
import com.netease.nim.server.sdk.im.v1.team.request.CreateTeamRequestV1;
import com.netease.nim.server.sdk.im.v1.team.request.DismissTeamRequestV1;
import com.netease.nim.server.sdk.im.v1.team.request.JoinsTeamRequestV1;
import com.netease.nim.server.sdk.im.v1.team.request.KickTeamRequestV1;
import com.netease.nim.server.sdk.im.v1.team.request.LeaveTeamRequestV1;
import com.netease.nim.server.sdk.im.v1.team.request.MuteTeamAllMemberRequestV1;
import com.netease.nim.server.sdk.im.v1.team.request.MuteTeamRequestV1;
import com.netease.nim.server.sdk.im.v1.team.request.MuteTeamTargetMemberRequestV1;
import com.netease.nim.server.sdk.im.v1.team.request.QueryAllJoinedTeamMemberInfoByAccIdRequestV1;
import com.netease.nim.server.sdk.im.v1.team.request.QueryMuteTeamMembersRequestV1;
import com.netease.nim.server.sdk.im.v1.team.request.QueryOnlineTeamMemberRequestV1;
import com.netease.nim.server.sdk.im.v1.team.request.QueryTeamInfoDetailsRequestV1;
import com.netease.nim.server.sdk.im.v1.team.request.QueryTeamMsgMarkReadInfoRequestV1;
import com.netease.nim.server.sdk.im.v1.team.request.QueryTeamRequestV1;
import com.netease.nim.server.sdk.im.v1.team.request.RemoveManagerTeamRequestV1;
import com.netease.nim.server.sdk.im.v1.team.request.UpdateTeamNickRequestV1;
import com.netease.nim.server.sdk.im.v1.team.request.UpdateTeamRequestV1;
import com.netease.nim.server.sdk.im.v1.team.response.AddManagerTeamResponseV1;
import com.netease.nim.server.sdk.im.v1.team.response.AddTeamResponseV1;
import com.netease.nim.server.sdk.im.v1.team.response.BatchQueryOnlineTeamMemberCountResponseV1;
import com.netease.nim.server.sdk.im.v1.team.response.ChangeOwnerTeamResponseV1;
import com.netease.nim.server.sdk.im.v1.team.response.CreateTeamResponseV1;
import com.netease.nim.server.sdk.im.v1.team.response.DismissTeamResponseV1;
import com.netease.nim.server.sdk.im.v1.team.response.JoinsTeamResponseV1;
import com.netease.nim.server.sdk.im.v1.team.response.KickTeamResponseV1;
import com.netease.nim.server.sdk.im.v1.team.response.LeaveTeamResponseV1;
import com.netease.nim.server.sdk.im.v1.team.response.MuteTeamAllMemberResponseV1;
import com.netease.nim.server.sdk.im.v1.team.response.MuteTeamResponseV1;
import com.netease.nim.server.sdk.im.v1.team.response.MuteTeamTargetMemberResponseV1;
import com.netease.nim.server.sdk.im.v1.team.response.QueryAllJoinedTeamMemberInfoByAccIdResponseV1;
import com.netease.nim.server.sdk.im.v1.team.response.QueryMuteTeamMembersResponseV1;
import com.netease.nim.server.sdk.im.v1.team.response.QueryOnlineTeamMemberResponseV1;
import com.netease.nim.server.sdk.im.v1.team.response.QueryTeamInfoDetailsResponseV1;
import com.netease.nim.server.sdk.im.v1.team.response.QueryTeamMsgMarkReadInfoResponseV1;
import com.netease.nim.server.sdk.im.v1.team.response.QueryTeamResponseV1;
import com.netease.nim.server.sdk.im.v1.team.response.RemoveManagerTeamResponseV1;
import com.netease.nim.server.sdk.im.v1.team.response.UpdateTeamNickResponseV1;
import com.netease.nim.server.sdk.im.v1.team.response.UpdateTeamResponseV1;
import java.util.ArrayList;
import java.util.Map;

public class TeamV1Service
implements ITeamV1Service {
    private final YunxinApiHttpClient httpClient;
    private static final String failAccId = "faccid";
    private static final String accId = "accid";
    private static final String msg = "msg";
    private static final String CODE = "code";
    private static final String DESC = "desc";
    private static final String TID = "tid";

    public TeamV1Service(YunxinApiHttpClient httpClient) {
        this.httpClient = httpClient;
    }

    @Override
    public Result<CreateTeamResponseV1> createTeam(CreateTeamRequestV1 request) throws YunxinSdkException {
        YunxinApiResponse apiResponse;
        JSONObject object;
        int code;
        Map<String, String> paramMap = YunxinParamUtils.convert(request);
        if (request.getMembers() != null && !request.getMembers().isEmpty()) {
            JSONArray jsonArray = (JSONArray)JSON.toJSON(request.getMembers());
            paramMap.put("members", jsonArray.toJSONString(new JSONWriter.Feature[0]));
        }
        if ((code = (object = JSONObject.parseObject((String)(apiResponse = this.httpClient.executeV1Api("/team/create.action", paramMap)).getData())).getIntValue(CODE)) != 200) {
            return new Result<Object>(apiResponse.getEndpoint(), code, apiResponse.getTraceId(), object.getString(DESC), null);
        }
        CreateTeamResponseV1 response = new CreateTeamResponseV1();
        Long tid = object.getLong(TID);
        response.setTid(tid);
        JSONObject failAccid = object.getJSONObject(failAccId);
        if (failAccid != null) {
            response.getFaccid().setMsg(failAccid.getString(msg));
            response.getFaccid().setAccidList(JSON.parseArray((String)failAccid.getString(accId), String.class));
        }
        return new Result<CreateTeamResponseV1>(apiResponse.getEndpoint(), code, apiResponse.getTraceId(), null, response);
    }

    @Override
    public Result<DismissTeamResponseV1> dismissTeam(DismissTeamRequestV1 request) throws YunxinSdkException {
        Map<String, String> paramMap = YunxinParamUtils.convert(request);
        YunxinApiResponse apiResponse = this.httpClient.executeV1Api("/team/remove.action", paramMap);
        JSONObject object = JSONObject.parseObject((String)apiResponse.getData());
        int code = object.getIntValue(CODE);
        if (code != 200) {
            return new Result<Object>(apiResponse.getEndpoint(), code, apiResponse.getTraceId(), object.getString(DESC), null);
        }
        return new Result<DismissTeamResponseV1>(apiResponse.getEndpoint(), code, apiResponse.getTraceId(), null, new DismissTeamResponseV1());
    }

    @Override
    public Result<AddTeamResponseV1> addTeam(AddTeamRequestV1 request) throws YunxinSdkException {
        YunxinApiResponse apiResponse;
        JSONObject object;
        int code;
        Map<String, String> paramMap = YunxinParamUtils.convert(request);
        if (request.getMembers() != null && !request.getMembers().isEmpty()) {
            JSONArray jsonArray = (JSONArray)JSON.toJSON(request.getMembers());
            paramMap.put("members", jsonArray.toJSONString(new JSONWriter.Feature[0]));
        }
        if ((code = (object = JSONObject.parseObject((String)(apiResponse = this.httpClient.executeV1Api("/team/add.action", paramMap)).getData())).getIntValue(CODE)) != 200) {
            return new Result<Object>(apiResponse.getEndpoint(), code, apiResponse.getTraceId(), object.getString(DESC), null);
        }
        AddTeamResponseV1 response = new AddTeamResponseV1();
        JSONObject failAccid = object.getJSONObject(failAccId);
        if (failAccid != null) {
            response.setMsg(failAccid.getString(msg));
            response.setAccids(JSON.parseArray((String)failAccid.getString(accId), String.class));
        }
        return new Result<AddTeamResponseV1>(apiResponse.getEndpoint(), code, apiResponse.getTraceId(), null, response);
    }

    @Override
    public Result<KickTeamResponseV1> kickTeam(KickTeamRequestV1 request) throws YunxinSdkException {
        YunxinApiResponse apiResponse;
        JSONObject object;
        int code;
        Map<String, String> paramMap = YunxinParamUtils.convert(request);
        if (request.getMembers() != null && !request.getMembers().isEmpty()) {
            JSONArray jsonArray = (JSONArray)JSON.toJSON(request.getMembers());
            paramMap.put("members", jsonArray.toJSONString(new JSONWriter.Feature[0]));
        }
        if ((code = (object = JSONObject.parseObject((String)(apiResponse = this.httpClient.executeV1Api("/team/kick.action", paramMap)).getData())).getIntValue(CODE)) != 200) {
            return new Result<Object>(apiResponse.getEndpoint(), code, apiResponse.getTraceId(), object.getString(DESC), null);
        }
        KickTeamResponseV1 response = new KickTeamResponseV1();
        JSONObject failAccid = object.getJSONObject(failAccId);
        if (failAccid != null) {
            response.setMsg(failAccid.getString(msg));
            response.setAccid(JSON.parseArray((String)failAccid.getString(accId), String.class));
        }
        return new Result<KickTeamResponseV1>(apiResponse.getEndpoint(), code, apiResponse.getTraceId(), null, response);
    }

    @Override
    public Result<UpdateTeamResponseV1> updateTeam(UpdateTeamRequestV1 request) throws YunxinSdkException {
        Map<String, String> paramMap = YunxinParamUtils.convert(request);
        YunxinApiResponse apiResponse = this.httpClient.executeV1Api("/team/update.action", paramMap);
        JSONObject object = JSONObject.parseObject((String)apiResponse.getData());
        int code = object.getIntValue(CODE);
        if (code != 200) {
            return new Result<Object>(apiResponse.getEndpoint(), code, apiResponse.getTraceId(), object.getString(DESC), null);
        }
        return new Result<UpdateTeamResponseV1>(apiResponse.getEndpoint(), code, apiResponse.getTraceId(), null, new UpdateTeamResponseV1());
    }

    @Override
    public Result<QueryTeamResponseV1> queryTeam(QueryTeamRequestV1 request) throws YunxinSdkException {
        Map<String, String> paramMap = YunxinParamUtils.convert(request);
        YunxinApiResponse apiResponse = this.httpClient.executeV1Api("/team/query.action", paramMap);
        JSONObject object = JSONObject.parseObject((String)apiResponse.getData());
        int code = object.getIntValue(CODE);
        if (code != 200) {
            return new Result<Object>(apiResponse.getEndpoint(), code, apiResponse.getTraceId(), object.getString(DESC), null);
        }
        QueryTeamResponseV1 response = new QueryTeamResponseV1();
        String array = object.getString("tinfos");
        if (array != null && !array.isEmpty()) {
            JSONArray jsonArray = JSONArray.parseArray((String)array, (JSONReader.Feature[])new JSONReader.Feature[0]);
            ArrayList<QueryTeamResponseV1.TeamInfoV1> list = new ArrayList<QueryTeamResponseV1.TeamInfoV1>();
            for (Object o : jsonArray) {
                JSONObject json = (JSONObject)o;
                QueryTeamResponseV1.TeamInfoV1 responseV1 = (QueryTeamResponseV1.TeamInfoV1)JSONObject.parseObject((String)o.toString(), QueryTeamResponseV1.TeamInfoV1.class);
                responseV1.setNotifyCloseOnline(json.getBoolean("isNotifyCloseOnline"));
                responseV1.setNotifyClosePersistent(json.getBoolean("isNotifyClosePersistent"));
                list.add(responseV1);
            }
            response.setTinfos(list);
        }
        return new Result<QueryTeamResponseV1>(apiResponse.getEndpoint(), code, apiResponse.getTraceId(), null, response);
    }

    @Override
    public Result<ChangeOwnerTeamResponseV1> changeOwnerTeam(ChangeOwnerTeamRequestV1 request) throws YunxinSdkException {
        Map<String, String> paramMap = YunxinParamUtils.convert(request);
        YunxinApiResponse apiResponse = this.httpClient.executeV1Api("/team/changeOwner.action", paramMap);
        JSONObject object = JSONObject.parseObject((String)apiResponse.getData());
        int code = object.getIntValue(CODE);
        if (code != 200) {
            return new Result<Object>(apiResponse.getEndpoint(), code, apiResponse.getTraceId(), object.getString(DESC), null);
        }
        return new Result<ChangeOwnerTeamResponseV1>(apiResponse.getEndpoint(), code, apiResponse.getTraceId(), null, new ChangeOwnerTeamResponseV1());
    }

    @Override
    public Result<AddManagerTeamResponseV1> addManagerTeam(AddManagerTeamRequestV1 request) throws YunxinSdkException {
        YunxinApiResponse apiResponse;
        JSONObject object;
        int code;
        Map<String, String> paramMap = YunxinParamUtils.convert(request);
        if (request.getMembers() != null && !request.getMembers().isEmpty()) {
            JSONArray jsonArray = (JSONArray)JSON.toJSON(request.getMembers());
            paramMap.put("members", jsonArray.toJSONString(new JSONWriter.Feature[0]));
        }
        if ((code = (object = JSONObject.parseObject((String)(apiResponse = this.httpClient.executeV1Api("/team/addManager.action", paramMap)).getData())).getIntValue(CODE)) != 200) {
            return new Result<Object>(apiResponse.getEndpoint(), code, apiResponse.getTraceId(), object.getString(DESC), null);
        }
        return new Result<AddManagerTeamResponseV1>(apiResponse.getEndpoint(), code, apiResponse.getTraceId(), null, new AddManagerTeamResponseV1());
    }

    @Override
    public Result<RemoveManagerTeamResponseV1> removeManagerTeam(RemoveManagerTeamRequestV1 request) throws YunxinSdkException {
        YunxinApiResponse apiResponse;
        JSONObject object;
        int code;
        Map<String, String> paramMap = YunxinParamUtils.convert(request);
        if (request.getMembers() != null && !request.getMembers().isEmpty()) {
            JSONArray jsonArray = (JSONArray)JSON.toJSON(request.getMembers());
            paramMap.put("members", jsonArray.toJSONString(new JSONWriter.Feature[0]));
        }
        if ((code = (object = JSONObject.parseObject((String)(apiResponse = this.httpClient.executeV1Api("/team/removeManager.action", paramMap)).getData())).getIntValue(CODE)) != 200) {
            return new Result<Object>(apiResponse.getEndpoint(), code, apiResponse.getTraceId(), object.getString(DESC), null);
        }
        return new Result<RemoveManagerTeamResponseV1>(apiResponse.getEndpoint(), code, apiResponse.getTraceId(), null, new RemoveManagerTeamResponseV1());
    }

    @Override
    public Result<JoinsTeamResponseV1> queryJoinedTeamListByAccId(JoinsTeamRequestV1 request) throws YunxinSdkException {
        Map<String, String> paramMap = YunxinParamUtils.convert(request);
        YunxinApiResponse apiResponse = this.httpClient.executeV1Api("/team/joinTeams.action", paramMap);
        JSONObject object = JSONObject.parseObject((String)apiResponse.getData());
        int code = object.getIntValue(CODE);
        if (code != 200) {
            return new Result<Object>(apiResponse.getEndpoint(), code, apiResponse.getTraceId(), object.getString(DESC), null);
        }
        JoinsTeamResponseV1 response = new JoinsTeamResponseV1();
        String array = object.getString("infos");
        if (array != null && !array.isEmpty()) {
            response.setInfos(JSON.parseArray((String)array, JoinsTeamResponseV1.JoinsTinfo.class));
        }
        return new Result<JoinsTeamResponseV1>(apiResponse.getEndpoint(), code, apiResponse.getTraceId(), null, response);
    }

    @Override
    public Result<UpdateTeamNickResponseV1> updateTeamMemberNick(UpdateTeamNickRequestV1 request) throws YunxinSdkException {
        Map<String, String> paramMap = YunxinParamUtils.convert(request);
        YunxinApiResponse apiResponse = this.httpClient.executeV1Api("/team/updateTeamNick.action", paramMap);
        JSONObject object = JSONObject.parseObject((String)apiResponse.getData());
        int code = object.getIntValue(CODE);
        if (code != 200) {
            return new Result<Object>(apiResponse.getEndpoint(), code, apiResponse.getTraceId(), object.getString(DESC), null);
        }
        return new Result<UpdateTeamNickResponseV1>(apiResponse.getEndpoint(), code, apiResponse.getTraceId(), null, new UpdateTeamNickResponseV1());
    }

    @Override
    public Result<LeaveTeamResponseV1> leaveTeam(LeaveTeamRequestV1 request) throws YunxinSdkException {
        Map<String, String> paramMap = YunxinParamUtils.convert(request);
        YunxinApiResponse apiResponse = this.httpClient.executeV1Api("/team/leave.action", paramMap);
        JSONObject object = JSONObject.parseObject((String)apiResponse.getData());
        int code = object.getIntValue(CODE);
        if (code != 200) {
            return new Result<Object>(apiResponse.getEndpoint(), code, apiResponse.getTraceId(), object.getString(DESC), null);
        }
        return new Result<LeaveTeamResponseV1>(apiResponse.getEndpoint(), code, apiResponse.getTraceId(), null, new LeaveTeamResponseV1());
    }

    @Override
    public Result<MuteTeamResponseV1> muteTeam(MuteTeamRequestV1 request) throws YunxinSdkException {
        Map<String, String> paramMap = YunxinParamUtils.convert(request);
        YunxinApiResponse apiResponse = this.httpClient.executeV1Api("/team/muteTeam.action", paramMap);
        JSONObject object = JSONObject.parseObject((String)apiResponse.getData());
        int code = object.getIntValue(CODE);
        if (code != 200) {
            return new Result<Object>(apiResponse.getEndpoint(), code, apiResponse.getTraceId(), object.getString(DESC), null);
        }
        return new Result<MuteTeamResponseV1>(apiResponse.getEndpoint(), code, apiResponse.getTraceId(), null, new MuteTeamResponseV1());
    }

    @Override
    public Result<MuteTeamTargetMemberResponseV1> muteTeamTargetMember(MuteTeamTargetMemberRequestV1 request) throws YunxinSdkException {
        Map<String, String> paramMap = YunxinParamUtils.convert(request);
        YunxinApiResponse apiResponse = this.httpClient.executeV1Api("/team/muteTlist.action", paramMap);
        JSONObject object = JSONObject.parseObject((String)apiResponse.getData());
        int code = object.getIntValue(CODE);
        if (code != 200) {
            return new Result<Object>(apiResponse.getEndpoint(), code, apiResponse.getTraceId(), object.getString(DESC), null);
        }
        return new Result<MuteTeamTargetMemberResponseV1>(apiResponse.getEndpoint(), code, apiResponse.getTraceId(), null, new MuteTeamTargetMemberResponseV1());
    }

    @Override
    public Result<MuteTeamAllMemberResponseV1> muteTeamAllMember(MuteTeamAllMemberRequestV1 request) throws YunxinSdkException {
        Map<String, String> paramMap = YunxinParamUtils.convert(request);
        YunxinApiResponse apiResponse = this.httpClient.executeV1Api("/team/muteTlistAll.action", paramMap);
        JSONObject object = JSONObject.parseObject((String)apiResponse.getData());
        int code = object.getIntValue(CODE);
        if (code != 200) {
            return new Result<Object>(apiResponse.getEndpoint(), code, apiResponse.getTraceId(), object.getString(DESC), null);
        }
        return new Result<MuteTeamAllMemberResponseV1>(apiResponse.getEndpoint(), code, apiResponse.getTraceId(), null, new MuteTeamAllMemberResponseV1());
    }

    @Override
    public Result<QueryMuteTeamMembersResponseV1> queryMuteTeamMembers(QueryMuteTeamMembersRequestV1 request) throws YunxinSdkException {
        Map<String, String> paramMap = YunxinParamUtils.convert(request);
        YunxinApiResponse apiResponse = this.httpClient.executeV1Api("/team/listTeamMute.action", paramMap);
        JSONObject object = JSONObject.parseObject((String)apiResponse.getData());
        int code = object.getIntValue(CODE);
        if (code != 200) {
            return new Result<Object>(apiResponse.getEndpoint(), code, apiResponse.getTraceId(), object.getString(DESC), null);
        }
        QueryMuteTeamMembersResponseV1 response = new QueryMuteTeamMembersResponseV1();
        String array = object.getString("mutes");
        if (array != null && !array.isEmpty()) {
            response.setMutes(JSON.parseArray((String)array, QueryMuteTeamMembersResponseV1.MuteInfo.class));
        }
        return new Result<QueryMuteTeamMembersResponseV1>(apiResponse.getEndpoint(), code, apiResponse.getTraceId(), null, response);
    }

    @Override
    public Result<QueryTeamInfoDetailsResponseV1> queryTeamInfoDetails(QueryTeamInfoDetailsRequestV1 request) throws YunxinSdkException {
        Map<String, String> paramMap = YunxinParamUtils.convert(request);
        YunxinApiResponse apiResponse = this.httpClient.executeV1Api("/team/queryDetail.action", paramMap);
        JSONObject object = JSONObject.parseObject((String)apiResponse.getData());
        int code = object.getIntValue(CODE);
        if (code != 200) {
            return new Result<Object>(apiResponse.getEndpoint(), code, apiResponse.getTraceId(), object.getString(DESC), null);
        }
        QueryTeamInfoDetailsResponseV1 response = new QueryTeamInfoDetailsResponseV1();
        JSONObject tInfo = object.getJSONObject("tinfo");
        if (tInfo != null && !tInfo.isEmpty()) {
            response.setTinfo((QueryTeamInfoDetailsResponseV1.TeamInfo)JSONObject.parseObject((String)tInfo.toJSONString(new JSONWriter.Feature[0]), QueryTeamInfoDetailsResponseV1.TeamInfo.class));
        }
        return new Result<QueryTeamInfoDetailsResponseV1>(apiResponse.getEndpoint(), code, apiResponse.getTraceId(), null, response);
    }

    @Override
    public Result<QueryTeamMsgMarkReadInfoResponseV1> queryTeamMsgMarkReadInfo(QueryTeamMsgMarkReadInfoRequestV1 request) throws YunxinSdkException {
        Map<String, String> paramMap = YunxinParamUtils.convert(request);
        YunxinApiResponse apiResponse = this.httpClient.executeV1Api("/team/getMarkReadInfo.action", paramMap);
        JSONObject object = JSONObject.parseObject((String)apiResponse.getData());
        int code = object.getIntValue(CODE);
        if (code != 200) {
            return new Result<Object>(apiResponse.getEndpoint(), code, apiResponse.getTraceId(), object.getString(DESC), null);
        }
        QueryTeamMsgMarkReadInfoResponseV1 response = new QueryTeamMsgMarkReadInfoResponseV1();
        JSONObject data = object.getJSONObject("data");
        if (data != null && !data.isEmpty()) {
            response.setData((QueryTeamMsgMarkReadInfoResponseV1.TeamMsgMarkReadInfo)JSONObject.parseObject((String)data.toJSONString(new JSONWriter.Feature[0]), QueryTeamMsgMarkReadInfoResponseV1.TeamMsgMarkReadInfo.class));
        }
        return new Result<QueryTeamMsgMarkReadInfoResponseV1>(apiResponse.getEndpoint(), code, apiResponse.getTraceId(), null, response);
    }

    @Override
    public Result<QueryAllJoinedTeamMemberInfoByAccIdResponseV1> queryAllJoinedTeamMemberInfoByAccId(QueryAllJoinedTeamMemberInfoByAccIdRequestV1 request) throws YunxinSdkException {
        Map<String, String> paramMap = YunxinParamUtils.convert(request);
        YunxinApiResponse apiResponse = this.httpClient.executeV1Api("/team/listMemberInfo.action", paramMap);
        JSONObject object = JSONObject.parseObject((String)apiResponse.getData());
        int code = object.getIntValue(CODE);
        if (code != 200) {
            return new Result<Object>(apiResponse.getEndpoint(), code, apiResponse.getTraceId(), object.getString(DESC), null);
        }
        QueryAllJoinedTeamMemberInfoByAccIdResponseV1 response = new QueryAllJoinedTeamMemberInfoByAccIdResponseV1();
        String data = object.getString("data");
        if (data != null && !data.isEmpty()) {
            response.setData(JSON.parseArray((String)data, QueryAllJoinedTeamMemberInfoByAccIdResponseV1.TeamMemberInfo.class));
        }
        return new Result<QueryAllJoinedTeamMemberInfoByAccIdResponseV1>(apiResponse.getEndpoint(), code, apiResponse.getTraceId(), null, response);
    }

    @Override
    public Result<QueryOnlineTeamMemberResponseV1> queryOnlineTeamMember(QueryOnlineTeamMemberRequestV1 request) throws YunxinSdkException {
        Map<String, String> paramMap = YunxinParamUtils.convert(request);
        YunxinApiResponse apiResponse = this.httpClient.executeV1Api("/team/listOnlineUsers.action", paramMap);
        JSONObject object = JSONObject.parseObject((String)apiResponse.getData());
        int code = object.getIntValue(CODE);
        if (code != 200) {
            return new Result<Object>(apiResponse.getEndpoint(), code, apiResponse.getTraceId(), object.getString(DESC), null);
        }
        QueryOnlineTeamMemberResponseV1 response = new QueryOnlineTeamMemberResponseV1();
        JSONObject data = object.getJSONObject("data");
        if (data != null) {
            response.setCount(data.getIntValue("count"));
            ArrayList<QueryOnlineTeamMemberResponseV1.OnlineStatus> onlineStatusList = new ArrayList<QueryOnlineTeamMemberResponseV1.OnlineStatus>();
            JSONObject onlineStatus = data.getJSONObject("status");
            if (onlineStatus != null) {
                for (Map.Entry entry : onlineStatus.entrySet()) {
                    QueryOnlineTeamMemberResponseV1.OnlineStatus OnlineStatus2 = new QueryOnlineTeamMemberResponseV1.OnlineStatus();
                    ArrayList<QueryOnlineTeamMemberResponseV1.Status> statusList = new ArrayList<QueryOnlineTeamMemberResponseV1.Status>();
                    String accId = (String)entry.getKey();
                    OnlineStatus2.setAccid(accId);
                    JSONArray array = (JSONArray)entry.getValue();
                    for (Object o : array) {
                        JSONObject json = (JSONObject)o;
                        QueryOnlineTeamMemberResponseV1.Status status = new QueryOnlineTeamMemberResponseV1.Status();
                        status.setClientType(json.getIntValue("clientType"));
                        status.setLoginTime(json.getLongValue("loginTime"));
                        statusList.add(status);
                    }
                    OnlineStatus2.setStatusList(statusList);
                    onlineStatusList.add(OnlineStatus2);
                }
            }
            response.setStatus(onlineStatusList);
        }
        return new Result<QueryOnlineTeamMemberResponseV1>(apiResponse.getEndpoint(), code, apiResponse.getTraceId(), null, response);
    }

    @Override
    public Result<BatchQueryOnlineTeamMemberCountResponseV1> batchQueryOnlineTeamMemberCount(BatchQueryOnlineTeamMemberCountRequestV1 request) throws YunxinSdkException {
        Map<String, String> paramMap = YunxinParamUtils.convert(request);
        YunxinApiResponse apiResponse = this.httpClient.executeV1Api("/team/listOnlineUserCount.action", paramMap);
        JSONObject object = JSONObject.parseObject((String)apiResponse.getData());
        int code = object.getIntValue(CODE);
        if (code != 200) {
            return new Result<Object>(apiResponse.getEndpoint(), code, apiResponse.getTraceId(), object.getString(DESC), null);
        }
        BatchQueryOnlineTeamMemberCountResponseV1 response = new BatchQueryOnlineTeamMemberCountResponseV1();
        String data = object.getString("data");
        if (data != null && !data.isEmpty()) {
            response.setData(JSON.parseArray((String)data, BatchQueryOnlineTeamMemberCountResponseV1.teamOnlineCount.class));
        }
        return new Result<BatchQueryOnlineTeamMemberCountResponseV1>(apiResponse.getEndpoint(), code, apiResponse.getTraceId(), null, response);
    }
}

