/*
 * Decompiled with CFR 0.152.
 */
package com.netease.nim.server.sdk.im.v1.chatroom;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.JSONWriter;
import com.netease.nim.server.sdk.core.Result;
import com.netease.nim.server.sdk.core.YunxinApiHttpClient;
import com.netease.nim.server.sdk.core.YunxinApiResponse;
import com.netease.nim.server.sdk.core.exception.YunxinSdkException;
import com.netease.nim.server.sdk.im.v1.annotation.YunxinParamUtils;
import com.netease.nim.server.sdk.im.v1.chatroom.IChatRoomV1Service;
import com.netease.nim.server.sdk.im.v1.chatroom.request.AddRobotRequestV1;
import com.netease.nim.server.sdk.im.v1.chatroom.request.CleanRobotRequestV1;
import com.netease.nim.server.sdk.im.v1.chatroom.request.CreateChatroomRequestV1;
import com.netease.nim.server.sdk.im.v1.chatroom.request.KickMemberRequestV1;
import com.netease.nim.server.sdk.im.v1.chatroom.request.MuteRoomRequestV1;
import com.netease.nim.server.sdk.im.v1.chatroom.request.QueryChatroomAddressRequestV1;
import com.netease.nim.server.sdk.im.v1.chatroom.request.QueryChatroomInfoRequestV1;
import com.netease.nim.server.sdk.im.v1.chatroom.request.QueryChatroomInfosRequestV1;
import com.netease.nim.server.sdk.im.v1.chatroom.request.QueryMembersByPageRequestV1;
import com.netease.nim.server.sdk.im.v1.chatroom.request.QueryMembersByRolesRequestV1;
import com.netease.nim.server.sdk.im.v1.chatroom.request.QueryMembersRequestV1;
import com.netease.nim.server.sdk.im.v1.chatroom.request.QueryTagHistoryMsgRequestV1;
import com.netease.nim.server.sdk.im.v1.chatroom.request.QueryUserRoomIdsRequestV1;
import com.netease.nim.server.sdk.im.v1.chatroom.request.QueueBatchOfferRequestV1;
import com.netease.nim.server.sdk.im.v1.chatroom.request.QueueBatchUpdateRequestV1;
import com.netease.nim.server.sdk.im.v1.chatroom.request.QueueDropRequestV1;
import com.netease.nim.server.sdk.im.v1.chatroom.request.QueueGetRequestV1;
import com.netease.nim.server.sdk.im.v1.chatroom.request.QueueInitRequestV1;
import com.netease.nim.server.sdk.im.v1.chatroom.request.QueueListRequestV1;
import com.netease.nim.server.sdk.im.v1.chatroom.request.QueueOfferRequestV1;
import com.netease.nim.server.sdk.im.v1.chatroom.request.QueuePollRequestV1;
import com.netease.nim.server.sdk.im.v1.chatroom.request.RemoveRobotRequestV1;
import com.netease.nim.server.sdk.im.v1.chatroom.request.SetMemberRoleRequestV1;
import com.netease.nim.server.sdk.im.v1.chatroom.request.TagMembersCountRequestV1;
import com.netease.nim.server.sdk.im.v1.chatroom.request.TagMembersQueryRequestV1;
import com.netease.nim.server.sdk.im.v1.chatroom.request.TagTemporaryMuteRequestV1;
import com.netease.nim.server.sdk.im.v1.chatroom.request.TemporaryMuteRequestV1;
import com.netease.nim.server.sdk.im.v1.chatroom.request.ToggleCloseChatroomStatRequestV1;
import com.netease.nim.server.sdk.im.v1.chatroom.request.UpdateChatRoomRoleTagRequestV1;
import com.netease.nim.server.sdk.im.v1.chatroom.request.UpdateChatroomDelayClosePolicyRequestV1;
import com.netease.nim.server.sdk.im.v1.chatroom.request.UpdateChatroomInOutNotificationRequestV1;
import com.netease.nim.server.sdk.im.v1.chatroom.request.UpdateChatroomRequestV1;
import com.netease.nim.server.sdk.im.v1.chatroom.request.UpdateMyRoomRoleRequestV1;
import com.netease.nim.server.sdk.im.v1.chatroom.response.AddRobotResponseV1;
import com.netease.nim.server.sdk.im.v1.chatroom.response.CleanRobotResponseV1;
import com.netease.nim.server.sdk.im.v1.chatroom.response.CreateChatroomResponseV1;
import com.netease.nim.server.sdk.im.v1.chatroom.response.KickMemberResponseV1;
import com.netease.nim.server.sdk.im.v1.chatroom.response.MuteRoomResponseV1;
import com.netease.nim.server.sdk.im.v1.chatroom.response.QueryChatroomAddressResponseV1;
import com.netease.nim.server.sdk.im.v1.chatroom.response.QueryChatroomInfoResponseV1;
import com.netease.nim.server.sdk.im.v1.chatroom.response.QueryChatroomInfosResponseV1;
import com.netease.nim.server.sdk.im.v1.chatroom.response.QueryMembersByPageResponseV1;
import com.netease.nim.server.sdk.im.v1.chatroom.response.QueryMembersByRolesResponseV1;
import com.netease.nim.server.sdk.im.v1.chatroom.response.QueryMembersResponseV1;
import com.netease.nim.server.sdk.im.v1.chatroom.response.QueryTagHistoryMsgResponseV1;
import com.netease.nim.server.sdk.im.v1.chatroom.response.QueryUserRoomIdsResponseV1;
import com.netease.nim.server.sdk.im.v1.chatroom.response.QueueBatchOfferResponseV1;
import com.netease.nim.server.sdk.im.v1.chatroom.response.QueueBatchUpdateResponseV1;
import com.netease.nim.server.sdk.im.v1.chatroom.response.QueueDropResponseV1;
import com.netease.nim.server.sdk.im.v1.chatroom.response.QueueGetResponseV1;
import com.netease.nim.server.sdk.im.v1.chatroom.response.QueueInitResponseV1;
import com.netease.nim.server.sdk.im.v1.chatroom.response.QueueListResponseV1;
import com.netease.nim.server.sdk.im.v1.chatroom.response.QueueOfferResponseV1;
import com.netease.nim.server.sdk.im.v1.chatroom.response.QueuePollResponseV1;
import com.netease.nim.server.sdk.im.v1.chatroom.response.RemoveRobotResponseV1;
import com.netease.nim.server.sdk.im.v1.chatroom.response.SetMemberRoleResponseV1;
import com.netease.nim.server.sdk.im.v1.chatroom.response.TagMembersCountResponseV1;
import com.netease.nim.server.sdk.im.v1.chatroom.response.TagMembersQueryResponseV1;
import com.netease.nim.server.sdk.im.v1.chatroom.response.TagTemporaryMuteResponseV1;
import com.netease.nim.server.sdk.im.v1.chatroom.response.TemporaryMuteResponseV1;
import com.netease.nim.server.sdk.im.v1.chatroom.response.ToggleCloseChatroomStatResponseV1;
import com.netease.nim.server.sdk.im.v1.chatroom.response.UpdateChatRoomRoleTagResponseV1;
import com.netease.nim.server.sdk.im.v1.chatroom.response.UpdateChatroomDelayClosePolicyResponseV1;
import com.netease.nim.server.sdk.im.v1.chatroom.response.UpdateChatroomInOutNotificationResponseV1;
import com.netease.nim.server.sdk.im.v1.chatroom.response.UpdateChatroomResponseV1;
import com.netease.nim.server.sdk.im.v1.chatroom.response.UpdateMyRoomRoleResponseV1;
import java.util.ArrayList;
import java.util.Map;

public class ChatRoomV1Service
implements IChatRoomV1Service {
    private final YunxinApiHttpClient httpClient;
    private static final String msg = "msg";
    private static final String CODE = "code";
    private static final String DESC = "desc";
    private static final String DATA = "data";

    public ChatRoomV1Service(YunxinApiHttpClient httpClient) {
        this.httpClient = httpClient;
    }

    @Override
    public Result<CreateChatroomResponseV1> createChatroom(CreateChatroomRequestV1 request) throws YunxinSdkException {
        Map<String, String> paramMap = YunxinParamUtils.convert(request);
        YunxinApiResponse apiResponse = this.httpClient.executeV1Api("/chatroom/create.action", paramMap);
        JSONObject object = JSONObject.parseObject((String)apiResponse.getData());
        int code = object.getIntValue(CODE);
        if (code != 200) {
            return new Result<Object>(apiResponse.getEndpoint(), code, apiResponse.getTraceId(), object.getString(DESC), null);
        }
        CreateChatroomResponseV1 response = (CreateChatroomResponseV1)object.getObject("chatroom", CreateChatroomResponseV1.class, new JSONReader.Feature[0]);
        return new Result<CreateChatroomResponseV1>(apiResponse.getEndpoint(), code, apiResponse.getTraceId(), null, response);
    }

    @Override
    public Result<UpdateChatroomResponseV1> updateChatroom(UpdateChatroomRequestV1 request) throws YunxinSdkException {
        Map<String, String> paramMap = YunxinParamUtils.convert(request);
        YunxinApiResponse apiResponse = this.httpClient.executeV1Api("/chatroom/update.action", paramMap);
        JSONObject object = JSONObject.parseObject((String)apiResponse.getData());
        int code = object.getIntValue(CODE);
        if (code != 200) {
            return new Result<Object>(apiResponse.getEndpoint(), code, apiResponse.getTraceId(), object.getString(DESC), null);
        }
        UpdateChatroomResponseV1 response = (UpdateChatroomResponseV1)object.getObject("chatroom", UpdateChatroomResponseV1.class, new JSONReader.Feature[0]);
        return new Result<UpdateChatroomResponseV1>(apiResponse.getEndpoint(), code, apiResponse.getTraceId(), null, response);
    }

    @Override
    public Result<QueryChatroomAddressResponseV1> queryChatroomAddress(QueryChatroomAddressRequestV1 request) throws YunxinSdkException {
        Map<String, String> paramMap = YunxinParamUtils.convert(request);
        YunxinApiResponse apiResponse = this.httpClient.executeV1Api("/chatroom/requestAddr.action", paramMap);
        JSONObject object = JSONObject.parseObject((String)apiResponse.getData());
        int code = object.getIntValue(CODE);
        if (code != 200) {
            return new Result<Object>(apiResponse.getEndpoint(), code, apiResponse.getTraceId(), object.getString(DESC), null);
        }
        QueryChatroomAddressResponseV1 response = new QueryChatroomAddressResponseV1();
        String addr = object.getString("addr");
        if (addr != null && !addr.isEmpty()) {
            response.setChatroomAddress(JSON.parseArray((String)addr, String.class));
        }
        return new Result<QueryChatroomAddressResponseV1>(apiResponse.getEndpoint(), code, apiResponse.getTraceId(), null, response);
    }

    @Override
    public Result<QueryChatroomInfoResponseV1> queryChatroomInfo(QueryChatroomInfoRequestV1 request) throws YunxinSdkException {
        Map<String, String> paramMap = YunxinParamUtils.convert(request);
        YunxinApiResponse apiResponse = this.httpClient.executeV1Api("/chatroom/get.action", paramMap);
        JSONObject object = JSONObject.parseObject((String)apiResponse.getData());
        int code = object.getIntValue(CODE);
        if (code != 200) {
            return new Result<Object>(apiResponse.getEndpoint(), code, apiResponse.getTraceId(), object.getString(DESC), null);
        }
        QueryChatroomInfoResponseV1 response = (QueryChatroomInfoResponseV1)object.getObject("chatroom", QueryChatroomInfoResponseV1.class, new JSONReader.Feature[0]);
        return new Result<QueryChatroomInfoResponseV1>(apiResponse.getEndpoint(), code, apiResponse.getTraceId(), null, response);
    }

    @Override
    public Result<QueryChatroomInfosResponseV1> queryChatroomInfos(QueryChatroomInfosRequestV1 request) throws YunxinSdkException {
        String failArray;
        String noExistArray;
        Map<String, String> paramMap = YunxinParamUtils.convert(request);
        YunxinApiResponse apiResponse = this.httpClient.executeV1Api("/chatroom/getBatch.action", paramMap);
        JSONObject object = JSONObject.parseObject((String)apiResponse.getData());
        int code = object.getIntValue(CODE);
        if (code != 200) {
            return new Result<Object>(apiResponse.getEndpoint(), code, apiResponse.getTraceId(), object.getString(DESC), null);
        }
        QueryChatroomInfosResponseV1 response = new QueryChatroomInfosResponseV1();
        String array = object.getString("succRooms");
        if (array != null && !array.isEmpty()) {
            response.setRoomInfos(JSONArray.parseArray((String)array, QueryChatroomInfosResponseV1.RoomInfo.class));
        }
        if ((noExistArray = object.getString("noExistRooms")) != null && !noExistArray.isEmpty()) {
            response.setNoExistRooms(JSONArray.parseArray((String)noExistArray, Long.class));
        }
        if ((failArray = object.getString("failRooms")) != null && !failArray.isEmpty()) {
            response.setFailRooms(JSONArray.parseArray((String)failArray, Long.class));
        }
        return new Result<QueryChatroomInfosResponseV1>(apiResponse.getEndpoint(), code, apiResponse.getTraceId(), null, response);
    }

    @Override
    public Result<ToggleCloseChatroomStatResponseV1> toggleCloseChatroomStat(ToggleCloseChatroomStatRequestV1 request) throws YunxinSdkException {
        Map<String, String> paramMap = YunxinParamUtils.convert(request);
        YunxinApiResponse apiResponse = this.httpClient.executeV1Api("/chatroom/toggleCloseStat.action", paramMap);
        JSONObject object = JSONObject.parseObject((String)apiResponse.getData());
        int code = object.getIntValue(CODE);
        if (code != 200) {
            return new Result<Object>(apiResponse.getEndpoint(), code, apiResponse.getTraceId(), object.getString(DESC), null);
        }
        ToggleCloseChatroomStatResponseV1 response = (ToggleCloseChatroomStatResponseV1)object.getObject(DESC, ToggleCloseChatroomStatResponseV1.class, new JSONReader.Feature[0]);
        return new Result<ToggleCloseChatroomStatResponseV1>(apiResponse.getEndpoint(), code, apiResponse.getTraceId(), null, response);
    }

    @Override
    public Result<UpdateChatroomDelayClosePolicyResponseV1> updateDelayClosePolicy(UpdateChatroomDelayClosePolicyRequestV1 request) throws YunxinSdkException {
        Map<String, String> paramMap = YunxinParamUtils.convert(request);
        YunxinApiResponse apiResponse = this.httpClient.executeV1Api("/chatroom/updateDelayClosePolicy.action", paramMap);
        JSONObject object = JSONObject.parseObject((String)apiResponse.getData());
        int code = object.getIntValue(CODE);
        if (code != 200) {
            return new Result<Object>(apiResponse.getEndpoint(), code, apiResponse.getTraceId(), object.getString(DESC), null);
        }
        UpdateChatroomDelayClosePolicyResponseV1 response = (UpdateChatroomDelayClosePolicyResponseV1)object.getObject("chatroom", UpdateChatroomDelayClosePolicyResponseV1.class, new JSONReader.Feature[0]);
        return new Result<UpdateChatroomDelayClosePolicyResponseV1>(apiResponse.getEndpoint(), code, apiResponse.getTraceId(), null, response);
    }

    @Override
    public Result<UpdateChatroomInOutNotificationResponseV1> updateChatroomInOutNotification(UpdateChatroomInOutNotificationRequestV1 request) throws YunxinSdkException {
        Map<String, String> paramMap = YunxinParamUtils.convert(request);
        YunxinApiResponse apiResponse = this.httpClient.executeV1Api("/chatroom/updateInOutNotification.action", paramMap);
        JSONObject object = JSONObject.parseObject((String)apiResponse.getData());
        int code = object.getIntValue(CODE);
        if (code != 200) {
            return new Result<Object>(apiResponse.getEndpoint(), code, apiResponse.getTraceId(), object.getString(DESC), null);
        }
        return new Result<UpdateChatroomInOutNotificationResponseV1>(apiResponse.getEndpoint(), code, apiResponse.getTraceId(), null, new UpdateChatroomInOutNotificationResponseV1());
    }

    @Override
    public Result<KickMemberResponseV1> kickMember(KickMemberRequestV1 request) throws YunxinSdkException {
        Map<String, String> paramMap = YunxinParamUtils.convert(request);
        YunxinApiResponse apiResponse = this.httpClient.executeV1Api("/chatroom/kickMember.action", paramMap);
        JSONObject object = JSONObject.parseObject((String)apiResponse.getData());
        int code = object.getIntValue(CODE);
        if (code != 200) {
            return new Result<Object>(apiResponse.getEndpoint(), code, apiResponse.getTraceId(), object.getString(DESC), null);
        }
        return new Result<KickMemberResponseV1>(apiResponse.getEndpoint(), code, apiResponse.getTraceId(), null, new KickMemberResponseV1());
    }

    @Override
    public Result<SetMemberRoleResponseV1> setMemberRole(SetMemberRoleRequestV1 request) throws YunxinSdkException {
        Map<String, String> paramMap = YunxinParamUtils.convert(request);
        YunxinApiResponse apiResponse = this.httpClient.executeV1Api("/chatroom/setMemberRole.action", paramMap);
        JSONObject object = JSONObject.parseObject((String)apiResponse.getData());
        int code = object.getIntValue(CODE);
        if (code != 200) {
            return new Result<Object>(apiResponse.getEndpoint(), code, apiResponse.getTraceId(), object.getString(DESC), null);
        }
        SetMemberRoleResponseV1 response = (SetMemberRoleResponseV1)object.getObject(DESC, SetMemberRoleResponseV1.class, new JSONReader.Feature[0]);
        return new Result<SetMemberRoleResponseV1>(apiResponse.getEndpoint(), code, apiResponse.getTraceId(), null, response);
    }

    @Override
    public Result<UpdateMyRoomRoleResponseV1> updateMyRoomRole(UpdateMyRoomRoleRequestV1 request) throws YunxinSdkException {
        Map<String, String> paramMap = YunxinParamUtils.convert(request);
        YunxinApiResponse apiResponse = this.httpClient.executeV1Api("/chatroom/updateMyRoomRole.action", paramMap);
        JSONObject object = JSONObject.parseObject((String)apiResponse.getData());
        int code = object.getIntValue(CODE);
        if (code != 200) {
            return new Result<Object>(apiResponse.getEndpoint(), code, apiResponse.getTraceId(), object.getString(DESC), null);
        }
        return new Result<UpdateMyRoomRoleResponseV1>(apiResponse.getEndpoint(), code, apiResponse.getTraceId(), null, new UpdateMyRoomRoleResponseV1());
    }

    @Override
    public Result<QueryMembersByPageResponseV1> membersByPage(QueryMembersByPageRequestV1 request) throws YunxinSdkException {
        JSONObject js;
        Map<String, String> paramMap = YunxinParamUtils.convert(request);
        YunxinApiResponse apiResponse = this.httpClient.executeV1Api("/chatroom/membersByPage.action", paramMap);
        JSONObject object = JSONObject.parseObject((String)apiResponse.getData());
        int code = object.getIntValue(CODE);
        if (code != 200) {
            return new Result<Object>(apiResponse.getEndpoint(), code, apiResponse.getTraceId(), object.getString(DESC), null);
        }
        QueryMembersByPageResponseV1 response = new QueryMembersByPageResponseV1();
        String array = object.getString(DESC);
        if (array != null && !array.isEmpty() && !(js = JSONObject.parseObject((String)array)).isEmpty() && js.containsKey(DATA)) {
            response.setData(JSON.parseArray((String)js.getString(DATA), QueryMembersByPageResponseV1.QueryMembersByPage.class));
        }
        return new Result<QueryMembersByPageResponseV1>(apiResponse.getEndpoint(), code, apiResponse.getTraceId(), null, response);
    }

    @Override
    public Result<QueryMembersByRolesResponseV1> membersByRoles(QueryMembersByRolesRequestV1 request) throws YunxinSdkException {
        JSONObject js;
        Map<String, String> paramMap = YunxinParamUtils.convert(request);
        YunxinApiResponse apiResponse = this.httpClient.executeV1Api("/chatroom/queryMembersByRole.action", paramMap);
        JSONObject object = JSONObject.parseObject((String)apiResponse.getData());
        int code = object.getIntValue(CODE);
        if (code != 200) {
            return new Result<Object>(apiResponse.getEndpoint(), code, apiResponse.getTraceId(), object.getString(DESC), null);
        }
        QueryMembersByRolesResponseV1 response = new QueryMembersByRolesResponseV1();
        String array = object.getString(DESC);
        if (array != null && !array.isEmpty() && !(js = JSONObject.parseObject((String)array)).isEmpty() && js.containsKey(DATA)) {
            response.setData(JSON.parseArray((String)js.getString(DATA), QueryMembersByRolesResponseV1.QueryMembersByRoles.class));
        }
        return new Result<QueryMembersByRolesResponseV1>(apiResponse.getEndpoint(), code, apiResponse.getTraceId(), null, response);
    }

    @Override
    public Result<QueryMembersResponseV1> queryMembers(QueryMembersRequestV1 request) throws YunxinSdkException {
        JSONObject js;
        Map<String, String> paramMap = YunxinParamUtils.convert(request);
        paramMap.put("accids", JSONArray.toJSONString(request.getAccids(), (JSONWriter.Feature[])new JSONWriter.Feature[0]));
        YunxinApiResponse apiResponse = this.httpClient.executeV1Api("/chatroom/queryMembers.action", paramMap);
        JSONObject object = JSONObject.parseObject((String)apiResponse.getData());
        int code = object.getIntValue(CODE);
        if (code != 200) {
            return new Result<Object>(apiResponse.getEndpoint(), code, apiResponse.getTraceId(), object.getString(DESC), null);
        }
        QueryMembersResponseV1 response = new QueryMembersResponseV1();
        String array = object.getString(DESC);
        if (array != null && !array.isEmpty() && !(js = JSONObject.parseObject((String)array)).isEmpty() && js.containsKey(DATA)) {
            response.setData(JSON.parseArray((String)js.getString(DATA), QueryMembersResponseV1.QueryMembers.class));
        }
        return new Result<QueryMembersResponseV1>(apiResponse.getEndpoint(), code, apiResponse.getTraceId(), null, response);
    }

    @Override
    public Result<AddRobotResponseV1> addRobot(AddRobotRequestV1 request) throws YunxinSdkException {
        Map<String, String> paramMap = YunxinParamUtils.convert(request);
        paramMap.put("accids", JSONArray.toJSONString(request.getAccids(), (JSONWriter.Feature[])new JSONWriter.Feature[0]));
        YunxinApiResponse apiResponse = this.httpClient.executeV1Api("/chatroom/addRobot.action", paramMap);
        JSONObject object = JSONObject.parseObject((String)apiResponse.getData());
        int code = object.getIntValue(CODE);
        if (code != 200) {
            return new Result<Object>(apiResponse.getEndpoint(), code, apiResponse.getTraceId(), object.getString(DESC), null);
        }
        AddRobotResponseV1 response = new AddRobotResponseV1();
        String array = object.getString(DESC);
        if (array != null && !array.isEmpty()) {
            JSONObject js = JSONObject.parseObject((String)array);
            if (js != null && !js.isEmpty() && js.containsKey("failAccids")) {
                response.setFailAccids(JSON.parseArray((String)js.getString("failAccids"), String.class));
            }
            if (js != null && !js.isEmpty() && js.containsKey("successAccids")) {
                response.setSuccessAccids(JSON.parseArray((String)js.getString("successAccids"), String.class));
            }
            if (js != null && !js.isEmpty() && js.containsKey("oldAccids")) {
                response.setOldAccids(JSON.parseArray((String)js.getString("oldAccids"), String.class));
            }
        }
        return new Result<AddRobotResponseV1>(apiResponse.getEndpoint(), code, apiResponse.getTraceId(), null, response);
    }

    @Override
    public Result<RemoveRobotResponseV1> removeRobot(RemoveRobotRequestV1 request) throws YunxinSdkException {
        Map<String, String> paramMap = YunxinParamUtils.convert(request);
        paramMap.put("accids", JSONArray.toJSONString(request.getAccids(), (JSONWriter.Feature[])new JSONWriter.Feature[0]));
        YunxinApiResponse apiResponse = this.httpClient.executeV1Api("/chatroom/removeRobot.action", paramMap);
        JSONObject object = JSONObject.parseObject((String)apiResponse.getData());
        int code = object.getIntValue(CODE);
        if (code != 200) {
            return new Result<Object>(apiResponse.getEndpoint(), code, apiResponse.getTraceId(), object.getString(DESC), null);
        }
        RemoveRobotResponseV1 response = new RemoveRobotResponseV1();
        String array = object.getString(DESC);
        if (array != null && !array.isEmpty()) {
            JSONObject js = JSONObject.parseObject((String)array);
            if (js != null && !js.isEmpty() && js.containsKey("failAccids")) {
                response.setFailAccids(JSON.parseArray((String)js.getString("failAccids"), String.class));
            }
            if (js != null && !js.isEmpty() && js.containsKey("successAccids")) {
                response.setSuccessAccids(JSON.parseArray((String)js.getString("successAccids"), String.class));
            }
        }
        return new Result<RemoveRobotResponseV1>(apiResponse.getEndpoint(), code, apiResponse.getTraceId(), null, response);
    }

    @Override
    public Result<CleanRobotResponseV1> cleanRobot(CleanRobotRequestV1 request) throws YunxinSdkException {
        Map<String, String> paramMap = YunxinParamUtils.convert(request);
        YunxinApiResponse apiResponse = this.httpClient.executeV1Api("/chatroom/cleanRobot.action", paramMap);
        JSONObject object = JSONObject.parseObject((String)apiResponse.getData());
        int code = object.getIntValue(CODE);
        if (code != 200) {
            return new Result<Object>(apiResponse.getEndpoint(), code, apiResponse.getTraceId(), object.getString(DESC), null);
        }
        CleanRobotResponseV1 response = new CleanRobotResponseV1();
        if (object.containsKey(DESC)) {
            response = (CleanRobotResponseV1)JSON.parseObject((String)object.getString(DESC), CleanRobotResponseV1.class);
        }
        return new Result<CleanRobotResponseV1>(apiResponse.getEndpoint(), code, apiResponse.getTraceId(), null, response);
    }

    @Override
    public Result<TemporaryMuteResponseV1> temporaryMute(TemporaryMuteRequestV1 request) throws YunxinSdkException {
        Map<String, String> paramMap = YunxinParamUtils.convert(request);
        YunxinApiResponse apiResponse = this.httpClient.executeV1Api("/chatroom/temporaryMute.action", paramMap);
        JSONObject object = JSONObject.parseObject((String)apiResponse.getData());
        int code = object.getIntValue(CODE);
        if (code != 200) {
            return new Result<Object>(apiResponse.getEndpoint(), code, apiResponse.getTraceId(), object.getString(DESC), null);
        }
        TemporaryMuteResponseV1 response = new TemporaryMuteResponseV1();
        if (object.containsKey(DESC)) {
            response = (TemporaryMuteResponseV1)JSON.parseObject((String)object.getString(DESC), TemporaryMuteResponseV1.class);
        }
        return new Result<TemporaryMuteResponseV1>(apiResponse.getEndpoint(), code, apiResponse.getTraceId(), null, response);
    }

    @Override
    public Result<MuteRoomResponseV1> muteRoom(MuteRoomRequestV1 request) throws YunxinSdkException {
        Map<String, String> paramMap = YunxinParamUtils.convert(request);
        YunxinApiResponse apiResponse = this.httpClient.executeV1Api("/chatroom/muteRoom.action", paramMap);
        JSONObject object = JSONObject.parseObject((String)apiResponse.getData());
        int code = object.getIntValue(CODE);
        if (code != 200) {
            return new Result<Object>(apiResponse.getEndpoint(), code, apiResponse.getTraceId(), object.getString(DESC), null);
        }
        MuteRoomResponseV1 response = new MuteRoomResponseV1();
        if (object.containsKey(DESC)) {
            response = (MuteRoomResponseV1)JSON.parseObject((String)object.getString(DESC), MuteRoomResponseV1.class);
        }
        return new Result<MuteRoomResponseV1>(apiResponse.getEndpoint(), code, apiResponse.getTraceId(), null, response);
    }

    @Override
    public Result<TagTemporaryMuteResponseV1> tagTemporaryMute(TagTemporaryMuteRequestV1 request) throws YunxinSdkException {
        Map<String, String> paramMap = YunxinParamUtils.convert(request);
        YunxinApiResponse apiResponse = this.httpClient.executeV1Api("/chatroom/tagTemporaryMute.action", paramMap);
        JSONObject object = JSONObject.parseObject((String)apiResponse.getData());
        int code = object.getIntValue(CODE);
        if (code != 200) {
            return new Result<Object>(apiResponse.getEndpoint(), code, apiResponse.getTraceId(), object.getString(DESC), null);
        }
        TagTemporaryMuteResponseV1 response = new TagTemporaryMuteResponseV1();
        if (object.containsKey(DESC)) {
            response = (TagTemporaryMuteResponseV1)JSON.parseObject((String)object.getString(DESC), TagTemporaryMuteResponseV1.class);
        }
        return new Result<TagTemporaryMuteResponseV1>(apiResponse.getEndpoint(), code, apiResponse.getTraceId(), null, response);
    }

    @Override
    public Result<TagMembersCountResponseV1> tagMembersCount(TagMembersCountRequestV1 request) throws YunxinSdkException {
        Map<String, String> paramMap = YunxinParamUtils.convert(request);
        YunxinApiResponse apiResponse = this.httpClient.executeV1Api("/chatroom/tagMembersCount.action", paramMap);
        JSONObject object = JSONObject.parseObject((String)apiResponse.getData());
        int code = object.getIntValue(CODE);
        if (code != 200) {
            return new Result<Object>(apiResponse.getEndpoint(), code, apiResponse.getTraceId(), object.getString(DESC), null);
        }
        TagMembersCountResponseV1 response = new TagMembersCountResponseV1();
        if (object.containsKey(DATA)) {
            response = (TagMembersCountResponseV1)JSON.parseObject((String)object.getString(DATA), TagMembersCountResponseV1.class);
        }
        return new Result<TagMembersCountResponseV1>(apiResponse.getEndpoint(), code, apiResponse.getTraceId(), null, response);
    }

    @Override
    public Result<TagMembersQueryResponseV1> tagMembersQuery(TagMembersQueryRequestV1 request) throws YunxinSdkException {
        JSONObject js;
        Map<String, String> paramMap = YunxinParamUtils.convert(request);
        YunxinApiResponse apiResponse = this.httpClient.executeV1Api("/chatroom/tagMembersQuery.action", paramMap);
        JSONObject object = JSONObject.parseObject((String)apiResponse.getData());
        int code = object.getIntValue(CODE);
        if (code != 200) {
            return new Result<Object>(apiResponse.getEndpoint(), code, apiResponse.getTraceId(), object.getString(DESC), null);
        }
        TagMembersQueryResponseV1 response = new TagMembersQueryResponseV1();
        String array = object.getString(DESC);
        if (array != null && !array.isEmpty() && (js = JSONObject.parseObject((String)array)) != null && !js.isEmpty() && js.containsKey(DATA)) {
            response.setData(JSON.parseArray((String)js.getString(DATA), TagMembersQueryResponseV1.TagMemberQueryBean.class));
        }
        return new Result<TagMembersQueryResponseV1>(apiResponse.getEndpoint(), code, apiResponse.getTraceId(), null, response);
    }

    @Override
    public Result<QueryTagHistoryMsgResponseV1> queryTagHistoryMsg(QueryTagHistoryMsgRequestV1 request) throws YunxinSdkException {
        Map<String, String> paramMap = YunxinParamUtils.convert(request);
        paramMap.put("tags", JSONArray.toJSONString(request.getTags(), (JSONWriter.Feature[])new JSONWriter.Feature[0]));
        YunxinApiResponse apiResponse = this.httpClient.executeV1Api("/history/queryTagHistoryMsg.action", paramMap);
        JSONObject object = JSONObject.parseObject((String)apiResponse.getData());
        int code = object.getIntValue(CODE);
        if (code != 200) {
            return new Result<Object>(apiResponse.getEndpoint(), code, apiResponse.getTraceId(), object.getString(DESC), null);
        }
        QueryTagHistoryMsgResponseV1 response = new QueryTagHistoryMsgResponseV1();
        String array = object.getString("msgs");
        if (array != null && !array.isEmpty()) {
            response.setMsgs(JSON.parseArray((String)array, QueryTagHistoryMsgResponseV1.TagMsgBean.class));
        }
        return new Result<QueryTagHistoryMsgResponseV1>(apiResponse.getEndpoint(), code, apiResponse.getTraceId(), null, response);
    }

    @Override
    public Result<UpdateChatRoomRoleTagResponseV1> updateChatRoomRoleTag(UpdateChatRoomRoleTagRequestV1 request) throws YunxinSdkException {
        Map<String, String> paramMap = YunxinParamUtils.convert(request);
        paramMap.put("tags", JSONArray.toJSONString(request.getTags(), (JSONWriter.Feature[])new JSONWriter.Feature[0]));
        YunxinApiResponse apiResponse = this.httpClient.executeV1Api("/chatroom/updateChatRoomRoleTag.action", paramMap);
        JSONObject object = JSONObject.parseObject((String)apiResponse.getData());
        int code = object.getIntValue(CODE);
        if (code != 200) {
            return new Result<Object>(apiResponse.getEndpoint(), code, apiResponse.getTraceId(), object.getString(DESC), null);
        }
        return new Result<UpdateChatRoomRoleTagResponseV1>(apiResponse.getEndpoint(), code, apiResponse.getTraceId(), null, new UpdateChatRoomRoleTagResponseV1());
    }

    @Override
    public Result<QueryUserRoomIdsResponseV1> queryUserRoomIds(QueryUserRoomIdsRequestV1 request) throws YunxinSdkException {
        Map<String, String> paramMap = YunxinParamUtils.convert(request);
        YunxinApiResponse apiResponse = this.httpClient.executeV1Api("/chatroom/queryUserRoomIds.action", paramMap);
        JSONObject object = JSONObject.parseObject((String)apiResponse.getData());
        int code = object.getIntValue(CODE);
        if (code != 200) {
            return new Result<Object>(apiResponse.getEndpoint(), code, apiResponse.getTraceId(), object.getString(DESC), null);
        }
        JSONObject desc = object.getJSONObject(DESC);
        QueryUserRoomIdsResponseV1 response = new QueryUserRoomIdsResponseV1();
        String roomIdsString = desc.getString("roomids");
        if (roomIdsString != null && !roomIdsString.isEmpty()) {
            JSONArray array = JSONArray.parseArray((String)roomIdsString, (JSONReader.Feature[])new JSONReader.Feature[0]);
            ArrayList<Long> roomIds = new ArrayList<Long>();
            for (Object o : array) {
                roomIds.add(Long.parseLong(String.valueOf(o)));
            }
            response.setRoomIds(roomIds);
        }
        return new Result<QueryUserRoomIdsResponseV1>(apiResponse.getEndpoint(), code, apiResponse.getTraceId(), null, response);
    }

    @Override
    public Result<QueueInitResponseV1> queueInit(QueueInitRequestV1 request) throws YunxinSdkException {
        Map<String, String> paramMap = YunxinParamUtils.convert(request);
        YunxinApiResponse apiResponse = this.httpClient.executeV1Api("/chatroom/queueInit.action", paramMap);
        JSONObject object = JSONObject.parseObject((String)apiResponse.getData());
        int code = object.getIntValue(CODE);
        if (code != 200) {
            return new Result<Object>(apiResponse.getEndpoint(), code, apiResponse.getTraceId(), object.getString(DESC), null);
        }
        QueueInitResponseV1 response = new QueueInitResponseV1();
        return new Result<QueueInitResponseV1>(apiResponse.getEndpoint(), code, apiResponse.getTraceId(), null, response);
    }

    @Override
    public Result<QueueDropResponseV1> queueDrop(QueueDropRequestV1 request) throws YunxinSdkException {
        Map<String, String> paramMap = YunxinParamUtils.convert(request);
        YunxinApiResponse apiResponse = this.httpClient.executeV1Api("/chatroom/queueDrop.action", paramMap);
        JSONObject object = JSONObject.parseObject((String)apiResponse.getData());
        int code = object.getIntValue(CODE);
        if (code != 200) {
            return new Result<Object>(apiResponse.getEndpoint(), code, apiResponse.getTraceId(), object.getString(DESC), null);
        }
        QueueDropResponseV1 response = (QueueDropResponseV1)object.getObject(DESC, QueueDropResponseV1.class, new JSONReader.Feature[0]);
        return new Result<QueueDropResponseV1>(apiResponse.getEndpoint(), code, apiResponse.getTraceId(), null, response);
    }

    @Override
    public Result<QueueOfferResponseV1> queueOffer(QueueOfferRequestV1 request) throws YunxinSdkException {
        Map<String, String> paramMap = YunxinParamUtils.convert(request);
        YunxinApiResponse apiResponse = this.httpClient.executeV1Api("/chatroom/queueOffer.action", paramMap);
        JSONObject object = JSONObject.parseObject((String)apiResponse.getData());
        int code = object.getIntValue(CODE);
        if (code != 200) {
            return new Result<Object>(apiResponse.getEndpoint(), code, apiResponse.getTraceId(), object.getString(DESC), null);
        }
        QueueOfferResponseV1 response = (QueueOfferResponseV1)object.getObject(DESC, QueueOfferResponseV1.class, new JSONReader.Feature[0]);
        return new Result<QueueOfferResponseV1>(apiResponse.getEndpoint(), code, apiResponse.getTraceId(), null, response);
    }

    @Override
    public Result<QueueBatchOfferResponseV1> queueBatchOffer(QueueBatchOfferRequestV1 request) throws YunxinSdkException {
        YunxinApiResponse apiResponse;
        JSONObject object;
        int code;
        Map<String, String> paramMap = YunxinParamUtils.convert(request);
        if (request.getElements() != null && !request.getElements().isEmpty()) {
            paramMap.put("elements", JSONArray.toJSONString(request.getElements(), (JSONWriter.Feature[])new JSONWriter.Feature[0]));
        }
        if ((code = (object = JSONObject.parseObject((String)(apiResponse = this.httpClient.executeV1Api("/chatroom/queueBatchOffer.action", paramMap)).getData())).getIntValue(CODE)) != 200) {
            return new Result<Object>(apiResponse.getEndpoint(), code, apiResponse.getTraceId(), object.getString(DESC), null);
        }
        QueueBatchOfferResponseV1 response = new QueueBatchOfferResponseV1();
        JSONObject desc = object.getJSONObject(DESC);
        String failedKeysStr = desc.getString("failedKeys");
        if (failedKeysStr != null && !failedKeysStr.isEmpty()) {
            response.setFailedKeys(JSON.parseArray((String)failedKeysStr, String.class));
        }
        response.setHighPriority(desc.getBoolean("highPriority"));
        return new Result<QueueBatchOfferResponseV1>(apiResponse.getEndpoint(), code, apiResponse.getTraceId(), null, response);
    }

    @Override
    public Result<QueueBatchUpdateResponseV1> queueBatchUpdate(QueueBatchUpdateRequestV1 request) throws YunxinSdkException {
        YunxinApiResponse apiResponse;
        JSONObject object;
        int code;
        Map<String, String> paramMap = YunxinParamUtils.convert(request);
        if (request.getElements() != null && !request.getElements().isEmpty()) {
            paramMap.put("elements", JSON.toJSONString(request.getElements()));
        }
        if ((code = (object = JSONObject.parseObject((String)(apiResponse = this.httpClient.executeV1Api("/chatroom/queueBatchUpdateElements.action", paramMap)).getData())).getIntValue(CODE)) != 200) {
            return new Result<Object>(apiResponse.getEndpoint(), code, apiResponse.getTraceId(), object.getString(DESC), null);
        }
        QueueBatchUpdateResponseV1 response = new QueueBatchUpdateResponseV1();
        String descStr = object.getString(DESC);
        if (descStr != null && !descStr.isEmpty()) {
            JSONObject descObj = JSONObject.parseObject((String)descStr);
            if (descObj.containsKey("noExistElementKey")) {
                String noExistKeysStr = descObj.getString("noExistElementKey");
                if (noExistKeysStr != null && !noExistKeysStr.isEmpty()) {
                    response.setNoExistElementKey(JSON.parseArray((String)noExistKeysStr, String.class));
                } else {
                    JSONArray jsonArray = descObj.getJSONArray("noExistElementKey");
                    if (jsonArray != null) {
                        response.setNoExistElementKey(jsonArray.toJavaList(String.class, new JSONReader.Feature[0]));
                    }
                }
            }
            response.setHighPriority(descObj.getBoolean("highPriority"));
        }
        return new Result<QueueBatchUpdateResponseV1>(apiResponse.getEndpoint(), code, apiResponse.getTraceId(), null, response);
    }

    @Override
    public Result<QueueListResponseV1> queueList(QueueListRequestV1 request) throws YunxinSdkException {
        JSONObject descObj;
        Map<String, String> paramMap = YunxinParamUtils.convert(request);
        YunxinApiResponse apiResponse = this.httpClient.executeV1Api("/chatroom/queueList.action", paramMap);
        JSONObject object = JSONObject.parseObject((String)apiResponse.getData());
        int code = object.getIntValue(CODE);
        if (code != 200) {
            return new Result<Object>(apiResponse.getEndpoint(), code, apiResponse.getTraceId(), object.getString(DESC), null);
        }
        QueueListResponseV1 response = new QueueListResponseV1();
        String descStr = object.getString(DESC);
        if (descStr != null && !descStr.isEmpty() && (descObj = JSONObject.parseObject((String)descStr)).containsKey("list")) {
            JSONArray jsonArray = descObj.getJSONArray("list");
            ArrayList<QueueListResponseV1.QueueElement> list = new ArrayList<QueueListResponseV1.QueueElement>();
            for (Object o : jsonArray) {
                JSONObject json = (JSONObject)o;
                QueueListResponseV1.QueueElement element = null;
                for (Map.Entry entry : json.entrySet()) {
                    element = new QueueListResponseV1.QueueElement((String)entry.getKey(), entry.getValue().toString());
                }
                list.add(element);
            }
            response.setList(list);
        }
        return new Result<QueueListResponseV1>(apiResponse.getEndpoint(), code, apiResponse.getTraceId(), null, response);
    }

    @Override
    public Result<QueuePollResponseV1> queuePoll(QueuePollRequestV1 request) throws YunxinSdkException {
        Map<String, String> paramMap = YunxinParamUtils.convert(request);
        YunxinApiResponse apiResponse = this.httpClient.executeV1Api("/chatroom/queuePoll.action", paramMap);
        JSONObject object = JSONObject.parseObject((String)apiResponse.getData());
        int code = object.getIntValue(CODE);
        if (code != 200) {
            return new Result<Object>(apiResponse.getEndpoint(), code, apiResponse.getTraceId(), object.getString(DESC), null);
        }
        QueuePollResponseV1 response = new QueuePollResponseV1();
        String descStr = object.getString(DESC);
        if (descStr != null && !descStr.isEmpty()) {
            JSONObject descObj = JSONObject.parseObject((String)descStr);
            if (descObj.containsKey("key")) {
                response.setKey(descObj.getString("key"));
            }
            if (descObj.containsKey("value")) {
                response.setValue(descObj.getString("value"));
            }
            response.setHighPriority(descObj.getBoolean("highPriority"));
        }
        return new Result<QueuePollResponseV1>(apiResponse.getEndpoint(), code, apiResponse.getTraceId(), null, response);
    }

    @Override
    public Result<QueueGetResponseV1> queueGet(QueueGetRequestV1 request) throws YunxinSdkException {
        JSONObject descObj;
        YunxinApiResponse apiResponse;
        JSONObject object;
        int code;
        Map<String, String> paramMap = YunxinParamUtils.convert(request);
        if (request.getKeys() != null && !request.getKeys().isEmpty()) {
            paramMap.put("keys", JSONArray.toJSONString(request.getKeys(), (JSONWriter.Feature[])new JSONWriter.Feature[0]));
        }
        if ((code = (object = JSONObject.parseObject((String)(apiResponse = this.httpClient.executeV1Api("/chatroom/queueMultiGet.action", paramMap)).getData())).getIntValue(CODE)) != 200) {
            return new Result<Object>(apiResponse.getEndpoint(), code, apiResponse.getTraceId(), object.getString(DESC), null);
        }
        QueueGetResponseV1 response = new QueueGetResponseV1();
        String descStr = object.getString(DESC);
        if (descStr != null && !descStr.isEmpty() && (descObj = JSONObject.parseObject((String)descStr)).containsKey("list")) {
            JSONArray jsonArray = descObj.getJSONArray("list");
            ArrayList<QueueGetResponseV1.QueueElement> list = new ArrayList<QueueGetResponseV1.QueueElement>();
            for (Object o : jsonArray) {
                JSONObject json = (JSONObject)o;
                QueueGetResponseV1.QueueElement element = null;
                for (Map.Entry entry : json.entrySet()) {
                    element = new QueueGetResponseV1.QueueElement((String)entry.getKey(), entry.getValue().toString());
                }
                list.add(element);
            }
            response.setList(list);
        }
        return new Result<QueueGetResponseV1>(apiResponse.getEndpoint(), code, apiResponse.getTraceId(), null, response);
    }
}

