/*
 * Decompiled with CFR 0.152.
 */
package com.netease.nim.server.sdk.im.v1.account;

import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.JSONWriter;
import com.netease.nim.server.sdk.core.Result;
import com.netease.nim.server.sdk.core.YunxinApiHttpClient;
import com.netease.nim.server.sdk.core.YunxinApiResponse;
import com.netease.nim.server.sdk.core.exception.YunxinSdkException;
import com.netease.nim.server.sdk.im.v1.account.IAccountV1Service;
import com.netease.nim.server.sdk.im.v1.account.request.BlockAccountRequestV1;
import com.netease.nim.server.sdk.im.v1.account.request.CreateAccountRequestV1;
import com.netease.nim.server.sdk.im.v1.account.request.MuteAccountRequestV1;
import com.netease.nim.server.sdk.im.v1.account.request.MuteModuleRequestV1;
import com.netease.nim.server.sdk.im.v1.account.request.QueryAccountOnlineStatusRequestV1;
import com.netease.nim.server.sdk.im.v1.account.request.QueryUserInfosRequestV1;
import com.netease.nim.server.sdk.im.v1.account.request.RefreshTokenRequestV1;
import com.netease.nim.server.sdk.im.v1.account.request.SetDonnopRequestV1;
import com.netease.nim.server.sdk.im.v1.account.request.UnBlockAccountRequestV1;
import com.netease.nim.server.sdk.im.v1.account.request.UpdateTokenRequestV1;
import com.netease.nim.server.sdk.im.v1.account.request.UpdateUinfoRequestV1;
import com.netease.nim.server.sdk.im.v1.account.response.BlockAccountResponseV1;
import com.netease.nim.server.sdk.im.v1.account.response.CreateAccountResponseV1;
import com.netease.nim.server.sdk.im.v1.account.response.MuteAccountResponseV1;
import com.netease.nim.server.sdk.im.v1.account.response.MuteModuleResponseV1;
import com.netease.nim.server.sdk.im.v1.account.response.QueryAccountOnlineStatusResponseV1;
import com.netease.nim.server.sdk.im.v1.account.response.QueryUserInfosResponseV1;
import com.netease.nim.server.sdk.im.v1.account.response.RefreshTokenResponseV1;
import com.netease.nim.server.sdk.im.v1.account.response.SetDonnopResponseV1;
import com.netease.nim.server.sdk.im.v1.account.response.UnBlockAccountResponseV1;
import com.netease.nim.server.sdk.im.v1.account.response.UpdateTokenResponseV1;
import com.netease.nim.server.sdk.im.v1.account.response.UpdateUinfoResponseV1;
import com.netease.nim.server.sdk.im.v1.annotation.YunxinParamUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class AccountV1Service
implements IAccountV1Service {
    private final YunxinApiHttpClient httpClient;

    public AccountV1Service(YunxinApiHttpClient httpClient) {
        this.httpClient = httpClient;
    }

    @Override
    public Result<CreateAccountResponseV1> createAccount(CreateAccountRequestV1 request) throws YunxinSdkException {
        Map<String, String> paramMap = YunxinParamUtils.convert(request);
        YunxinApiResponse apiResponse = this.httpClient.executeV1Api("/user/create.action", paramMap);
        JSONObject object = JSONObject.parseObject((String)apiResponse.getData());
        int code = object.getIntValue("code");
        if (code != 200) {
            return new Result<Object>(apiResponse.getEndpoint(), code, apiResponse.getTraceId(), object.getString("desc"), null);
        }
        CreateAccountResponseV1 response = (CreateAccountResponseV1)object.getObject("info", CreateAccountResponseV1.class, new JSONReader.Feature[0]);
        return new Result<CreateAccountResponseV1>(apiResponse.getEndpoint(), code, apiResponse.getTraceId(), null, response);
    }

    @Override
    public Result<UpdateTokenResponseV1> updateToken(UpdateTokenRequestV1 request) throws YunxinSdkException {
        Map<String, String> paramMap = YunxinParamUtils.convert(request);
        YunxinApiResponse apiResponse = this.httpClient.executeV1Api("/user/update.action", paramMap);
        JSONObject object = JSONObject.parseObject((String)apiResponse.getData());
        int code = object.getIntValue("code");
        if (code != 200) {
            return new Result<Object>(apiResponse.getEndpoint(), code, apiResponse.getTraceId(), object.getString("desc"), null);
        }
        return new Result<UpdateTokenResponseV1>(apiResponse.getEndpoint(), code, apiResponse.getTraceId(), null, new UpdateTokenResponseV1());
    }

    @Override
    public Result<RefreshTokenResponseV1> refreshToken(RefreshTokenRequestV1 request) throws YunxinSdkException {
        Map<String, String> paramMap = YunxinParamUtils.convert(request);
        YunxinApiResponse apiResponse = this.httpClient.executeV1Api("/user/refreshToken.action", paramMap);
        JSONObject object = JSONObject.parseObject((String)apiResponse.getData());
        int code = object.getIntValue("code");
        if (code != 200) {
            return new Result<Object>(apiResponse.getEndpoint(), code, apiResponse.getTraceId(), object.getString("desc"), null);
        }
        RefreshTokenResponseV1 response = (RefreshTokenResponseV1)object.getObject("info", RefreshTokenResponseV1.class, new JSONReader.Feature[0]);
        return new Result<RefreshTokenResponseV1>(apiResponse.getEndpoint(), code, apiResponse.getTraceId(), null, response);
    }

    @Override
    public Result<BlockAccountResponseV1> block(BlockAccountRequestV1 request) throws YunxinSdkException {
        Map<String, String> paramMap = YunxinParamUtils.convert(request);
        YunxinApiResponse apiResponse = this.httpClient.executeV1Api("/user/block.action", paramMap);
        JSONObject object = JSONObject.parseObject((String)apiResponse.getData());
        int code = object.getIntValue("code");
        if (code != 200) {
            return new Result<Object>(apiResponse.getEndpoint(), code, apiResponse.getTraceId(), object.getString("desc"), null);
        }
        return new Result<BlockAccountResponseV1>(apiResponse.getEndpoint(), code, apiResponse.getTraceId(), null, new BlockAccountResponseV1());
    }

    @Override
    public Result<UnBlockAccountResponseV1> unblock(UnBlockAccountRequestV1 request) throws YunxinSdkException {
        Map<String, String> paramMap = YunxinParamUtils.convert(request);
        YunxinApiResponse apiResponse = this.httpClient.executeV1Api("/user/unblock.action", paramMap);
        JSONObject object = JSONObject.parseObject((String)apiResponse.getData());
        int code = object.getIntValue("code");
        if (code != 200) {
            return new Result<Object>(apiResponse.getEndpoint(), code, apiResponse.getTraceId(), object.getString("desc"), null);
        }
        return new Result<UnBlockAccountResponseV1>(apiResponse.getEndpoint(), code, apiResponse.getTraceId(), null, new UnBlockAccountResponseV1());
    }

    @Override
    public Result<MuteAccountResponseV1> mute(MuteAccountRequestV1 request) throws YunxinSdkException {
        Map<String, String> paramMap = YunxinParamUtils.convert(request);
        YunxinApiResponse apiResponse = this.httpClient.executeV1Api("/user/mute.action", paramMap);
        JSONObject object = JSONObject.parseObject((String)apiResponse.getData());
        int code = object.getIntValue("code");
        if (code != 200) {
            return new Result<Object>(apiResponse.getEndpoint(), code, apiResponse.getTraceId(), object.getString("desc"), null);
        }
        return new Result<MuteAccountResponseV1>(apiResponse.getEndpoint(), code, apiResponse.getTraceId(), null, new MuteAccountResponseV1());
    }

    @Override
    public Result<MuteModuleResponseV1> muteModule(MuteModuleRequestV1 request) throws YunxinSdkException {
        Map<String, String> paramMap = YunxinParamUtils.convert(request);
        YunxinApiResponse apiResponse = this.httpClient.executeV1Api("/user/muteModule.action", paramMap);
        JSONObject object = JSONObject.parseObject((String)apiResponse.getData());
        int code = object.getIntValue("code");
        if (code != 200) {
            return new Result<Object>(apiResponse.getEndpoint(), code, apiResponse.getTraceId(), object.getString("desc"), null);
        }
        MuteModuleResponseV1 response = (MuteModuleResponseV1)object.getObject("data", MuteModuleResponseV1.class, new JSONReader.Feature[0]);
        return new Result<MuteModuleResponseV1>(apiResponse.getEndpoint(), code, apiResponse.getTraceId(), null, response);
    }

    @Override
    public Result<SetDonnopResponseV1> setDonnop(SetDonnopRequestV1 request) throws YunxinSdkException {
        Map<String, String> paramMap = YunxinParamUtils.convert(request);
        YunxinApiResponse apiResponse = this.httpClient.executeV1Api("/user/setDonnop.action", paramMap);
        JSONObject object = JSONObject.parseObject((String)apiResponse.getData());
        int code = object.getIntValue("code");
        if (code != 200) {
            return new Result<Object>(apiResponse.getEndpoint(), code, apiResponse.getTraceId(), object.getString("desc"), null);
        }
        return new Result<SetDonnopResponseV1>(apiResponse.getEndpoint(), code, apiResponse.getTraceId(), null, new SetDonnopResponseV1());
    }

    @Override
    public Result<QueryAccountOnlineStatusResponseV1> queryOnlineStatus(QueryAccountOnlineStatusRequestV1 request) throws YunxinSdkException {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("accids", JSONArray.toJSONString(request.getAccids(), (JSONWriter.Feature[])new JSONWriter.Feature[0]));
        YunxinApiResponse apiResponse = this.httpClient.executeV1Api("/user/userOnlineStatus.action", paramMap);
        JSONObject object = JSONObject.parseObject((String)apiResponse.getData());
        int code = object.getIntValue("code");
        if (code != 200) {
            return new Result<Object>(apiResponse.getEndpoint(), code, apiResponse.getTraceId(), object.getString("desc"), null);
        }
        JSONObject data = object.getJSONObject("data");
        QueryAccountOnlineStatusResponseV1 response = new QueryAccountOnlineStatusResponseV1();
        JSONArray jsonArray = data.getJSONArray("invalidAccids");
        ArrayList<String> invalidAccids = new ArrayList<String>();
        if (jsonArray != null) {
            for (Object o : jsonArray) {
                invalidAccids.add(String.valueOf(o));
            }
        }
        response.setInvalidAccids(invalidAccids);
        ArrayList<QueryAccountOnlineStatusResponseV1.OnlineStatus> onlineStatusList = new ArrayList<QueryAccountOnlineStatusResponseV1.OnlineStatus>();
        JSONObject statusJson = data.getJSONObject("status");
        if (statusJson != null) {
            for (Map.Entry entry : statusJson.entrySet()) {
                QueryAccountOnlineStatusResponseV1.OnlineStatus onlineStatus = new QueryAccountOnlineStatusResponseV1.OnlineStatus();
                onlineStatus.setAccid((String)entry.getKey());
                ArrayList<QueryAccountOnlineStatusResponseV1.Status> statusList = new ArrayList<QueryAccountOnlineStatusResponseV1.Status>();
                JSONArray array = (JSONArray)entry.getValue();
                for (Object o : array) {
                    JSONObject json = (JSONObject)o;
                    QueryAccountOnlineStatusResponseV1.Status status = new QueryAccountOnlineStatusResponseV1.Status();
                    status.setClientType(json.getIntValue("clientType"));
                    status.setLoginTime(json.getLongValue("loginTime"));
                    statusList.add(status);
                }
                onlineStatus.setStatusList(statusList);
                onlineStatusList.add(onlineStatus);
            }
        }
        response.setOnlineStatusList(onlineStatusList);
        return new Result<QueryAccountOnlineStatusResponseV1>(apiResponse.getEndpoint(), code, apiResponse.getTraceId(), null, response);
    }

    @Override
    public Result<QueryUserInfosResponseV1> queryUserInfos(QueryUserInfosRequestV1 request) throws YunxinSdkException {
        YunxinApiResponse apiResponse;
        JSONObject object;
        int code;
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("accids", JSONArray.toJSONString(request.getAccids(), (JSONWriter.Feature[])new JSONWriter.Feature[0]));
        if (request.getMuteStatus() != null) {
            paramMap.put("muteStatus", String.valueOf(request.getMuteStatus()));
        }
        if ((code = (object = JSONObject.parseObject((String)(apiResponse = this.httpClient.executeV1Api("/user/getUinfos.action", paramMap)).getData())).getIntValue("code")) != 200) {
            return new Result<Object>(apiResponse.getEndpoint(), code, apiResponse.getTraceId(), object.getString("desc"), null);
        }
        QueryUserInfosResponseV1 response = new QueryUserInfosResponseV1();
        ArrayList<QueryUserInfosResponseV1.UserInfo> userInfoList = new ArrayList<QueryUserInfosResponseV1.UserInfo>();
        JSONArray uinfos = object.getJSONArray("uinfos");
        for (Object uinfo : uinfos) {
            QueryUserInfosResponseV1.UserInfo userInfo = (QueryUserInfosResponseV1.UserInfo)JSONObject.parseObject((String)uinfo.toString(), QueryUserInfosResponseV1.UserInfo.class);
            userInfoList.add(userInfo);
        }
        response.setUserInfoList(userInfoList);
        return new Result<QueryUserInfosResponseV1>(apiResponse.getEndpoint(), code, apiResponse.getTraceId(), null, response);
    }

    @Override
    public Result<UpdateUinfoResponseV1> updateUinfo(UpdateUinfoRequestV1 request) throws YunxinSdkException {
        Map<String, String> paramMap = YunxinParamUtils.convert(request);
        YunxinApiResponse apiResponse = this.httpClient.executeV1Api("/user/updateUinfo.action", paramMap);
        JSONObject object = JSONObject.parseObject((String)apiResponse.getData());
        int code = object.getIntValue("code");
        if (code != 200) {
            return new Result<Object>(apiResponse.getEndpoint(), code, apiResponse.getTraceId(), object.getString("desc"), null);
        }
        return new Result<Object>(apiResponse.getEndpoint(), code, apiResponse.getTraceId(), null, null);
    }
}

