/*
 * Decompiled with CFR 0.152.
 */
package com.netease.nim.server.sdk.core.metrics;

import com.netease.nim.server.sdk.core.BizName;
import com.netease.nim.server.sdk.core.http.ContextType;
import com.netease.nim.server.sdk.core.http.HttpMethod;
import com.netease.nim.server.sdk.core.metrics.EndpointStats;
import com.netease.nim.server.sdk.core.metrics.MetricsCallback;
import com.netease.nim.server.sdk.core.metrics.Statistics;
import com.netease.nim.server.sdk.core.metrics.Stats;
import com.netease.nim.server.sdk.core.metrics.StatsData;
import com.netease.nim.server.sdk.core.metrics.UriStats;
import com.netease.nim.server.sdk.core.trace.ApiVersion;
import com.netease.nim.server.sdk.core.utils.NamedThreadFactory;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class YunxinApiSdkMetricsCollector {
    private static final Logger logger = LoggerFactory.getLogger(YunxinApiSdkMetricsCollector.class);
    private static final ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor(new NamedThreadFactory("yunxin-sdk-metrics-collector"));
    private static final ThreadPoolExecutor callbackExecutor = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(100), new NamedThreadFactory("yunxin-sdk-stats-callback"));
    private final BizName bizName;
    private ConcurrentHashMap<Key1, Statistics> map1 = new ConcurrentHashMap();
    private ConcurrentHashMap<Key2, Statistics> map2 = new ConcurrentHashMap();
    private final MetricsCallback metricsCallback;
    private Stats stats = new Stats();
    private final ScheduledFuture<?> scheduledFuture;

    public YunxinApiSdkMetricsCollector(BizName bizName, int collectIntervalSeconds, MetricsCallback metricsCallback) {
        if (collectIntervalSeconds <= 0) {
            throw new IllegalArgumentException("illegal collectIntervalSeconds");
        }
        this.bizName = bizName;
        this.metricsCallback = metricsCallback;
        this.scheduledFuture = scheduler.scheduleAtFixedRate(this::calc, collectIntervalSeconds, collectIntervalSeconds, TimeUnit.SECONDS);
    }

    public void collect(String endpoint, HttpMethod method, ContextType contextType, ApiVersion apiVersion, String uri, String result, long spendMs) {
        Key1 key1 = new Key1(endpoint, method, contextType, apiVersion, uri, result);
        Statistics statistics1 = this.map1.get(key1);
        if (statistics1 == null) {
            statistics1 = this.map1.computeIfAbsent(key1, k -> new Statistics());
        }
        statistics1.update(spendMs);
        Key2 key2 = new Key2(endpoint, result);
        Statistics statistics2 = this.map2.get(key2);
        if (statistics2 == null) {
            statistics2 = this.map2.computeIfAbsent(key2, k -> new Statistics());
        }
        statistics2.update(spendMs);
    }

    public void shutdown() {
        this.scheduledFuture.cancel(false);
    }

    private void calc() {
        try {
            StatsData data;
            Object key;
            ConcurrentHashMap<Key1, Statistics> map1 = this.map1;
            ConcurrentHashMap<Key2, Statistics> map2 = this.map2;
            this.map1 = new ConcurrentHashMap();
            this.map2 = new ConcurrentHashMap();
            ArrayList<EndpointStats> endpointStatsList = new ArrayList<EndpointStats>();
            ArrayList<UriStats> uriStatsList = new ArrayList<UriStats>();
            for (Map.Entry<Key1, Statistics> entry : map1.entrySet()) {
                key = entry.getKey();
                data = entry.getValue().getStatsDataAndReset();
                if (data.getCount() == 0L) continue;
                UriStats uriStats = new UriStats();
                uriStats.setEndpoint(((Key1)key).endpoint);
                uriStats.setMethod(((Key1)key).method);
                uriStats.setContextType(((Key1)key).contextType);
                uriStats.setApiVersion(((Key1)key).apiVersion);
                uriStats.setUri(((Key1)key).uri);
                uriStats.setResult(((Key1)key).result);
                uriStats.setCount(data.getCount());
                uriStats.setAvg(data.getAvg());
                uriStats.setMax(data.getMax());
                uriStats.setP50(data.getP50());
                uriStats.setP75(data.getP75());
                uriStats.setP90(data.getP90());
                uriStats.setP95(data.getP95());
                uriStats.setP99(data.getP99());
                uriStats.setP999(data.getP999());
                uriStatsList.add(uriStats);
            }
            for (Map.Entry<Object, Statistics> entry : map2.entrySet()) {
                key = (Key2)entry.getKey();
                data = entry.getValue().getStatsDataAndReset();
                if (data.getCount() == 0L) continue;
                EndpointStats endpointStats = new EndpointStats();
                endpointStats.setEndpoint(((Key2)key).endpoint);
                endpointStats.setResult(((Key2)key).result);
                endpointStats.setCount(data.getCount());
                endpointStats.setAvg(data.getAvg());
                endpointStats.setMax(data.getMax());
                endpointStats.setP50(data.getP50());
                endpointStats.setP75(data.getP75());
                endpointStats.setP90(data.getP90());
                endpointStats.setP95(data.getP95());
                endpointStats.setP99(data.getP99());
                endpointStats.setP999(data.getP999());
                endpointStatsList.add(endpointStats);
            }
            Stats stats = new Stats();
            stats.setBizName(this.bizName);
            stats.setUriStatsList(uriStatsList);
            stats.setEndpointStatsList(endpointStatsList);
            this.stats = stats;
            if (this.metricsCallback != null) {
                callbackExecutor.submit(() -> {
                    try {
                        this.metricsCallback.callback(stats);
                    }
                    catch (Exception e) {
                        logger.error("callback error", (Throwable)e);
                    }
                });
            }
        }
        catch (Exception e) {
            logger.error("calc metrics error", (Throwable)e);
        }
    }

    public Stats getStats() {
        return this.stats;
    }

    private static class Key2 {
        private final String endpoint;
        private final String result;

        public Key2(String endpoint, String result) {
            this.endpoint = endpoint;
            this.result = result;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Key2 key2 = (Key2)o;
            return Objects.equals(this.endpoint, key2.endpoint) && Objects.equals(this.result, key2.result);
        }

        public int hashCode() {
            return Objects.hash(this.endpoint, this.result);
        }
    }

    private static class Key1 {
        private final String endpoint;
        private final HttpMethod method;
        private final ContextType contextType;
        private final ApiVersion apiVersion;
        private final String uri;
        private final String result;

        public Key1(String endpoint, HttpMethod method, ContextType contextType, ApiVersion apiVersion, String uri, String result) {
            this.endpoint = endpoint;
            this.method = method;
            this.contextType = contextType;
            this.apiVersion = apiVersion;
            this.uri = uri;
            this.result = result;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Key1 key1 = (Key1)o;
            return Objects.equals(this.endpoint, key1.endpoint) && this.method == key1.method && this.contextType == key1.contextType && this.apiVersion == key1.apiVersion && Objects.equals(this.uri, key1.uri) && Objects.equals(this.result, key1.result);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.endpoint, this.method, this.contextType, this.apiVersion, this.uri, this.result});
        }
    }
}

