/*
 * Decompiled with CFR 0.152.
 */
package com.netease.nim.server.sdk.core.endpoint;

import com.netease.nim.server.sdk.core.utils.NamedThreadFactory;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.LongAdder;

public class RatioSlideWindows {
    private static final ScheduledExecutorService scheduledExecutorService = new ScheduledThreadPoolExecutor(Runtime.getRuntime().availableProcessors(), new NamedThreadFactory("yunxin-sdk-ratio-slide-windows"));
    private final Counter[] counter;
    private int index;

    public RatioSlideWindows(int bucketSize, long windowTimePerBucket) {
        this.counter = new Counter[bucketSize];
        for (int i = 0; i < bucketSize; ++i) {
            this.counter[i] = new Counter();
        }
        this.index = 0;
        scheduledExecutorService.scheduleAtFixedRate(this::slideToNextBucket, windowTimePerBucket, windowTimePerBucket, TimeUnit.MILLISECONDS);
    }

    private void slideToNextBucket() {
        int nextIndex = this.index == this.counter.length - 1 ? 0 : this.index + 1;
        this.counter[nextIndex].reset();
        this.index = nextIndex;
    }

    public void incrementSuccess() {
        this.counter[this.index].incrementSuccess();
    }

    public void incrementFail() {
        this.counter[this.index].incrementFail();
    }

    public double getSuccessRatio() {
        long success = 0L;
        long fail = 0L;
        for (Counter c : this.counter) {
            success += c.success.sum();
            fail += c.fail.sum();
        }
        if (success + fail == 0L) {
            return 1.0;
        }
        return (double)success * 1.0 / (double)(success + fail);
    }

    private static class Counter {
        LongAdder success = new LongAdder();
        LongAdder fail = new LongAdder();

        private Counter() {
        }

        void incrementSuccess() {
            this.success.increment();
        }

        void incrementFail() {
            this.fail.increment();
        }

        void reset() {
            this.success.reset();
            this.fail.reset();
        }
    }
}

