/*
 * Decompiled with CFR 0.152.
 */
package com.netease.nim.server.sdk.core.endpoint;

import com.netease.nim.server.sdk.core.utils.NamedThreadFactory;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.LongAdder;

public class LatencySlideWindows {
    private static final ScheduledExecutorService scheduledExecutorService = new ScheduledThreadPoolExecutor(Runtime.getRuntime().availableProcessors(), new NamedThreadFactory("yunxin-sdk-latency-slide-windows"));
    private final Counter[] counter;
    private int index;

    public LatencySlideWindows(int bucketSize, long windowTimePerBucket) {
        this.counter = new Counter[bucketSize];
        for (int i = 0; i < bucketSize; ++i) {
            this.counter[i] = new Counter();
        }
        this.index = 0;
        scheduledExecutorService.scheduleAtFixedRate(this::slideToNextBucket, windowTimePerBucket, windowTimePerBucket, TimeUnit.MILLISECONDS);
    }

    private void slideToNextBucket() {
        int nextIndex = this.index == this.counter.length - 1 ? 0 : this.index + 1;
        this.counter[nextIndex].reset();
        this.index = nextIndex;
    }

    public void increment(long spendMs) {
        this.counter[this.index].increment(spendMs);
    }

    public double getLatency() {
        long sum = 0L;
        long count = 0L;
        for (Counter c : this.counter) {
            count += c.count.sum();
            sum += c.spend.sum();
        }
        if (count == 0L) {
            return 0.0;
        }
        return (double)sum * 1.0 / (double)count;
    }

    private static class Counter {
        LongAdder count = new LongAdder();
        LongAdder spend = new LongAdder();

        private Counter() {
        }

        void increment(long spendMs) {
            this.count.increment();
            this.spend.add(spendMs);
        }

        void reset() {
            this.count.reset();
            this.spend.reset();
        }
    }
}

