/*
 * Decompiled with CFR 0.152.
 */
package com.netease.arctic.hive.utils;

import com.netease.arctic.hive.HMSClientPool;
import com.netease.arctic.hive.catalog.ArcticHiveCatalog;
import com.netease.arctic.hive.utils.HiveMetaSynchronizer;
import com.netease.arctic.hive.utils.HivePartitionUtil;
import com.netease.arctic.hive.utils.HiveSchemaUtil;
import com.netease.arctic.hive.utils.HiveTableUtil;
import com.netease.arctic.table.ArcticTable;
import com.netease.arctic.table.PrimaryKeySpec;
import com.netease.arctic.table.TableIdentifier;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.hive.metastore.api.SerDeInfo;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpgradeHiveTableUtil {
    private static final Logger LOG = LoggerFactory.getLogger(UpgradeHiveTableUtil.class);
    private static final long DEFAULT_TXID = 0L;

    public static void upgradeHiveTable(ArcticHiveCatalog arcticHiveCatalog, TableIdentifier tableIdentifier, List<String> pkList, Map<String, String> properties) throws Exception {
        if (!UpgradeHiveTableUtil.formatCheck(arcticHiveCatalog.getHMSClient(), tableIdentifier)) {
            throw new IllegalArgumentException("Only support storage format is parquet");
        }
        boolean upgradeHive = false;
        try {
            Table hiveTable = HiveTableUtil.loadHmsTable(arcticHiveCatalog.getHMSClient(), tableIdentifier);
            Schema schema = HiveSchemaUtil.convertHiveSchemaToIcebergSchema(hiveTable, pkList);
            List partitionKeys = hiveTable.getPartitionKeys();
            PartitionSpec.Builder partitionBuilder = PartitionSpec.builderFor((Schema)schema);
            partitionKeys.stream().forEach(p -> partitionBuilder.identity(p.getName()));
            PrimaryKeySpec.Builder primaryKeyBuilder = PrimaryKeySpec.builderFor((Schema)schema);
            pkList.stream().forEach(p -> primaryKeyBuilder.addColumn(p));
            ArcticTable arcticTable = arcticHiveCatalog.newTableBuilder(tableIdentifier, schema).withProperties(properties).withPartitionSpec(partitionBuilder.build()).withPrimaryKeySpec(primaryKeyBuilder.build()).withProperty("allow-hive-table-existed", "true").create();
            upgradeHive = true;
            UpgradeHiveTableUtil.hiveDataMigration(arcticTable, arcticHiveCatalog, tableIdentifier);
        }
        catch (Throwable t) {
            if (upgradeHive) {
                arcticHiveCatalog.dropTableButNotDropHiveTable(tableIdentifier);
            }
            throw t;
        }
    }

    private static void hiveDataMigration(ArcticTable arcticTable, ArcticHiveCatalog arcticHiveCatalog, TableIdentifier tableIdentifier) throws Exception {
        Table hiveTable = HiveTableUtil.loadHmsTable(arcticHiveCatalog.getHMSClient(), tableIdentifier);
        String hiveDataLocation = HiveTableUtil.hiveRootLocation(hiveTable.getSd().getLocation());
        arcticTable.io().mkdirs(hiveDataLocation);
        if (hiveTable.getPartitionKeys().isEmpty()) {
            String newPath = hiveDataLocation + "/" + System.currentTimeMillis() + "_" + UUID.randomUUID();
            arcticTable.io().mkdirs(newPath);
            for (FileStatus fileStatus : arcticTable.io().list(hiveTable.getSd().getLocation())) {
                if (fileStatus.isDirectory()) continue;
                arcticTable.io().rename(fileStatus.getPath().toString(), newPath);
            }
            try {
                HiveTableUtil.alterTableLocation(arcticHiveCatalog.getHMSClient(), arcticTable.id(), newPath);
                LOG.info("table{" + arcticTable.name() + "} alter hive table location " + hiveDataLocation + " success");
            }
            catch (IOException e) {
                LOG.warn("table{" + arcticTable.name() + "} alter hive table location failed", (Throwable)e);
                throw new RuntimeException(e);
            }
        } else {
            List<String> partitions = HivePartitionUtil.getHivePartitionNames(arcticHiveCatalog.getHMSClient(), tableIdentifier);
            List<String> partitionLocations = HivePartitionUtil.getHivePartitionLocations(arcticHiveCatalog.getHMSClient(), tableIdentifier);
            for (int i = 0; i < partitionLocations.size(); ++i) {
                String partition = partitions.get(i);
                String oldLocation = partitionLocations.get(i);
                String newLocation = hiveDataLocation + "/" + partition + "/" + HiveTableUtil.newHiveSubdirectory(0L);
                arcticTable.io().mkdirs(newLocation);
                for (FileStatus fileStatus : arcticTable.io().list(oldLocation)) {
                    if (fileStatus.isDirectory()) continue;
                    arcticTable.io().rename(fileStatus.getPath().toString(), newLocation);
                }
                HivePartitionUtil.alterPartition(arcticHiveCatalog.getHMSClient(), tableIdentifier, partition, newLocation);
            }
        }
        HiveMetaSynchronizer.syncHiveDataToArctic(arcticTable, arcticHiveCatalog.getHMSClient());
    }

    private static boolean formatCheck(HMSClientPool hiveClient, TableIdentifier tableIdentifier) throws IOException {
        AtomicBoolean isSupport = new AtomicBoolean(false);
        try {
            hiveClient.run(client -> {
                Table hiveTable = HiveTableUtil.loadHmsTable(hiveClient, tableIdentifier);
                StorageDescriptor storageDescriptor = hiveTable.getSd();
                SerDeInfo serDeInfo = storageDescriptor.getSerdeInfo();
                switch (storageDescriptor.getInputFormat()) {
                    case "org.apache.hadoop.hive.ql.io.parquet.MapredParquetInputFormat": {
                        if (storageDescriptor.getOutputFormat().equals("org.apache.hadoop.hive.ql.io.parquet.MapredParquetOutputFormat") && serDeInfo.getSerializationLib().equals("org.apache.hadoop.hive.ql.io.parquet.serde.ParquetHiveSerDe")) {
                            isSupport.set(true);
                            break;
                        }
                        throw new IllegalStateException("Please check your hive table storage format is right");
                    }
                    default: {
                        isSupport.set(false);
                    }
                }
                return null;
            });
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        return isSupport.get();
    }
}

