/*
 * Decompiled with CFR 0.152.
 */
package com.netease.arctic.hive.utils;

import com.netease.arctic.hive.utils.ChangeFieldName;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.TypeUtil;
import org.apache.iceberg.types.Types;

public class HiveSchemaUtil {
    public static Schema hiveTableSchema(Schema schema, PartitionSpec spec) {
        if (spec.isUnpartitioned()) {
            return schema;
        }
        return TypeUtil.selectNot((Schema)schema, (Set)spec.identitySourceIds());
    }

    public static List<FieldSchema> hiveTableFields(Schema schema, PartitionSpec spec) {
        return org.apache.iceberg.hive.HiveSchemaUtil.convert((Schema)HiveSchemaUtil.hiveTableSchema(schema, spec));
    }

    public static List<FieldSchema> hivePartitionFields(Schema schema, PartitionSpec spec) {
        return org.apache.iceberg.hive.HiveSchemaUtil.convert((Schema)TypeUtil.select((Schema)schema, (Set)spec.identitySourceIds()));
    }

    public static Schema convertHiveSchemaToIcebergSchema(Table hiveTable, List<String> primaryKeys) {
        List hiveSchema = hiveTable.getSd().getCols();
        hiveSchema.addAll(hiveTable.getPartitionKeys());
        HashSet<String> pkSet = new HashSet<String>(primaryKeys);
        Schema schema = org.apache.iceberg.hive.HiveSchemaUtil.convert((List)hiveSchema, (boolean)true);
        if (primaryKeys.isEmpty()) {
            return schema;
        }
        ArrayList columnsWithPk = new ArrayList();
        schema.columns().forEach(nestedField -> {
            if (pkSet.contains(nestedField.name())) {
                columnsWithPk.add(nestedField.asRequired());
            } else {
                columnsWithPk.add(nestedField);
            }
        });
        return new Schema(columnsWithPk);
    }

    public static Schema changeFieldNameToLowercase(Schema schema) {
        Types.StructType struct = ((Type)TypeUtil.visit((Type)schema.asStruct(), (TypeUtil.CustomOrderSchemaVisitor)new ChangeFieldName(ChangeFieldName.ChangeType.TO_LOWERCASE))).asStructType();
        return new Schema(struct.fields());
    }
}

