/*
 * Decompiled with CFR 0.152.
 */
package com.netease.arctic.hive.utils;

import com.netease.arctic.hive.HMSClientPool;
import com.netease.arctic.hive.utils.HiveTableUtil;
import com.netease.arctic.table.ArcticTable;
import com.netease.arctic.table.TableIdentifier;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.hadoop.hive.metastore.PartitionDropOptions;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.PrincipalPrivilegeSet;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.DataFiles;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.exceptions.NoSuchTableException;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HivePartitionUtil {
    private static final Logger LOG = LoggerFactory.getLogger(HivePartitionUtil.class);

    public static List<String> partitionValuesAsList(StructLike partitionData, Types.StructType partitionSchema) {
        List fields = partitionSchema.fields();
        ArrayList values = Lists.newArrayList();
        for (int i = 0; i < fields.size(); ++i) {
            Type type = ((Types.NestedField)fields.get(i)).type();
            Object value = partitionData.get(i, type.typeId().javaClass());
            values.add(value.toString());
        }
        return values;
    }

    public static StructLike buildPartitionData(List<String> partitionValues, PartitionSpec spec) {
        StringBuilder pathBuilder = new StringBuilder();
        for (int i = 0; i < spec.partitionType().fields().size(); ++i) {
            Types.NestedField field = (Types.NestedField)spec.partitionType().fields().get(i);
            pathBuilder.append(field.name()).append("=").append(partitionValues.get(i));
            if (i >= spec.partitionType().fields().size() - 1) continue;
            pathBuilder.append("/");
        }
        return DataFiles.data((PartitionSpec)spec, (String)pathBuilder.toString());
    }

    public static Partition newPartition(Table hiveTable, List<String> values, String location, List<DataFile> dataFiles, int createTimeInSeconds) {
        StorageDescriptor tableSd = hiveTable.getSd();
        PrincipalPrivilegeSet privilegeSet = hiveTable.getPrivileges();
        Partition p = new Partition();
        p.setValues(values);
        p.setDbName(hiveTable.getDbName());
        p.setTableName(hiveTable.getTableName());
        p.setCreateTime(createTimeInSeconds);
        p.setLastAccessTime(createTimeInSeconds);
        StorageDescriptor sd = tableSd.deepCopy();
        sd.setLocation(location);
        p.setSd(sd);
        HiveTableUtil.generateTableProperties(createTimeInSeconds, dataFiles).forEach((arg_0, arg_1) -> ((Partition)p).putToParameters(arg_0, arg_1));
        if (privilegeSet != null) {
            p.setPrivileges(privilegeSet.deepCopy());
        }
        return p;
    }

    public static Partition getPartition(HMSClientPool hmsClient, ArcticTable arcticTable, List<String> partitionValues) {
        String db = arcticTable.id().getDatabase();
        String tableName = arcticTable.id().getTableName();
        try {
            return (Partition)hmsClient.run(client -> {
                Partition partition = client.getPartition(db, tableName, partitionValues);
                return partition;
            });
        }
        catch (NoSuchObjectException e) {
            return null;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void rewriteHivePartitions(Partition partition, String location, List<DataFile> dataFiles, int accessTimestamp) {
        partition.getSd().setLocation(location);
        partition.setLastAccessTime(accessTimestamp);
        HiveTableUtil.generateTableProperties(accessTimestamp, dataFiles).forEach((arg_0, arg_1) -> ((Partition)partition).putToParameters(arg_0, arg_1));
    }

    public List<Partition> getHiveAllPartitions(HMSClientPool hiveClient, TableIdentifier tableIdentifier) {
        try {
            return (List)hiveClient.run(client -> client.listPartitions(tableIdentifier.getDatabase(), tableIdentifier.getTableName(), (short)Short.MAX_VALUE));
        }
        catch (NoSuchObjectException e) {
            throw new NoSuchTableException((Throwable)e, "Hive table does not exist: %s", new Object[]{tableIdentifier.getTableName()});
        }
        catch (TException e) {
            throw new RuntimeException("Failed to get partitions " + tableIdentifier.getTableName(), e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("Interrupted in call to listPartitions", e);
        }
    }

    public static List<String> getHivePartitionNames(HMSClientPool hiveClient, TableIdentifier tableIdentifier) {
        try {
            return ((List)hiveClient.run(client -> client.listPartitionNames(tableIdentifier.getDatabase(), tableIdentifier.getTableName(), (short)Short.MAX_VALUE))).stream().collect(Collectors.toList());
        }
        catch (NoSuchObjectException e) {
            throw new NoSuchTableException((Throwable)e, "Hive table does not exist: %s", new Object[]{tableIdentifier.getTableName()});
        }
        catch (TException e) {
            throw new RuntimeException("Failed to get partitions " + tableIdentifier.getTableName(), e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("Interrupted in call to listPartitions", e);
        }
    }

    public static List<String> getHivePartitionLocations(HMSClientPool hiveClient, TableIdentifier tableIdentifier) {
        try {
            return ((List)hiveClient.run(client -> client.listPartitions(tableIdentifier.getDatabase(), tableIdentifier.getTableName(), (short)Short.MAX_VALUE))).stream().map(partition -> partition.getSd().getLocation()).collect(Collectors.toList());
        }
        catch (NoSuchObjectException e) {
            throw new NoSuchTableException((Throwable)e, "Hive table does not exist: %s", new Object[]{tableIdentifier.getTableName()});
        }
        catch (TException e) {
            throw new RuntimeException("Failed to get partitions " + tableIdentifier.getTableName(), e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("Interrupted in call to listPartitions", e);
        }
    }

    public static void alterPartition(HMSClientPool hiveClient, TableIdentifier tableIdentifier, String partition, String newPath) throws IOException {
        try {
            LOG.info("alter table {} hive partition {} to new location {}", new Object[]{tableIdentifier, partition, newPath});
            Partition oldPartition = (Partition)hiveClient.run(client -> client.getPartition(tableIdentifier.getDatabase(), tableIdentifier.getTableName(), partition));
            Partition newPartition = new Partition(oldPartition);
            newPartition.getSd().setLocation(newPath);
            hiveClient.run(client -> {
                try {
                    client.alterPartition(tableIdentifier.getDatabase(), tableIdentifier.getTableName(), newPartition, null);
                }
                catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                    throw new RuntimeException(e);
                }
                return null;
            });
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public static void createPartitionIfAbsent(HMSClientPool hmsClient, ArcticTable arcticTable, List<String> partitionValues, String partitionLocation, List<DataFile> dataFiles, int accessTimestamp) {
        String db = arcticTable.id().getDatabase();
        String tableName = arcticTable.id().getTableName();
        try {
            hmsClient.run(client -> {
                try {
                    Partition partition = client.getPartition(db, tableName, partitionValues);
                    return partition;
                }
                catch (NoSuchObjectException noSuchObjectException) {
                    Table hiveTable = client.getTable(db, tableName);
                    Partition partition = HivePartitionUtil.newPartition(hiveTable, partitionValues, partitionLocation, dataFiles, accessTimestamp);
                    client.addPartition(partition);
                    return partition;
                }
            });
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void dropPartition(HMSClientPool hmsClient, ArcticTable arcticTable, Partition hivePartition) {
        try {
            hmsClient.run(client -> {
                PartitionDropOptions options = PartitionDropOptions.instance().deleteData(false).ifExists(true).purgeData(false).returnResults(false);
                return client.dropPartition(arcticTable.id().getDatabase(), arcticTable.id().getTableName(), hivePartition.getValues(), options);
            });
        }
        catch (InterruptedException | TException e) {
            throw new RuntimeException(e);
        }
    }

    public static void updatePartitionLocation(HMSClientPool hmsClient, ArcticTable arcticTable, Partition hivePartition, String newLocation, List<DataFile> dataFiles, int accessTimestamp) {
        HivePartitionUtil.dropPartition(hmsClient, arcticTable, hivePartition);
        HivePartitionUtil.createPartitionIfAbsent(hmsClient, arcticTable, hivePartition.getValues(), newLocation, dataFiles, accessTimestamp);
    }
}

