/*
 * Decompiled with CFR 0.152.
 */
package com.netease.arctic.hive.op;

import com.netease.arctic.hive.HMSClientPool;
import com.netease.arctic.hive.exceptions.CannotAlterHiveLocationException;
import com.netease.arctic.hive.table.UnkeyedHiveTable;
import com.netease.arctic.hive.utils.HivePartitionUtil;
import com.netease.arctic.hive.utils.HiveTableUtil;
import com.netease.arctic.op.UpdatePartitionProperties;
import com.netease.arctic.utils.FileUtil;
import com.netease.arctic.utils.TablePropertyUtil;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.metastore.PartitionDropOptions;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.FileScanTask;
import org.apache.iceberg.SnapshotUpdate;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.Transaction;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.expressions.Expressions;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.io.OutputFile;
import org.apache.iceberg.relocated.com.google.common.base.Joiner;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.relocated.com.google.common.collect.Sets;
import org.apache.iceberg.types.Types;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class UpdateHiveFiles<T extends SnapshotUpdate<T>>
implements SnapshotUpdate<T> {
    private static final Logger LOG = LoggerFactory.getLogger(UpdateHiveFiles.class);
    public static final String PROPERTIES_VALIDATE_LOCATION = "validate-location";
    protected final Transaction transaction;
    protected final boolean insideTransaction;
    protected final UnkeyedHiveTable table;
    protected final HMSClientPool hmsClient;
    protected final HMSClientPool transactionClient;
    protected final String db;
    protected final String tableName;
    protected final Table hiveTable;
    protected Expression expr;
    protected final List<DataFile> addFiles = Lists.newArrayList();
    protected final List<DataFile> deleteFiles = Lists.newArrayList();
    protected Map<StructLike, Partition> partitionToDelete = Maps.newHashMap();
    protected Map<StructLike, Partition> partitionToCreate = Maps.newHashMap();
    protected final Map<StructLike, Partition> partitionToAlter = Maps.newHashMap();
    protected String unpartitionTableLocation;
    protected long txId = -1L;
    protected boolean validateLocation = true;
    protected int commitTimestamp;

    public UpdateHiveFiles(Transaction transaction, boolean insideTransaction, UnkeyedHiveTable table, HMSClientPool hmsClient, HMSClientPool transactionClient) {
        this.transaction = transaction;
        this.insideTransaction = insideTransaction;
        this.table = table;
        this.hmsClient = hmsClient;
        this.transactionClient = transactionClient;
        this.db = table.id().getDatabase();
        this.tableName = table.id().getTableName();
        try {
            this.hiveTable = (Table)hmsClient.run(c -> c.getTable(this.db, this.tableName));
        }
        catch (InterruptedException | TException e) {
            throw new RuntimeException(e);
        }
    }

    abstract SnapshotUpdate<?> getSnapshotUpdateDelegate();

    public void commit() {
        this.commitTimestamp = (int)(System.currentTimeMillis() / 1000L);
        if (this.table.spec().isUnpartitioned()) {
            this.generateUnpartitionTableLocation();
        } else {
            this.partitionToDelete = this.getDeletePartition();
            this.partitionToCreate = this.getCreatePartition(this.partitionToDelete);
        }
        boolean noHiveDataFilesChanged = CollectionUtils.isEmpty(this.addFiles) && CollectionUtils.isEmpty(this.deleteFiles) && this.expr != Expressions.alwaysTrue();
        this.getSnapshotUpdateDelegate().commit();
        if (!noHiveDataFilesChanged) {
            this.commitPartitionProperties();
        }
        if (!this.insideTransaction) {
            this.transaction.commitTransaction();
        }
        if (noHiveDataFilesChanged) {
            return;
        }
        try {
            if (this.table.spec().isUnpartitioned()) {
                this.commitNonPartitionedTable();
            } else {
                this.commitPartitionedTable();
            }
        }
        catch (Exception e) {
            LOG.warn("Commit operation to HMS failed.", (Throwable)e);
        }
    }

    private void commitPartitionProperties() {
        UpdatePartitionProperties updatePartitionProperties = this.table.updatePartitionProperties(this.transaction);
        if (this.table.spec().isUnpartitioned()) {
            updatePartitionProperties.set(TablePropertyUtil.EMPTY_STRUCT, "hive-location", this.unpartitionTableLocation);
            updatePartitionProperties.set(TablePropertyUtil.EMPTY_STRUCT, "transient-time", this.commitTimestamp + "");
        } else {
            this.partitionToDelete.forEach((partitionData, partition) -> {
                if (!this.partitionToCreate.containsKey(partitionData)) {
                    updatePartitionProperties.remove(partitionData, "hive-location");
                    updatePartitionProperties.remove(partitionData, "transient-time");
                }
            });
            this.partitionToCreate.forEach((partitionData, partition) -> {
                updatePartitionProperties.set(partitionData, "hive-location", partition.getSd().getLocation());
                updatePartitionProperties.set(partitionData, "transient-time", this.commitTimestamp + "");
            });
            this.partitionToAlter.forEach((partitionData, partition) -> {
                updatePartitionProperties.set(partitionData, "hive-location", partition.getSd().getLocation());
                updatePartitionProperties.set(partitionData, "transient-time", this.commitTimestamp + "");
            });
        }
        updatePartitionProperties.commit();
    }

    protected Map<StructLike, Partition> getCreatePartition(Map<StructLike, Partition> partitionToDelete) {
        String location;
        if (this.addFiles.isEmpty()) {
            return Maps.newHashMap();
        }
        HashMap partitionLocationMap = Maps.newHashMap();
        HashMap partitionDataFileMap = Maps.newHashMap();
        HashMap partitionValueMap = Maps.newHashMap();
        Types.StructType partitionSchema = this.table.spec().partitionType();
        for (DataFile d : this.addFiles) {
            List<String> partitionValues = HivePartitionUtil.partitionValuesAsList(d.partition(), partitionSchema);
            String value = Joiner.on((String)"/").join(partitionValues);
            location = FileUtil.getFileDir((String)d.path().toString());
            partitionLocationMap.put(value, location);
            if (!partitionDataFileMap.containsKey(value)) {
                partitionDataFileMap.put(value, Lists.newArrayList());
            }
            ((List)partitionDataFileMap.get(value)).add(d);
            partitionValueMap.put(value, partitionValues);
        }
        Map<Object, Object> createPartitions = Maps.newHashMap();
        for (String val : partitionValueMap.keySet()) {
            List values = (List)partitionValueMap.get(val);
            location = (String)partitionLocationMap.get(val);
            List dataFiles = (List)partitionDataFileMap.get(val);
            this.checkCreatePartitionDataFiles(dataFiles, location);
            Partition p = HivePartitionUtil.newPartition(this.hiveTable, values, location, dataFiles, this.commitTimestamp);
            createPartitions.put(((DataFile)dataFiles.get(0)).partition(), p);
        }
        createPartitions = this.filterNewPartitionNonExists((Map<StructLike, Partition>)createPartitions, partitionToDelete);
        return createPartitions;
    }

    protected Map<StructLike, Partition> getDeletePartition() {
        if (this.expr != null) {
            List<DataFile> deleteFilesByExpr = this.applyDeleteExpr();
            this.deleteFiles.addAll(deleteFilesByExpr);
        }
        HashMap deletePartitions = Maps.newHashMap();
        if (this.deleteFiles.isEmpty()) {
            return deletePartitions;
        }
        Types.StructType partitionSchema = this.table.spec().partitionType();
        HashSet checkedPartitionValues = Sets.newHashSet();
        HashSet deleteFileLocations = Sets.newHashSet();
        for (DataFile dataFile : this.deleteFiles) {
            List<String> values = HivePartitionUtil.partitionValuesAsList(dataFile.partition(), partitionSchema);
            String pathValue = Joiner.on((String)"/").join(values);
            deleteFileLocations.add(new Path(dataFile.path().toString()));
            if (checkedPartitionValues.contains(pathValue)) continue;
            try {
                Partition partition = (Partition)this.hmsClient.run(c -> c.getPartition(this.db, this.tableName, values));
                deletePartitions.put(dataFile.partition(), partition);
            }
            catch (NoSuchObjectException partition) {
            }
            catch (InterruptedException | TException e) {
                throw new RuntimeException(e);
            }
            checkedPartitionValues.add(pathValue);
        }
        if (this.validateLocation) {
            deletePartitions.values().forEach(p -> this.checkPartitionDelete(deleteFileLocations, (Partition)p));
        }
        return deletePartitions;
    }

    private void checkPartitionDelete(Set<Path> deleteFiles, Partition partition) {
        String partitionLocation = partition.getSd().getLocation();
        List files = this.table.io().list(partitionLocation);
        for (FileStatus f : files) {
            Path filePath = f.getPath();
            if (deleteFiles.contains(filePath)) continue;
            throw new CannotAlterHiveLocationException("can't delete hive partition: " + this.partitionToString(partition) + ", file under partition is not deleted: " + filePath.toString());
        }
    }

    private void checkCreatePartitionDataFiles(List<DataFile> addFiles, String partitionLocation) {
        Path partitionPath = new Path(partitionLocation);
        for (DataFile df : addFiles) {
            String fileDir = FileUtil.getFileDir((String)df.path().toString());
            Path dirPath = new Path(fileDir);
            if (partitionPath.equals((Object)dirPath)) continue;
            throw new CannotAlterHiveLocationException("can't create new hive location: " + partitionLocation + " for data file: " + df.path().toString() + " is not under partition location path");
        }
    }

    private Map<StructLike, Partition> filterNewPartitionNonExists(Map<StructLike, Partition> partitionToCreate, Map<StructLike, Partition> partitionToDelete) {
        String partValue;
        HashMap partitions = Maps.newHashMap();
        HashMap deletePartitionValueMap = Maps.newHashMap();
        for (Partition partition : partitionToDelete.values()) {
            partValue = Joiner.on((String)"/").join((Iterable)partition.getValues());
            deletePartitionValueMap.put(partValue, partition);
        }
        for (Map.Entry entry : partitionToCreate.entrySet()) {
            partValue = Joiner.on((String)"/").join((Iterable)((Partition)entry.getValue()).getValues());
            String location = ((Partition)entry.getValue()).getSd().getLocation();
            Partition toDelete = (Partition)deletePartitionValueMap.get(partValue);
            if (toDelete != null) {
                String deleteLocation = toDelete.getSd().getLocation();
                if (this.isPathEquals(location, deleteLocation) && this.validateLocation) {
                    throw new CannotAlterHiveLocationException("can't create new partition: " + this.partitionToString((Partition)entry.getValue()) + ", this partition will be delete and re-create with same location");
                }
                partitions.put(entry.getKey(), entry.getValue());
                continue;
            }
            try {
                Partition partitionInHive = (Partition)this.hmsClient.run(c -> c.getPartition(this.db, this.tableName, ((Partition)entry.getValue()).getValues()));
                String locationInHive = partitionInHive.getSd().getLocation();
                if (this.isPathEquals(location, locationInHive)) {
                    this.partitionToAlter.put((StructLike)entry.getKey(), (Partition)entry.getValue());
                    continue;
                }
                throw new CannotAlterHiveLocationException("can't create new partition: " + this.partitionToString((Partition)entry.getValue()) + ", this partition exists in hive with different location: " + locationInHive);
            }
            catch (NoSuchObjectException e) {
                partitions.put(entry.getKey(), entry.getValue());
            }
            catch (InterruptedException | TException e) {
                throw new RuntimeException(e);
            }
        }
        return partitions;
    }

    private void commitPartitionedTable() {
        if (!this.partitionToDelete.isEmpty()) {
            for (Partition p : this.partitionToDelete.values()) {
                try {
                    this.transactionClient.run(c -> {
                        PartitionDropOptions options = PartitionDropOptions.instance().deleteData(false).ifExists(true).purgeData(false).returnResults(false);
                        c.dropPartition(this.db, this.tableName, p.getValues(), options);
                        return 0;
                    });
                }
                catch (NoSuchObjectException e) {
                    LOG.warn("try to delete hive partition {} but partition not exist.", (Object)p);
                }
                catch (InterruptedException | TException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        if (!this.partitionToCreate.isEmpty()) {
            try {
                this.transactionClient.run(c -> c.addPartitions(Lists.newArrayList(this.partitionToCreate.values())));
            }
            catch (InterruptedException | TException e) {
                throw new RuntimeException(e);
            }
        }
        if (!this.partitionToAlter.isEmpty()) {
            try {
                this.transactionClient.run(c -> {
                    try {
                        c.alterPartitions(this.db, this.tableName, Lists.newArrayList(this.partitionToAlter.values()), null);
                    }
                    catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                        throw new RuntimeException(e);
                    }
                    return null;
                });
            }
            catch (InterruptedException | TException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private void generateUnpartitionTableLocation() {
        this.unpartitionTableLocation = this.addFiles.isEmpty() ? this.createUnpartitionEmptyLocationForHive() : FileUtil.getFileDir((String)this.addFiles.get(0).path().toString());
    }

    private void commitNonPartitionedTable() {
        String finalLocation = this.unpartitionTableLocation;
        try {
            this.transactionClient.run(c -> {
                Table hiveTable = c.getTable(this.db, this.tableName);
                hiveTable.getSd().setLocation(finalLocation);
                HiveTableUtil.generateTableProperties(this.commitTimestamp, this.addFiles).forEach((key, value) -> hiveTable.getParameters().put(key, value));
                c.alterTable(this.db, this.tableName, hiveTable);
                return 0;
            });
        }
        catch (InterruptedException | TException e) {
            throw new RuntimeException(e);
        }
    }

    private String createUnpartitionEmptyLocationForHive() {
        String newLocation = HiveTableUtil.newHiveDataLocation(this.table.hiveLocation(), this.table.spec(), null, HiveTableUtil.newHiveSubdirectory(this.txId));
        OutputFile file = this.table.io().newOutputFile(newLocation + "/.keep");
        try {
            file.createOrOverwrite().close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return newLocation;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected List<DataFile> applyDeleteExpr() {
        try (CloseableIterable tasks = this.table.newScan().filter(this.expr).planFiles();){
            List<DataFile> list = Lists.newArrayList((Iterable)tasks).stream().map(FileScanTask::file).collect(Collectors.toList());
            return list;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private boolean isPathEquals(String pathA, String pathB) {
        Path path1 = new Path(pathA);
        Path path2 = new Path(pathB);
        return path1.equals((Object)path2);
    }

    private String partitionToString(Partition p) {
        return "Partition(values: [" + Joiner.on((String)"/").join((Iterable)p.getValues()) + "], location: " + p.getSd().getLocation() + ")";
    }
}

