/*
 * Decompiled with CFR 0.152.
 */
package com.netease.arctic.hive.op;

import com.netease.arctic.hive.HMSClientPool;
import com.netease.arctic.hive.op.UpdateHiveFiles;
import com.netease.arctic.hive.table.UnkeyedHiveTable;
import java.util.function.Consumer;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.OverwriteFiles;
import org.apache.iceberg.Snapshot;
import org.apache.iceberg.SnapshotUpdate;
import org.apache.iceberg.Transaction;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.expressions.Expressions;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;

public class OverwriteHiveFiles
extends UpdateHiveFiles<OverwriteFiles>
implements OverwriteFiles {
    private final OverwriteFiles delegate;

    public OverwriteHiveFiles(Transaction transaction, boolean insideTransaction, UnkeyedHiveTable table, HMSClientPool hmsClient, HMSClientPool transactionClient) {
        super(transaction, insideTransaction, table, hmsClient, transactionClient);
        this.delegate = transaction.newOverwrite();
    }

    @Override
    SnapshotUpdate<?> getSnapshotUpdateDelegate() {
        return this.delegate;
    }

    public OverwriteFiles overwriteByRowFilter(Expression expr) {
        Preconditions.checkArgument((!this.table.spec().isUnpartitioned() || expr == Expressions.alwaysTrue() ? 1 : 0) != 0, (Object)"Unpartitioned hive table support alwaysTrue expression only");
        this.delegate.overwriteByRowFilter(expr);
        this.expr = expr;
        return this;
    }

    public OverwriteFiles addFile(DataFile file) {
        this.delegate.addFile(file);
        String hiveLocationRoot = this.table.hiveLocation();
        String dataFileLocation = file.path().toString();
        if (dataFileLocation.toLowerCase().contains(hiveLocationRoot.toLowerCase())) {
            this.addFiles.add(file);
        }
        return this;
    }

    public OverwriteFiles deleteFile(DataFile file) {
        this.delegate.deleteFile(file);
        String hiveLocation = this.table.hiveLocation();
        String dataFileLocation = file.path().toString();
        if (dataFileLocation.toLowerCase().contains(hiveLocation.toLowerCase())) {
            this.deleteFiles.add(file);
        }
        return this;
    }

    public OverwriteFiles validateAddedFilesMatchOverwriteFilter() {
        this.delegate.validateAddedFilesMatchOverwriteFilter();
        return this;
    }

    public OverwriteFiles validateFromSnapshot(long snapshotId) {
        this.delegate.validateFromSnapshot(snapshotId);
        return this;
    }

    public OverwriteFiles caseSensitive(boolean caseSensitive) {
        this.delegate.caseSensitive(caseSensitive);
        return this;
    }

    public OverwriteFiles validateNoConflictingAppends(Expression conflictDetectionFilter) {
        this.delegate.validateNoConflictingAppends(conflictDetectionFilter);
        return this;
    }

    public OverwriteFiles conflictDetectionFilter(Expression conflictDetectionFilter) {
        this.delegate.conflictDetectionFilter(conflictDetectionFilter);
        return this;
    }

    public OverwriteFiles validateNoConflictingData() {
        this.delegate.validateNoConflictingData();
        return this;
    }

    public OverwriteFiles validateNoConflictingDeletes() {
        this.delegate.validateNoConflictingDeletes();
        return this;
    }

    public OverwriteFiles set(String property, String value) {
        if ("txId".equals(property)) {
            this.txId = Long.parseLong(value);
        }
        if ("validate-location".equals(property)) {
            this.validateLocation = Boolean.parseBoolean(value);
        }
        this.delegate.set(property, value);
        return this;
    }

    public OverwriteFiles deleteWith(Consumer<String> deleteFunc) {
        this.delegate.deleteWith(deleteFunc);
        return this;
    }

    public OverwriteFiles stageOnly() {
        this.delegate.stageOnly();
        return this;
    }

    public Snapshot apply() {
        return (Snapshot)this.delegate.apply();
    }

    public Object updateEvent() {
        return this.delegate.updateEvent();
    }
}

