/*
 * Decompiled with CFR 0.152.
 */
package com.netease.arctic.hive.io.writer;

import com.netease.arctic.data.ChangeAction;
import com.netease.arctic.hive.io.writer.AdaptHiveOperateToTableRelation;
import com.netease.arctic.hive.io.writer.AdaptHiveOutputFileFactory;
import com.netease.arctic.hive.table.HiveLocationKind;
import com.netease.arctic.hive.table.SupportHive;
import com.netease.arctic.hive.utils.TableTypeUtil;
import com.netease.arctic.io.writer.CommonOutputFileFactory;
import com.netease.arctic.io.writer.GenericBaseTaskWriter;
import com.netease.arctic.io.writer.GenericChangeTaskWriter;
import com.netease.arctic.io.writer.OutputFileFactory;
import com.netease.arctic.io.writer.SortedPosDeleteWriter;
import com.netease.arctic.io.writer.TaskWriterBuilder;
import com.netease.arctic.table.ArcticTable;
import com.netease.arctic.table.BaseLocationKind;
import com.netease.arctic.table.ChangeLocationKind;
import com.netease.arctic.table.KeyedTable;
import com.netease.arctic.table.LocationKind;
import com.netease.arctic.table.PrimaryKeySpec;
import com.netease.arctic.table.UnkeyedTable;
import com.netease.arctic.table.WriteOperationKind;
import com.netease.arctic.utils.SchemaUtil;
import java.util.Locale;
import java.util.Map;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.MetadataColumns;
import org.apache.iceberg.MetricsModes;
import org.apache.iceberg.Schema;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.data.AdaptHiveGenericAppenderFactory;
import org.apache.iceberg.data.GenericAppenderFactory;
import org.apache.iceberg.data.Record;
import org.apache.iceberg.encryption.EncryptionManager;
import org.apache.iceberg.io.FileAppenderFactory;
import org.apache.iceberg.io.TaskWriter;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.util.PropertyUtil;

public class AdaptHiveGenericTaskWriterBuilder
implements TaskWriterBuilder<Record> {
    private final ArcticTable table;
    private Long transactionId;
    private int partitionId = 0;
    private int taskId = 0;
    private ChangeAction changeAction = ChangeAction.INSERT;
    private String customHiveSubdirectory;
    private Long targetFileSize;

    private AdaptHiveGenericTaskWriterBuilder(ArcticTable table) {
        this.table = table;
    }

    public AdaptHiveGenericTaskWriterBuilder withTransactionId(Long transactionId) {
        this.transactionId = transactionId;
        return this;
    }

    public AdaptHiveGenericTaskWriterBuilder withPartitionId(int partitionId) {
        this.partitionId = partitionId;
        return this;
    }

    public AdaptHiveGenericTaskWriterBuilder withTaskId(int taskId) {
        this.taskId = taskId;
        return this;
    }

    public AdaptHiveGenericTaskWriterBuilder withChangeAction(ChangeAction changeAction) {
        this.changeAction = changeAction;
        return this;
    }

    public AdaptHiveGenericTaskWriterBuilder withCustomHiveSubdirectory(String customHiveSubdirectory) {
        this.customHiveSubdirectory = customHiveSubdirectory;
        return this;
    }

    public AdaptHiveGenericTaskWriterBuilder withTargetFileSize(long targetFileSize) {
        this.targetFileSize = targetFileSize;
        return this;
    }

    public TaskWriter<Record> buildWriter(WriteOperationKind writeOperationKind) {
        LocationKind locationKind = AdaptHiveOperateToTableRelation.INSTANT.getLocationKindsFromOperateKind(this.table, writeOperationKind);
        return this.buildWriter(locationKind);
    }

    public TaskWriter<Record> buildWriter(LocationKind locationKind) {
        if (locationKind == ChangeLocationKind.INSTANT) {
            return this.buildChangeWriter();
        }
        if (locationKind == BaseLocationKind.INSTANT || locationKind == HiveLocationKind.INSTANT) {
            return this.buildBaseWriter(locationKind);
        }
        throw new IllegalArgumentException("Not support Location Kind:" + locationKind);
    }

    public SortedPosDeleteWriter<Record> buildBasePosDeleteWriter(long mask, long index, StructLike partitionKey) {
        this.preconditions();
        UnkeyedTable baseTable = this.table.isKeyedTable() ? this.table.asKeyedTable().baseTable() : this.table.asUnkeyedTable();
        FileFormat fileFormat = FileFormat.valueOf((String)baseTable.properties().getOrDefault("base.write.format", "parquet").toUpperCase(Locale.ENGLISH));
        GenericAppenderFactory appenderFactory = new GenericAppenderFactory(baseTable.schema(), baseTable.spec());
        appenderFactory.set("write.metadata.metrics.column." + MetadataColumns.DELETE_FILE_PATH.name(), MetricsModes.Full.get().toString());
        appenderFactory.set("write.metadata.metrics.column." + MetadataColumns.DELETE_FILE_POS.name(), MetricsModes.Full.get().toString());
        return new SortedPosDeleteWriter((FileAppenderFactory)appenderFactory, (OutputFileFactory)new CommonOutputFileFactory(baseTable.location(), baseTable.spec(), fileFormat, baseTable.io(), baseTable.encryption(), this.partitionId, (long)this.taskId, this.transactionId), this.table.io(), fileFormat, mask, index, partitionKey);
    }

    private GenericBaseTaskWriter buildBaseWriter(LocationKind locationKind) {
        Schema schema;
        EncryptionManager encryptionManager;
        String baseLocation;
        this.preconditions();
        FileFormat fileFormat = FileFormat.valueOf((String)this.table.properties().getOrDefault("base.write.format", "parquet").toUpperCase(Locale.ENGLISH));
        long fileSizeBytes = this.targetFileSize == null ? PropertyUtil.propertyAsLong((Map)this.table.properties(), (String)"write.target-file-size-bytes", (long)0x8000000L) : this.targetFileSize;
        long mask = PropertyUtil.propertyAsLong((Map)this.table.properties(), (String)"base.file-index.hash-bucket", (long)4L) - 1L;
        PrimaryKeySpec primaryKeySpec = null;
        if (this.table.isKeyedTable()) {
            KeyedTable keyedTable = this.table.asKeyedTable();
            baseLocation = keyedTable.baseLocation();
            encryptionManager = keyedTable.baseTable().encryption();
            schema = keyedTable.baseTable().schema();
            primaryKeySpec = keyedTable.primaryKeySpec();
        } else {
            UnkeyedTable table = this.table.asUnkeyedTable();
            baseLocation = table.location();
            encryptionManager = table.encryption();
            schema = table.schema();
        }
        AdaptHiveOutputFileFactory outputFileFactory = locationKind == HiveLocationKind.INSTANT ? new AdaptHiveOutputFileFactory(((SupportHive)this.table).hiveLocation(), this.table.spec(), fileFormat, this.table.io(), encryptionManager, this.partitionId, this.taskId, this.transactionId, this.customHiveSubdirectory) : new CommonOutputFileFactory(baseLocation, this.table.spec(), fileFormat, this.table.io(), encryptionManager, this.partitionId, (long)this.taskId, this.transactionId);
        AdaptHiveGenericAppenderFactory appenderFactory = TableTypeUtil.isHive(this.table) ? new AdaptHiveGenericAppenderFactory(schema, this.table.spec()) : new GenericAppenderFactory(schema, this.table.spec());
        return new GenericBaseTaskWriter(fileFormat, (FileAppenderFactory)appenderFactory, (OutputFileFactory)outputFileFactory, this.table.io(), fileSizeBytes, mask, schema, this.table.spec(), primaryKeySpec);
    }

    private GenericChangeTaskWriter buildChangeWriter() {
        if (this.table.isUnkeyedTable()) {
            throw new IllegalArgumentException("UnKeyed table UnSupport change writer");
        }
        this.preconditions();
        KeyedTable table = (KeyedTable)this.table;
        FileFormat fileFormat = FileFormat.valueOf((String)table.properties().getOrDefault("change.write.format", "parquet").toUpperCase(Locale.ENGLISH));
        long fileSizeBytes = this.targetFileSize == null ? PropertyUtil.propertyAsLong((Map)table.properties(), (String)"write.target-file-size-bytes", (long)0x8000000L) : this.targetFileSize;
        long mask = PropertyUtil.propertyAsLong((Map)table.properties(), (String)"change.file-index.hash-bucket", (long)4L) - 1L;
        Schema changeWriteSchema = SchemaUtil.changeWriteSchema((Schema)table.changeTable().schema());
        AdaptHiveGenericAppenderFactory appenderFactory = TableTypeUtil.isHive((ArcticTable)table) ? new AdaptHiveGenericAppenderFactory(changeWriteSchema, table.spec()) : new GenericAppenderFactory(changeWriteSchema, table.spec());
        return new GenericChangeTaskWriter(fileFormat, (FileAppenderFactory)appenderFactory, (OutputFileFactory)new CommonOutputFileFactory(table.changeLocation(), table.spec(), fileFormat, table.io(), table.changeTable().encryption(), this.partitionId, (long)this.taskId, this.transactionId), table.io(), fileSizeBytes, mask, table.changeTable().schema(), table.spec(), table.primaryKeySpec(), this.changeAction);
    }

    private void preconditions() {
        if (this.table.isKeyedTable()) {
            Preconditions.checkNotNull((Object)this.transactionId);
        } else {
            Preconditions.checkArgument((this.transactionId == null ? 1 : 0) != 0);
        }
    }

    public static AdaptHiveGenericTaskWriterBuilder builderFor(ArcticTable table) {
        return new AdaptHiveGenericTaskWriterBuilder(table);
    }
}

