/*
 * Decompiled with CFR 0.152.
 */
package com.netease.arctic.hive.catalog;

import com.netease.arctic.AmsClient;
import com.netease.arctic.ams.api.CatalogMeta;
import com.netease.arctic.ams.api.TableMeta;
import com.netease.arctic.catalog.BaseArcticCatalog;
import com.netease.arctic.hive.CachedHiveClientPool;
import com.netease.arctic.hive.HMSClient;
import com.netease.arctic.hive.HMSClientPool;
import com.netease.arctic.hive.table.KeyedHiveTable;
import com.netease.arctic.hive.table.UnkeyedHiveTable;
import com.netease.arctic.hive.utils.HiveSchemaUtil;
import com.netease.arctic.hive.utils.HiveTableUtil;
import com.netease.arctic.io.ArcticFileIO;
import com.netease.arctic.io.ArcticHadoopFileIO;
import com.netease.arctic.table.PrimaryKeySpec;
import com.netease.arctic.table.TableBuilder;
import com.netease.arctic.table.TableIdentifier;
import com.netease.arctic.utils.CatalogUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.IcebergSchemaUtil;
import org.apache.iceberg.PartitionField;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.SortOrder;
import org.apache.iceberg.Table;
import org.apache.iceberg.mapping.MappingUtil;
import org.apache.iceberg.mapping.NameMapping;
import org.apache.iceberg.mapping.NameMappingParser;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.util.PropertyUtil;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArcticHiveCatalog
extends BaseArcticCatalog {
    private static final Logger LOG = LoggerFactory.getLogger(ArcticHiveCatalog.class);
    private CachedHiveClientPool hiveClientPool;

    public void initialize(AmsClient client, CatalogMeta meta, Map<String, String> properties) {
        super.initialize(client, meta, properties);
        this.hiveClientPool = new CachedHiveClientPool(this.tableMetaStore, properties);
    }

    public List<String> listDatabases() {
        try {
            return (List)this.hiveClientPool.run(HMSClient::getAllDatabases);
        }
        catch (InterruptedException | TException e) {
            throw new RuntimeException("Failed to list databases", e);
        }
    }

    public void createDatabase(String databaseName) {
        try {
            this.hiveClientPool.run(client -> {
                Database database = new Database();
                database.setName(databaseName);
                client.createDatabase(database);
                return null;
            });
        }
        catch (InterruptedException | TException e) {
            throw new RuntimeException("Failed to create database:" + databaseName, e);
        }
    }

    protected TableMeta getArcticTableMeta(TableIdentifier identifier) {
        return super.getArcticTableMeta(identifier.toLowCaseIdentifier());
    }

    public void dropDatabase(String databaseName) {
        try {
            this.hiveClientPool.run(client -> {
                client.dropDatabase(databaseName, false, false, false);
                return null;
            });
        }
        catch (InterruptedException | TException e) {
            throw new RuntimeException("Failed to drop database:" + databaseName, e);
        }
    }

    protected void doDropTable(TableMeta meta, boolean purge) {
        try {
            this.hiveClientPool.run(client -> {
                client.dropTable(meta.getTableIdentifier().getDatabase(), meta.getTableIdentifier().getTableName(), false, false);
                return null;
            });
        }
        catch (InterruptedException | TException e) {
            throw new RuntimeException("Failed to drop table:" + meta.getTableIdentifier(), e);
        }
        super.doDropTable(meta, purge);
    }

    public void dropTableButNotDropHiveTable(TableIdentifier tableIdentifier) {
        TableMeta meta = this.getArcticTableMeta(tableIdentifier);
        super.doDropTable(meta, false);
    }

    public TableBuilder newTableBuilder(TableIdentifier identifier, Schema schema) {
        return new ArcticHiveTableBuilder(identifier, schema);
    }

    protected KeyedHiveTable loadKeyedTable(TableMeta tableMeta) {
        TableIdentifier tableIdentifier = TableIdentifier.of((com.netease.arctic.ams.api.TableIdentifier)tableMeta.getTableIdentifier());
        String tableLocation = this.checkLocation(tableMeta, "table");
        String baseLocation = this.checkLocation(tableMeta, "base");
        String changeLocation = this.checkLocation(tableMeta, "change");
        ArcticHadoopFileIO fileIO = new ArcticHadoopFileIO(this.tableMetaStore);
        Table baseIcebergTable = (Table)this.tableMetaStore.doAs(() -> this.tables.load(baseLocation));
        UnkeyedHiveTable baseTable = new UnkeyedHiveTable(tableIdentifier, CatalogUtil.useArcticTableOperations((Table)baseIcebergTable, (String)baseLocation, (ArcticFileIO)fileIO, (Configuration)this.tableMetaStore.getConfiguration()), (ArcticFileIO)fileIO, tableLocation, this.client, this.hiveClientPool, false);
        Table changeIcebergTable = (Table)this.tableMetaStore.doAs(() -> this.tables.load(changeLocation));
        KeyedHiveTable.HiveChangeInternalTable changeTable = new KeyedHiveTable.HiveChangeInternalTable(tableIdentifier, CatalogUtil.useArcticTableOperations((Table)changeIcebergTable, (String)changeLocation, (ArcticFileIO)fileIO, (Configuration)this.tableMetaStore.getConfiguration()), (ArcticFileIO)fileIO, this.client);
        return new KeyedHiveTable(tableMeta, tableLocation, this.buildPrimaryKeySpec(baseTable.schema(), tableMeta), this.client, this.hiveClientPool, baseTable, changeTable);
    }

    protected UnkeyedHiveTable loadUnKeyedTable(TableMeta tableMeta) {
        TableIdentifier tableIdentifier = TableIdentifier.of((com.netease.arctic.ams.api.TableIdentifier)tableMeta.getTableIdentifier());
        String baseLocation = this.checkLocation(tableMeta, "base");
        String tableLocation = this.checkLocation(tableMeta, "table");
        Table table = (Table)this.tableMetaStore.doAs(() -> this.tables.load(baseLocation));
        ArcticHadoopFileIO arcticFileIO = new ArcticHadoopFileIO(this.tableMetaStore);
        return new UnkeyedHiveTable(tableIdentifier, CatalogUtil.useArcticTableOperations((Table)table, (String)baseLocation, (ArcticFileIO)arcticFileIO, (Configuration)this.tableMetaStore.getConfiguration()), (ArcticFileIO)arcticFileIO, tableLocation, this.client, this.hiveClientPool);
    }

    public HMSClientPool getHMSClient() {
        return this.hiveClientPool;
    }

    class ArcticHiveTableBuilder
    extends BaseArcticCatalog.BaseArcticTableBuilder {
        boolean allowExistedHiveTable;

        public ArcticHiveTableBuilder(TableIdentifier identifier, Schema schema) {
            super((BaseArcticCatalog)ArcticHiveCatalog.this, identifier.toLowCaseIdentifier(), HiveSchemaUtil.changeFieldNameToLowercase(schema));
            this.allowExistedHiveTable = false;
        }

        public TableBuilder withPartitionSpec(PartitionSpec partitionSpec) {
            return super.withPartitionSpec(IcebergSchemaUtil.copyPartitionSpec(partitionSpec, this.schema));
        }

        public TableBuilder withSortOrder(SortOrder sortOrder) {
            return super.withSortOrder(IcebergSchemaUtil.copySortOrderSpec(sortOrder, this.schema));
        }

        public TableBuilder withPrimaryKeySpec(PrimaryKeySpec primaryKeySpec) {
            PrimaryKeySpec.Builder builder = PrimaryKeySpec.builderFor((Schema)this.schema);
            primaryKeySpec.fields().forEach(primaryKeyField -> builder.addColumn(primaryKeyField.fieldName().toLowerCase(Locale.ROOT)));
            return super.withPrimaryKeySpec(builder.build());
        }

        public TableBuilder withProperty(String key, String value) {
            if (key.equals("allow-hive-table-existed") && value.equals("true")) {
                this.allowExistedHiveTable = true;
            } else if (key.equals("table.event-time-field")) {
                super.withProperty(key, value.toLowerCase(Locale.ROOT));
            } else {
                super.withProperty(key, value);
            }
            return this;
        }

        public TableBuilder withProperties(Map<String, String> properties) {
            properties.forEach(this::withProperty);
            return this;
        }

        protected void doCreateCheck() {
            super.doCreateCheck();
            try {
                if (this.allowExistedHiveTable) {
                    LOG.info("No need to check hive table exist");
                } else {
                    org.apache.hadoop.hive.metastore.api.Table hiveTable = (org.apache.hadoop.hive.metastore.api.Table)ArcticHiveCatalog.this.hiveClientPool.run(client -> client.getTable(this.identifier.getDatabase(), this.identifier.getTableName()));
                    if (hiveTable != null) {
                        throw new IllegalArgumentException("Table is already existed in hive meta store:" + this.identifier);
                    }
                }
            }
            catch (NoSuchObjectException hiveTable) {
            }
            catch (InterruptedException | TException e) {
                throw new RuntimeException("Failed to check table exist:" + this.identifier, e);
            }
            if (!this.partitionSpec.isUnpartitioned()) {
                for (PartitionField partitionField : this.partitionSpec.fields()) {
                    if (!partitionField.transform().isIdentity()) {
                        throw new IllegalArgumentException("Unsupported partition transform:" + partitionField.transform().toString());
                    }
                    Preconditions.checkArgument((this.schema.columns().indexOf(this.schema.findField(partitionField.sourceId())) >= this.schema.columns().size() - this.partitionSpec.fields().size() ? 1 : 0) != 0, (Object)"Partition field should be at last of schema");
                }
            }
        }

        protected KeyedHiveTable createKeyedTable(TableMeta meta) {
            TableIdentifier tableIdentifier = TableIdentifier.of((com.netease.arctic.ams.api.TableIdentifier)meta.getTableIdentifier());
            String baseLocation = ArcticHiveCatalog.this.checkLocation(meta, "base");
            String changeLocation = ArcticHiveCatalog.this.checkLocation(meta, "change");
            String tableLocation = ArcticHiveCatalog.this.checkLocation(meta, "table");
            this.fillTableProperties(meta);
            String hiveLocation = (String)meta.getProperties().get("base.hive.location-root");
            if (!meta.properties.containsKey("self-optimizing.full.trigger.interval")) {
                meta.putToProperties("self-optimizing.full.trigger.interval", "86400000");
            }
            ArcticHadoopFileIO fileIO = new ArcticHadoopFileIO(ArcticHiveCatalog.this.tableMetaStore);
            Table baseIcebergTable = (Table)ArcticHiveCatalog.this.tableMetaStore.doAs(() -> {
                try {
                    Table createTable = ArcticHiveCatalog.this.tables.create(this.schema, this.partitionSpec, meta.getProperties(), baseLocation);
                    createTable.updateProperties().set("schema.name-mapping.default", NameMappingParser.toJson((NameMapping)MappingUtil.create((Schema)createTable.schema()))).commit();
                    return createTable;
                }
                catch (Exception e) {
                    throw new IllegalStateException("create base table failed", e);
                }
            });
            UnkeyedHiveTable baseTable = new UnkeyedHiveTable(tableIdentifier, CatalogUtil.useArcticTableOperations((Table)baseIcebergTable, (String)baseLocation, (ArcticFileIO)fileIO, (Configuration)ArcticHiveCatalog.this.tableMetaStore.getConfiguration()), (ArcticFileIO)fileIO, tableLocation, ArcticHiveCatalog.this.client, ArcticHiveCatalog.this.hiveClientPool, false);
            Table changeIcebergTable = (Table)ArcticHiveCatalog.this.tableMetaStore.doAs(() -> {
                try {
                    Table createTable = ArcticHiveCatalog.this.tables.create(this.schema, this.partitionSpec, meta.getProperties(), changeLocation);
                    createTable.updateProperties().set("schema.name-mapping.default", NameMappingParser.toJson((NameMapping)MappingUtil.create((Schema)createTable.schema()))).commit();
                    return createTable;
                }
                catch (Exception e) {
                    throw new IllegalStateException("create change table failed", e);
                }
            });
            KeyedHiveTable.HiveChangeInternalTable changeTable = new KeyedHiveTable.HiveChangeInternalTable(tableIdentifier, CatalogUtil.useArcticTableOperations((Table)changeIcebergTable, (String)changeLocation, (ArcticFileIO)fileIO, (Configuration)ArcticHiveCatalog.this.tableMetaStore.getConfiguration()), (ArcticFileIO)fileIO, ArcticHiveCatalog.this.client);
            Map metaProperties = meta.properties;
            try {
                ArcticHiveCatalog.this.hiveClientPool.run(client -> {
                    if (this.allowExistedHiveTable) {
                        org.apache.hadoop.hive.metastore.api.Table hiveTable = client.getTable(tableIdentifier.getDatabase(), tableIdentifier.getTableName());
                        Map hiveParameters = hiveTable.getParameters();
                        hiveParameters.putAll(this.constructProperties());
                        hiveTable.setParameters(hiveParameters);
                        client.alterTable(tableIdentifier.getDatabase(), tableIdentifier.getTableName(), hiveTable);
                    } else {
                        org.apache.hadoop.hive.metastore.api.Table hiveTable = this.newHiveTable(meta);
                        hiveTable.setSd(HiveTableUtil.storageDescriptor(this.schema, this.partitionSpec, hiveLocation, FileFormat.valueOf((String)PropertyUtil.propertyAsString((Map)metaProperties, (String)"write.format.default", (String)"parquet").toUpperCase(Locale.ENGLISH))));
                        this.setProToHive(hiveTable);
                        client.createTable(hiveTable);
                    }
                    return null;
                });
            }
            catch (InterruptedException | TException e) {
                throw new RuntimeException("Failed to create hive table:" + meta.getTableIdentifier(), e);
            }
            return new KeyedHiveTable(meta, tableLocation, this.primaryKeySpec, ArcticHiveCatalog.this.client, ArcticHiveCatalog.this.hiveClientPool, baseTable, changeTable);
        }

        protected UnkeyedHiveTable createUnKeyedTable(TableMeta meta) {
            TableIdentifier tableIdentifier = TableIdentifier.of((com.netease.arctic.ams.api.TableIdentifier)meta.getTableIdentifier());
            String baseLocation = ArcticHiveCatalog.this.checkLocation(meta, "base");
            String tableLocation = ArcticHiveCatalog.this.checkLocation(meta, "table");
            this.fillTableProperties(meta);
            String hiveLocation = (String)meta.getProperties().get("base.hive.location-root");
            Table table = (Table)ArcticHiveCatalog.this.tableMetaStore.doAs(() -> {
                try {
                    Table createTable = ArcticHiveCatalog.this.tables.create(this.schema, this.partitionSpec, meta.getProperties(), baseLocation);
                    createTable.updateProperties().set("schema.name-mapping.default", NameMappingParser.toJson((NameMapping)MappingUtil.create((Schema)createTable.schema()))).commit();
                    return createTable;
                }
                catch (Exception e) {
                    throw new IllegalStateException("create table failed", e);
                }
            });
            try {
                ArcticHiveCatalog.this.hiveClientPool.run(client -> {
                    if (this.allowExistedHiveTable) {
                        org.apache.hadoop.hive.metastore.api.Table hiveTable = client.getTable(tableIdentifier.getDatabase(), tableIdentifier.getTableName());
                        Map hiveParameters = hiveTable.getParameters();
                        hiveParameters.putAll(this.constructProperties());
                        hiveTable.setParameters(hiveParameters);
                        client.alterTable(tableIdentifier.getDatabase(), tableIdentifier.getTableName(), hiveTable);
                    } else {
                        org.apache.hadoop.hive.metastore.api.Table hiveTable = this.newHiveTable(meta);
                        hiveTable.setSd(HiveTableUtil.storageDescriptor(this.schema, this.partitionSpec, hiveLocation, FileFormat.valueOf((String)PropertyUtil.propertyAsString((Map)this.properties, (String)"base.write.format", (String)"parquet").toUpperCase(Locale.ENGLISH))));
                        this.setProToHive(hiveTable);
                        client.createTable(hiveTable);
                    }
                    return null;
                });
            }
            catch (InterruptedException | TException e) {
                throw new RuntimeException("Failed to create hive table:" + meta.getTableIdentifier(), e);
            }
            ArcticHadoopFileIO fileIO = new ArcticHadoopFileIO(ArcticHiveCatalog.this.tableMetaStore);
            return new UnkeyedHiveTable(tableIdentifier, CatalogUtil.useArcticTableOperations((Table)table, (String)baseLocation, (ArcticFileIO)fileIO, (Configuration)ArcticHiveCatalog.this.tableMetaStore.getConfiguration()), (ArcticFileIO)fileIO, tableLocation, ArcticHiveCatalog.this.client, ArcticHiveCatalog.this.hiveClientPool);
        }

        private org.apache.hadoop.hive.metastore.api.Table newHiveTable(TableMeta meta) {
            long currentTimeMillis = System.currentTimeMillis();
            org.apache.hadoop.hive.metastore.api.Table newTable = new org.apache.hadoop.hive.metastore.api.Table(meta.getTableIdentifier().getTableName(), meta.getTableIdentifier().getDatabase(), meta.getProperties().getOrDefault("owner", System.getProperty("user.name")), (int)currentTimeMillis / 1000, (int)currentTimeMillis / 1000, Integer.MAX_VALUE, null, HiveSchemaUtil.hivePartitionFields(this.schema, this.partitionSpec), new HashMap(), null, null, TableType.EXTERNAL_TABLE.toString());
            newTable.getParameters().put("EXTERNAL", "TRUE");
            return newTable;
        }

        protected void fillTableProperties(TableMeta meta) {
            super.fillTableProperties(meta);
            String tableLocation = ArcticHiveCatalog.this.checkLocation(meta, "table");
            String hiveLocation = HiveTableUtil.hiveRootLocation(tableLocation);
            meta.putToProperties("base.hive.location-root", hiveLocation);
        }

        protected String getDatabaseLocation() {
            try {
                return (String)ArcticHiveCatalog.this.hiveClientPool.run(client -> client.getDatabase(this.identifier.getDatabase()).getLocationUri());
            }
            catch (InterruptedException | TException e) {
                throw new RuntimeException("Failed to get database location:" + this.identifier.getDatabase(), e);
            }
        }

        protected void doRollbackCreateTable(TableMeta meta) {
            super.doRollbackCreateTable(meta);
            if (this.allowExistedHiveTable) {
                LOG.info("No need to drop hive table");
                com.netease.arctic.ams.api.TableIdentifier tableIdentifier = meta.getTableIdentifier();
                try {
                    ArcticHiveCatalog.this.hiveClientPool.run(client -> {
                        org.apache.hadoop.hive.metastore.api.Table hiveTable = client.getTable(tableIdentifier.getDatabase(), tableIdentifier.getTableName());
                        Map hiveParameters = hiveTable.getParameters();
                        hiveParameters.remove("arctic.enabled");
                        client.alterTable(tableIdentifier.getDatabase(), tableIdentifier.getTableName(), hiveTable);
                        return null;
                    });
                }
                catch (InterruptedException | TException e) {
                    LOG.warn("Failed to alter hive table while rolling back create table operation", e);
                }
            } else {
                try {
                    ArcticHiveCatalog.this.hiveClientPool.run(client -> {
                        client.dropTable(meta.getTableIdentifier().getDatabase(), meta.getTableIdentifier().getTableName(), true, true);
                        return null;
                    });
                }
                catch (InterruptedException | TException e) {
                    LOG.warn("Failed to drop hive table while rolling back create table operation", e);
                }
            }
        }

        private void setProToHive(org.apache.hadoop.hive.metastore.api.Table hiveTable) {
            Map<String, String> parameters = this.constructProperties();
            hiveTable.setParameters(parameters);
        }

        private Map<String, String> constructProperties() {
            HashMap<String, String> parameters = new HashMap<String, String>();
            parameters.put("arctic.enabled", "true");
            parameters.put("arctic.table.primary-keys", this.primaryKeySpec.description());
            return parameters;
        }
    }
}

