/*
 * Decompiled with CFR 0.152.
 */
package com.mzlion.core.utils;

import com.mzlion.core.exceptions.PropertyResolverException;
import com.mzlion.core.io.resource.DefaultResourceDescriptorLoader;
import com.mzlion.core.io.resource.ResourceDescriptor;
import com.mzlion.core.json.gson.JsonUtil;
import com.mzlion.core.lang.ArrayUtils;
import com.mzlion.core.lang.StringUtils;
import com.mzlion.core.utils.PropertyResolver;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlaceholderPropertyResolver
implements PropertyResolver {
    private Logger logger = LoggerFactory.getLogger(PlaceholderPropertyResolver.class);
    private static final String PLACEHOLDER_PREFIX = "${";
    private Map<String, String> propertyStringValue;

    private PlaceholderPropertyResolver(Builder builder) {
        List pathEntries = builder.pathEntries;
        this.processFile(pathEntries);
    }

    private void processFile(List<String> pathEntries) {
        Properties properties;
        int i;
        ResourceDescriptor resourceDescriptor;
        this.logger.debug(" ===> \u5904\u7406\u5c5e\u6027\u6587\u4ef6->{}", pathEntries);
        ArrayList<ResourceDescriptor> fileList = new ArrayList<ResourceDescriptor>(pathEntries.size());
        DefaultResourceDescriptorLoader defaultResourceDescriptorLoader = new DefaultResourceDescriptorLoader();
        for (String pathEntry : pathEntries) {
            resourceDescriptor = defaultResourceDescriptorLoader.getResourceDescriptor(pathEntry);
            fileList.add(resourceDescriptor);
        }
        this.logger.debug(" ===> \u89e3\u6790properties\u6587\u4ef6");
        int size = fileList.size();
        ArrayList<Properties> propertiesList = new ArrayList<Properties>(size);
        int count = 0;
        for (i = 0; i < size; ++i) {
            resourceDescriptor = (ResourceDescriptor)fileList.get(i);
            try {
                InputStream in = resourceDescriptor.getInputStream();
                Object object = null;
                try {
                    properties = new Properties();
                    properties.load(in);
                    propertiesList.add(properties);
                    count += properties.size();
                    continue;
                }
                catch (Throwable throwable) {
                    object = throwable;
                    throw throwable;
                }
                finally {
                    if (in != null) {
                        if (object != null) {
                            try {
                                in.close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)object).addSuppressed(throwable);
                            }
                        } else {
                            in.close();
                        }
                    }
                }
            }
            catch (IOException e) {
                throw new PropertyResolverException(e);
            }
        }
        this.logger.debug("\u53d6\u51fa\u5176\u4e2d\u7684key=value");
        HashMap<String, String> stringValueMap = new HashMap<String, String>(count);
        size = propertiesList.size();
        for (i = 0; i < size; ++i) {
            properties = (Properties)propertiesList.get(i);
            for (Object e : properties.keySet()) {
                stringValueMap.put((String)e, properties.getProperty((String)e));
            }
        }
        this.logger.debug("\u89e3\u6790\u5360\u4f4d\u7b26->{}", stringValueMap);
        this.propertyStringValue = new HashMap<String, String>(stringValueMap.size());
        for (Map.Entry entry : stringValueMap.entrySet()) {
            String key = (String)entry.getKey();
            String string = (String)entry.getValue();
            this.propertyStringValue.put(key, this.replacePlaceholders(string, stringValueMap));
        }
        this.logger.debug("\u5904\u7406\u5c5e\u6027\u6587\u4ef6\u6210\u529f");
    }

    private String replacePlaceholders(String value, Map<String, String> stringValueMap) {
        this.logger.debug("\u66ff\u6362\u5360\u4f4d\u7b26\u65b9\u6cd5\u88ab\u8c03\u7528->value={}", (Object)value);
        if (!value.contains(PLACEHOLDER_PREFIX)) {
            this.logger.debug("Value[{}]\u4e0d\u5b58\u5728\u5360\u4f4d\u7b26\u6807\u8bb0", (Object)value);
            return value;
        }
        StringBuilder buffer = new StringBuilder();
        char[] chars = value.toCharArray();
        int length = chars.length;
        for (int pos = 0; pos < length; ++pos) {
            if (chars[pos] == '$' && chars[pos + 1] == '{') {
                int x;
                StringBuilder placeholder = new StringBuilder(100);
                for (x = pos + 2; x < length && chars[x] != '}'; ++x) {
                    placeholder.append(chars[x]);
                    if (x != length - 1) continue;
                    return value;
                }
                String extractValue = stringValueMap.get(placeholder.toString());
                if (StringUtils.isEmpty(extractValue)) {
                    extractValue = this.extractFromSystem(placeholder.toString());
                }
                this.logger.debug("\u5360\u4f4d\u7b26[{}]\u5bf9\u5e94\u7684\u503c\u4e3a[{}}", (Object)placeholder.toString(), (Object)extractValue);
                buffer.append(extractValue == null ? "" : extractValue);
                pos = x + 1;
                if (pos >= chars.length) break;
            }
            buffer.append(chars[pos]);
        }
        return this.replacePlaceholders(buffer.toString(), stringValueMap);
    }

    private String extractFromSystem(String key) {
        return System.getProperty(key);
    }

    @Override
    public boolean containsProperty(String key) {
        return StringUtils.hasLength(key) && this.propertyStringValue.get(key) != null;
    }

    @Override
    public Map<String, String> getAllProperties() {
        return new HashMap<String, String>(this.propertyStringValue);
    }

    @Override
    public String getProperty(String key) {
        return this.getProperty(key, (String)null);
    }

    @Override
    public String getProperty(String key, String defaultValue) {
        if (StringUtils.isEmpty(key)) {
            return defaultValue;
        }
        String value = this.propertyStringValue.get(key);
        return StringUtils.isEmpty(value) ? defaultValue : value;
    }

    @Override
    public <T> T getProperty(String key, Class<T> targetType) {
        return this.getProperty(key, targetType, null);
    }

    @Override
    public <T> T getProperty(String key, Class<T> targetType, T defaultValue) {
        if (StringUtils.isEmpty(key)) {
            return defaultValue;
        }
        String value = this.propertyStringValue.get(key);
        if (StringUtils.isEmpty(value)) {
            return defaultValue;
        }
        if (targetType == String.class) {
            return (T)value;
        }
        if (targetType == Integer.TYPE) {
            return (T)new Integer(value);
        }
        if (targetType == Integer.class) {
            return (T)new Integer(value);
        }
        if (targetType == Short.class) {
            return (T)new Short(value);
        }
        if (targetType == Short.TYPE) {
            return (T)Short.valueOf(value);
        }
        if (targetType == Byte.class) {
            return (T)new Byte(value);
        }
        if (targetType == Byte.TYPE) {
            return (T)new Byte(value);
        }
        if (targetType == Character.class) {
            return (T)new Character(value.toCharArray()[0]);
        }
        if (targetType == Character.TYPE) {
            return (T)new Character(value.toCharArray()[0]);
        }
        if (targetType == Long.class) {
            return (T)new Long(value);
        }
        if (targetType == Long.TYPE) {
            return (T)new Long(value);
        }
        if (targetType == Float.class) {
            return (T)new Float(value);
        }
        if (targetType == Float.TYPE) {
            return (T)new Float(value);
        }
        if (targetType == Long.class) {
            return (T)new Long(value);
        }
        if (targetType == Long.TYPE) {
            return (T)new Long(value);
        }
        if (targetType == Double.class) {
            return (T)new Double(value);
        }
        if (targetType == Double.TYPE) {
            return (T)new Double(value);
        }
        if (targetType == Boolean.class) {
            return (T)Boolean.valueOf(value);
        }
        if (targetType == Boolean.TYPE) {
            return (T)Boolean.valueOf(value);
        }
        if (targetType == BigDecimal.class) {
            return (T)new BigDecimal(value);
        }
        return JsonUtil.fromJson(value, targetType);
    }

    @Override
    public String resolvePlaceholders(String text) {
        if (StringUtils.isEmpty(text)) {
            return null;
        }
        return this.replacePlaceholders(text, this.propertyStringValue);
    }

    public static class Builder {
        private List<String> pathEntries = new ArrayList<String>(10);

        public Builder path(String path) {
            if (StringUtils.hasLength(path)) {
                this.pathEntries.add(path);
            }
            return this;
        }

        public Builder pathList(String ... pathEntries) {
            if (ArrayUtils.isNotEmpty(pathEntries)) {
                for (String pathEntry : pathEntries) {
                    this.path(pathEntry);
                }
            }
            return this;
        }

        public PlaceholderPropertyResolver build() {
            return new PlaceholderPropertyResolver(this);
        }
    }
}

