/*
 * Decompiled with CFR 0.152.
 */
package com.mzlion.core.io.resource;

import com.mzlion.core.io.resource.AbstractResourceDescriptor;
import com.mzlion.core.lang.Assert;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;

public class URLResourceDescriptor
extends AbstractResourceDescriptor {
    private final URL url;

    public URLResourceDescriptor(URL url) {
        Assert.notNull(url, "URL must not be null");
        this.url = url;
    }

    public URLResourceDescriptor(String path) throws MalformedURLException {
        Assert.hasLength(path, "Path must not be null");
        this.url = new URL(path);
    }

    @Override
    public InputStream getInputStream() {
        URLConnection con = null;
        try {
            con = this.url.openConnection();
            return con.getInputStream();
        }
        catch (IOException e) {
            e.printStackTrace();
            if (con instanceof HttpURLConnection) {
                ((HttpURLConnection)con).disconnect();
            }
            return null;
        }
    }

    @Override
    public URL getURL() throws IOException {
        return this.url;
    }

    @Override
    public String getDescription() {
        return "URL [" + this.url + "]";
    }
}

