/*
 * Decompiled with CFR 0.152.
 */
package com.mzlion.core.binary;

import com.mzlion.core.lang.Assert;
import com.mzlion.core.lang.StringUtils;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import javax.xml.bind.DatatypeConverter;

public class Base64 {
    private Base64() {
        throw new UnsupportedOperationException();
    }

    public static String encode(byte[] data) {
        return DatatypeConverter.printBase64Binary((byte[])data);
    }

    public static String encode(String data) {
        return Base64.encode(data, null);
    }

    public static String encode(String data, String encoding) {
        if (StringUtils.isEmpty(data)) {
            return data;
        }
        Charset charset = StringUtils.isEmpty(encoding) ? StandardCharsets.UTF_8 : Charset.forName(encoding);
        return DatatypeConverter.printBase64Binary((byte[])data.getBytes(charset));
    }

    public static byte[] decode(String base64Data) {
        Assert.hasLength(base64Data, "The Base64 data is null.");
        return DatatypeConverter.parseBase64Binary((String)base64Data);
    }

    public static String decode2String(String base64Data) {
        return Base64.decode2String(base64Data, null);
    }

    public static String decode2String(String base64Data, String encoding) {
        if (StringUtils.isEmpty(base64Data)) {
            return base64Data;
        }
        Charset charset = StringUtils.isEmpty(encoding) ? StandardCharsets.UTF_8 : Charset.forName(encoding);
        byte[] data = Base64.decode(base64Data);
        return new String(data, charset);
    }
}

