/*
 * Decompiled with CFR 0.152.
 */
package com.mybatisflex.core.query;

import com.mybatisflex.core.dialect.IDialect;
import com.mybatisflex.core.exception.FlexExceptions;
import com.mybatisflex.core.query.Brackets;
import com.mybatisflex.core.query.CloneSupport;
import com.mybatisflex.core.query.QueryColumn;
import com.mybatisflex.core.query.QueryTable;
import com.mybatisflex.core.query.QueryWrapper;
import com.mybatisflex.core.query.RawFragment;
import com.mybatisflex.core.query.SqlConnector;
import com.mybatisflex.core.util.ClassUtil;
import com.mybatisflex.core.util.ObjectUtil;
import java.lang.reflect.Array;
import java.util.List;
import java.util.function.Predicate;
import java.util.function.Supplier;

public class QueryCondition
implements CloneSupport<QueryCondition> {
    protected QueryColumn column;
    protected String logic;
    protected Object value;
    protected boolean effective = true;
    protected QueryCondition prev;
    protected QueryCondition next;
    protected SqlConnector connector;

    public static QueryCondition createEmpty() {
        return new QueryCondition().when(false);
    }

    public static QueryCondition create(String schema, String table, String column, String logic, Object value) {
        QueryCondition condition = new QueryCondition();
        condition.setColumn(new QueryColumn(schema, table, column));
        condition.setLogic(logic);
        condition.setValue(value);
        return condition;
    }

    public static QueryCondition create(QueryColumn queryColumn, Object value) {
        return QueryCondition.create(queryColumn, " = ", value);
    }

    public static QueryCondition create(QueryColumn queryColumn, String logic, Object value) {
        QueryCondition condition = new QueryCondition();
        condition.setColumn(queryColumn);
        condition.setLogic(logic);
        condition.setValue(value);
        return condition;
    }

    public QueryColumn getColumn() {
        return this.column;
    }

    public void setColumn(QueryColumn column) {
        this.column = column;
    }

    public Object getValue() {
        return this.checkEffective() ? this.value : null;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public String getLogic() {
        return this.logic;
    }

    public void setLogic(String logic) {
        this.logic = logic;
    }

    public QueryCondition when(boolean effective) {
        this.effective = effective;
        return this;
    }

    public void when(Supplier<Boolean> fn) {
        Boolean effective = fn.get();
        this.effective = effective != null && effective != false;
    }

    public <T> QueryCondition when(Predicate<T> fn) {
        Object val = this.value;
        if (" LIKE ".equals(this.logic) && val instanceof String) {
            String valStr = (String)val;
            if (valStr.startsWith("%")) {
                valStr = valStr.substring(1);
            }
            if (valStr.endsWith("%")) {
                valStr = valStr.substring(0, valStr.length() - 1);
            }
            val = valStr;
        }
        this.effective = fn.test(val);
        return this;
    }

    public boolean checkEffective() {
        return this.effective;
    }

    public QueryCondition and(String sql) {
        return this.and(new RawFragment(sql));
    }

    public QueryCondition and(String sql, Object ... params) {
        return this.and(new RawFragment(sql, params));
    }

    public QueryCondition and(QueryCondition nextCondition) {
        return new Brackets(this).and(nextCondition);
    }

    public QueryCondition or(String sql) {
        return this.or(new RawFragment(sql));
    }

    public QueryCondition or(String sql, Object ... params) {
        return this.or(new RawFragment(sql, params));
    }

    public QueryCondition or(QueryCondition nextCondition) {
        return new Brackets(this).or(nextCondition);
    }

    protected void connect(QueryCondition nextCondition, SqlConnector connector) {
        if (this.next != null) {
            this.next.connect(nextCondition, connector);
        } else {
            this.next = nextCondition;
            this.connector = connector;
            nextCondition.prev = this;
        }
    }

    public String toSql(List<QueryTable> queryTables, IDialect dialect) {
        StringBuilder sql = new StringBuilder();
        if (this.checkEffective()) {
            QueryCondition prevEffectiveCondition = this.getPrevEffectiveCondition();
            if (prevEffectiveCondition != null) {
                sql.append((Object)prevEffectiveCondition.connector);
            }
            sql.append(this.getColumn().toConditionSql(queryTables, dialect));
            sql.append(this.logic);
            if (this.value instanceof QueryColumn) {
                sql.append(((QueryColumn)this.value).toConditionSql(queryTables, dialect));
            } else if (this.value instanceof QueryWrapper) {
                sql.append("(").append(dialect.buildSelectSql((QueryWrapper)this.value)).append(")");
            } else if (this.value instanceof RawFragment) {
                sql.append(((RawFragment)this.value).getContent());
            } else {
                this.appendQuestionMark(sql);
            }
        }
        if (this.next != null) {
            return sql + this.next.toSql(queryTables, dialect);
        }
        return sql.toString();
    }

    protected QueryCondition getPrevEffectiveCondition() {
        if (this.prev == null) {
            return null;
        }
        return this.prev.checkEffective() ? this.prev : this.prev.getPrevEffectiveCondition();
    }

    protected void appendQuestionMark(StringBuilder sqlBuilder) {
        if (!(" IS NULL ".equals(this.logic) || " IS NOT NULL ".equals(this.logic) || this.value instanceof QueryColumn || this.value instanceof QueryWrapper || this.value instanceof RawFragment)) {
            if (" BETWEEN ".equals(this.logic) || " NOT BETWEEN ".equals(this.logic)) {
                sqlBuilder.append(" ? AND ? ");
            } else if (" IN ".equals(this.logic) || " NOT IN ".equals(this.logic)) {
                int paramsCount = this.calculateValueArrayCount();
                sqlBuilder.append("(");
                for (int i = 0; i < paramsCount; ++i) {
                    sqlBuilder.append("?");
                    if (i == paramsCount - 1) continue;
                    sqlBuilder.append(", ");
                }
                sqlBuilder.append(")");
            } else {
                sqlBuilder.append("?");
            }
        }
    }

    private int calculateValueArrayCount() {
        Object[] values = (Object[])this.value;
        int paramsCount = 0;
        for (Object object : values) {
            if (object != null && ClassUtil.isArray(object.getClass())) {
                paramsCount += Array.getLength(object);
                continue;
            }
            ++paramsCount;
        }
        return paramsCount;
    }

    boolean containsTable(String ... tables) {
        if (this.column == null || !this.checkEffective()) {
            return this.nextContainsTable(tables);
        }
        for (String table : tables) {
            if (this.column.table == null || !table.equals(this.column.table.name)) continue;
            return true;
        }
        return this.nextContainsTable(tables);
    }

    private boolean nextContainsTable(String ... tables) {
        if (this.next == null) {
            return false;
        }
        return this.next.containsTable(tables);
    }

    public String toString() {
        return "QueryCondition{column=" + this.column + ", logic='" + this.logic + '\'' + ", value=" + this.value + ", effective=" + this.effective + '}';
    }

    @Override
    public QueryCondition clone() {
        try {
            QueryCondition clone = (QueryCondition)super.clone();
            clone.column = ObjectUtil.clone(this.column);
            clone.value = ObjectUtil.cloneObject(this.value);
            clone.next = null;
            clone.prev = null;
            if (this.next != null) {
                clone.next = this.next.clone();
                clone.next.prev = clone;
            }
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw FlexExceptions.wrap(e);
        }
    }
}

