/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.playwright.impl.junit;

import com.microsoft.playwright.Browser;
import com.microsoft.playwright.BrowserType;
import com.microsoft.playwright.Playwright;
import com.microsoft.playwright.PlaywrightException;
import com.microsoft.playwright.impl.Utils;
import com.microsoft.playwright.impl.junit.DeviceDescriptor;
import com.microsoft.playwright.impl.junit.ExtensionUtils;
import com.microsoft.playwright.impl.junit.OptionsExtension;
import com.microsoft.playwright.impl.junit.PlaywrightExtension;
import com.microsoft.playwright.junit.Options;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.ParameterResolver;

public class BrowserExtension
implements ParameterResolver,
AfterAllCallback {
    private static final ThreadLocal<Browser> threadLocalBrowser = new ThreadLocal();

    public void afterAll(ExtensionContext extensionContext) {
        Browser browser = threadLocalBrowser.get();
        threadLocalBrowser.remove();
        if (browser != null) {
            browser.close();
        }
    }

    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        return ExtensionUtils.isParameterSupported(parameterContext, extensionContext, Browser.class);
    }

    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        return BrowserExtension.getOrCreateBrowser(extensionContext);
    }

    public static Browser getOrCreateBrowser(ExtensionContext extensionContext) {
        DeviceDescriptor deviceDescriptor;
        Browser browser = threadLocalBrowser.get();
        if (browser != null) {
            return browser;
        }
        Options options = OptionsExtension.getOptions(extensionContext);
        Playwright playwright = PlaywrightExtension.getOrCreatePlaywright(extensionContext);
        BrowserType browserType = playwright.chromium();
        if (options.browserName != null) {
            browserType = BrowserExtension.getBrowserTypeForName(playwright, options.browserName);
        } else if (options.deviceName != null && (deviceDescriptor = DeviceDescriptor.findByName(playwright, options.deviceName)) != null && deviceDescriptor.defaultBrowserType != null) {
            browserType = BrowserExtension.getBrowserTypeForName(playwright, deviceDescriptor.defaultBrowserType);
        }
        if (options.wsEndpoint != null && !options.wsEndpoint.isEmpty()) {
            BrowserType.ConnectOptions connectOptions = BrowserExtension.getConnectOptions(options);
            browser = browserType.connect(options.wsEndpoint, connectOptions);
        } else {
            BrowserType.LaunchOptions launchOptions = BrowserExtension.getLaunchOptions(options);
            browser = browserType.launch(launchOptions);
        }
        threadLocalBrowser.set(browser);
        return browser;
    }

    static Browser getBrowser() {
        return threadLocalBrowser.get();
    }

    private static BrowserType.ConnectOptions getConnectOptions(Options options) {
        BrowserType.ConnectOptions connectOptions = options.connectOptions;
        if (connectOptions == null) {
            connectOptions = new BrowserType.ConnectOptions();
        }
        return connectOptions;
    }

    private static BrowserType getBrowserTypeForName(Playwright playwright, String name) {
        switch (name) {
            case "webkit": {
                return playwright.webkit();
            }
            case "firefox": {
                return playwright.firefox();
            }
            case "chromium": {
                return playwright.chromium();
            }
        }
        throw new PlaywrightException("Invalid browser name.");
    }

    private static BrowserType.LaunchOptions getLaunchOptions(Options options) {
        BrowserType.LaunchOptions launchOptions = Utils.clone(options.launchOptions);
        if (launchOptions == null) {
            launchOptions = new BrowserType.LaunchOptions();
        }
        if (options.headless != null) {
            launchOptions.setHeadless(options.headless);
        }
        if (options.channel != null) {
            launchOptions.setChannel(options.channel);
        }
        return launchOptions;
    }
}

