/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.playwright.impl;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.microsoft.playwright.impl.ChannelOwner;
import com.microsoft.playwright.impl.Logger;
import com.microsoft.playwright.impl.LoggingSupport;
import com.microsoft.playwright.impl.Utils;
import java.util.function.Function;
import java.util.function.Supplier;

public class WaitForEventLogger<T>
implements Supplier<T>,
Logger {
    private final Function<Logger, T> supplier;
    private final ChannelOwner channel;
    private final String waitId;
    private final String apiName;

    WaitForEventLogger(ChannelOwner channelOwner, String apiName, Function<Logger, T> supplier) {
        this.supplier = supplier;
        this.channel = channelOwner;
        this.apiName = apiName;
        this.waitId = Utils.createGuid();
    }

    @Override
    public T get() {
        JsonObject info = new JsonObject();
        info.addProperty("phase", "before");
        this.sendWaitForEventInfo(info);
        info = new JsonObject();
        info.addProperty("phase", "after");
        try {
            T t = this.supplier.apply(this);
            return t;
        }
        catch (RuntimeException e) {
            info.addProperty("error", e.getMessage());
            throw e;
        }
        finally {
            this.sendWaitForEventInfo(info);
        }
    }

    @Override
    public void log(String message) {
        LoggingSupport.logApiIfEnabled(message);
        JsonObject info = new JsonObject();
        info.addProperty("phase", "log");
        info.addProperty("message", message);
        this.sendWaitForEventInfo(info);
    }

    private void sendWaitForEventInfo(JsonObject info) {
        info.addProperty("event", "");
        info.addProperty("waitId", this.waitId);
        JsonObject params = new JsonObject();
        params.add("info", (JsonElement)info);
        this.channel.sendMessageAsync("waitForEventInfo", params);
    }
}

