/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.playwright.impl;

import com.microsoft.playwright.PlaywrightException;
import com.microsoft.playwright.impl.LocalUtils;
import com.microsoft.playwright.impl.Utils;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.function.Predicate;
import java.util.regex.Pattern;

class UrlMatcher {
    public final String glob;
    public final Pattern pattern;
    public final Predicate<String> predicate;

    static UrlMatcher forOneOf(URL baseUrl, Object object, LocalUtils localUtils, boolean isWebSocketUrl) {
        if (object == null) {
            return new UrlMatcher(null, null, null);
        }
        if (object instanceof String) {
            return UrlMatcher.forGlob(baseUrl, (String)object, localUtils, isWebSocketUrl);
        }
        if (object instanceof Pattern) {
            return new UrlMatcher((Pattern)object);
        }
        if (object instanceof Predicate) {
            return new UrlMatcher((Predicate)object);
        }
        throw new PlaywrightException("Url must be String, Pattern or Predicate<String>, found: " + object.getClass().getTypeName());
    }

    static String resolveUrl(URL baseUrl, String spec) {
        return UrlMatcher.resolveUrl(baseUrl.toString(), spec);
    }

    private static String resolveUrl(String baseUrl, String spec) {
        if (baseUrl == null) {
            return spec;
        }
        try {
            return new URI(baseUrl).resolve(spec).toString();
        }
        catch (URISyntaxException e) {
            return spec;
        }
    }

    static UrlMatcher forGlob(URL baseURL, String glob, LocalUtils localUtils, boolean isWebSocketUrl) {
        Pattern pattern = localUtils.globToRegex(glob, baseURL != null ? baseURL.toString() : null, isWebSocketUrl);
        return new UrlMatcher(glob, pattern, null);
    }

    UrlMatcher(Pattern pattern) {
        this(null, pattern, null);
    }

    UrlMatcher(Predicate<String> predicate) {
        this(null, null, predicate);
    }

    private UrlMatcher(String glob, Pattern pattern, Predicate<String> predicate) {
        this.glob = glob;
        this.pattern = pattern;
        this.predicate = predicate;
    }

    boolean test(String value) {
        if (this.pattern != null) {
            return this.pattern.matcher(value).find();
        }
        if (this.predicate != null) {
            return this.predicate.test(value);
        }
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UrlMatcher that = (UrlMatcher)o;
        if (this.pattern != null) {
            return that.pattern != null && this.pattern.pattern().equals(that.pattern.pattern()) && this.pattern.flags() == that.pattern.flags();
        }
        if (this.predicate != null) {
            return this.predicate.equals(that.predicate);
        }
        if (this.glob != null) {
            return this.glob.equals(that.glob);
        }
        return that.pattern == null && that.predicate == null && that.glob == null;
    }

    public int hashCode() {
        if (this.pattern != null) {
            return this.pattern.hashCode();
        }
        if (this.predicate != null) {
            return this.predicate.hashCode();
        }
        if (this.glob != null) {
            return this.glob.hashCode();
        }
        return 0;
    }

    public String toString() {
        if (this.glob != null) {
            return String.format("<glob pattern=\"%s\">", this.glob);
        }
        if (this.pattern != null) {
            return String.format("<regex pattern=\"%s\" flags=\"%s\">", this.pattern.pattern(), Utils.toJsRegexFlags(this.pattern));
        }
        if (this.predicate != null) {
            return "<predicate>";
        }
        return "<true>";
    }
}

