/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.playwright.impl;

import com.google.gson.JsonObject;
import com.microsoft.playwright.Mouse;
import com.microsoft.playwright.impl.ChannelOwner;
import com.microsoft.playwright.impl.Serialization;
import com.microsoft.playwright.impl.Utils;

class MouseImpl
implements Mouse {
    private final ChannelOwner page;

    MouseImpl(ChannelOwner page) {
        this.page = page;
    }

    @Override
    public void click(double x, double y, Mouse.ClickOptions options) {
        if (options == null) {
            options = new Mouse.ClickOptions();
        }
        JsonObject params = Serialization.gson().toJsonTree((Object)options).getAsJsonObject();
        params.addProperty("x", (Number)x);
        params.addProperty("y", (Number)y);
        this.page.sendMessage("mouseClick", params, ChannelOwner.NO_TIMEOUT);
    }

    @Override
    public void dblclick(double x, double y, Mouse.DblclickOptions options) {
        this.page.withTitle("Double click", () -> this.dblclickImpl(x, y, options));
    }

    private void dblclickImpl(double x, double y, Mouse.DblclickOptions options) {
        Mouse.ClickOptions clickOptions = options == null ? new Mouse.ClickOptions() : Utils.convertType(options, Mouse.ClickOptions.class);
        clickOptions.clickCount = 2;
        this.click(x, y, clickOptions);
    }

    @Override
    public void down(Mouse.DownOptions options) {
        if (options == null) {
            options = new Mouse.DownOptions();
        }
        JsonObject params = Serialization.gson().toJsonTree((Object)options).getAsJsonObject();
        this.page.sendMessage("mouseDown", params, ChannelOwner.NO_TIMEOUT);
    }

    @Override
    public void move(double x, double y, Mouse.MoveOptions options) {
        if (options == null) {
            options = new Mouse.MoveOptions();
        }
        JsonObject params = Serialization.gson().toJsonTree((Object)options).getAsJsonObject();
        params.addProperty("x", (Number)x);
        params.addProperty("y", (Number)y);
        this.page.sendMessage("mouseMove", params, ChannelOwner.NO_TIMEOUT);
    }

    @Override
    public void up(Mouse.UpOptions options) {
        if (options == null) {
            options = new Mouse.UpOptions();
        }
        JsonObject params = Serialization.gson().toJsonTree((Object)options).getAsJsonObject();
        this.page.sendMessage("mouseUp", params, ChannelOwner.NO_TIMEOUT);
    }

    @Override
    public void wheel(double deltaX, double deltaY) {
        JsonObject params = new JsonObject();
        params.addProperty("deltaX", (Number)deltaX);
        params.addProperty("deltaY", (Number)deltaY);
        this.page.sendMessage("mouseWheel", params, ChannelOwner.NO_TIMEOUT);
    }
}

