/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.playwright.impl;

import com.google.gson.JsonObject;
import com.microsoft.playwright.Keyboard;
import com.microsoft.playwright.impl.ChannelOwner;
import com.microsoft.playwright.impl.Serialization;

class KeyboardImpl
implements Keyboard {
    private final ChannelOwner page;

    KeyboardImpl(ChannelOwner page) {
        this.page = page;
    }

    @Override
    public void down(String key) {
        JsonObject params = new JsonObject();
        params.addProperty("key", key);
        this.page.sendMessage("keyboardDown", params, ChannelOwner.NO_TIMEOUT);
    }

    @Override
    public void insertText(String text) {
        JsonObject params = new JsonObject();
        params.addProperty("text", text);
        this.page.sendMessage("keyboardInsertText", params, ChannelOwner.NO_TIMEOUT);
    }

    @Override
    public void press(String key, Keyboard.PressOptions options) {
        this.pressImpl(key, options);
    }

    private void pressImpl(String key, Keyboard.PressOptions options) {
        if (options == null) {
            options = new Keyboard.PressOptions();
        }
        JsonObject params = Serialization.gson().toJsonTree((Object)options).getAsJsonObject();
        params.addProperty("key", key);
        this.page.sendMessage("keyboardPress", params, ChannelOwner.NO_TIMEOUT);
    }

    @Override
    public void type(String text, Keyboard.TypeOptions options) {
        this.typeImpl(text, options);
    }

    private void typeImpl(String text, Keyboard.TypeOptions options) {
        if (options == null) {
            options = new Keyboard.TypeOptions();
        }
        JsonObject params = Serialization.gson().toJsonTree((Object)options).getAsJsonObject();
        params.addProperty("text", text);
        this.page.sendMessage("keyboardType", params, ChannelOwner.NO_TIMEOUT);
    }

    @Override
    public void up(String key) {
        JsonObject params = new JsonObject();
        params.addProperty("key", key);
        this.page.sendMessage("keyboardUp", params, ChannelOwner.NO_TIMEOUT);
    }
}

