/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.playwright.impl;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.microsoft.playwright.ElementHandle;
import com.microsoft.playwright.Frame;
import com.microsoft.playwright.impl.ChannelOwner;
import com.microsoft.playwright.impl.FrameImpl;
import com.microsoft.playwright.impl.JSHandleImpl;
import com.microsoft.playwright.impl.Serialization;
import com.microsoft.playwright.impl.SerializedValue;
import com.microsoft.playwright.impl.Utils;
import com.microsoft.playwright.options.BoundingBox;
import com.microsoft.playwright.options.ElementState;
import com.microsoft.playwright.options.FilePayload;
import com.microsoft.playwright.options.ScreenshotType;
import com.microsoft.playwright.options.SelectOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;

public class ElementHandleImpl
extends JSHandleImpl
implements ElementHandle {
    private final FrameImpl frame;

    ElementHandleImpl(ChannelOwner parent, String type, String guid, JsonObject initializer) {
        super(parent, type, guid, initializer);
        this.frame = (FrameImpl)parent;
    }

    @Override
    public ElementHandle asElement() {
        return this;
    }

    @Override
    public ElementHandle querySelector(String selector) {
        JsonObject params = new JsonObject();
        params.addProperty("selector", selector);
        JsonElement json = this.sendMessage("querySelector", params, NO_TIMEOUT);
        JsonObject element = json.getAsJsonObject().getAsJsonObject("element");
        if (element == null) {
            return null;
        }
        return (ElementHandle)this.connection.getExistingObject(element.get("guid").getAsString());
    }

    @Override
    public List<ElementHandle> querySelectorAll(String selector) {
        JsonObject params = new JsonObject();
        params.addProperty("selector", selector);
        JsonElement json = this.sendMessage("querySelectorAll", params, NO_TIMEOUT);
        JsonArray elements = json.getAsJsonObject().getAsJsonArray("elements");
        if (elements == null) {
            return null;
        }
        ArrayList<ElementHandle> handles = new ArrayList<ElementHandle>();
        for (JsonElement item : elements) {
            handles.add((ElementHandle)this.connection.getExistingObject(item.getAsJsonObject().get("guid").getAsString()));
        }
        return handles;
    }

    @Override
    public Object evalOnSelector(String selector, String pageFunction, Object arg) {
        JsonObject params = new JsonObject();
        params.addProperty("selector", selector);
        params.addProperty("expression", pageFunction);
        params.add("arg", Serialization.gson().toJsonTree((Object)Serialization.serializeArgument(arg)));
        JsonElement json = this.sendMessage("evalOnSelector", params, NO_TIMEOUT);
        SerializedValue value = (SerializedValue)Serialization.gson().fromJson(json.getAsJsonObject().get("value"), SerializedValue.class);
        return Serialization.deserialize(value);
    }

    @Override
    public Object evalOnSelectorAll(String selector, String pageFunction, Object arg) {
        JsonObject params = new JsonObject();
        params.addProperty("selector", selector);
        params.addProperty("expression", pageFunction);
        params.add("arg", Serialization.gson().toJsonTree((Object)Serialization.serializeArgument(arg)));
        JsonElement json = this.sendMessage("evalOnSelectorAll", params, NO_TIMEOUT);
        SerializedValue value = (SerializedValue)Serialization.gson().fromJson(json.getAsJsonObject().get("value"), SerializedValue.class);
        return Serialization.deserialize(value);
    }

    @Override
    public BoundingBox boundingBox() {
        JsonObject json = this.sendMessage("boundingBox").getAsJsonObject();
        if (!json.has("value")) {
            return null;
        }
        return (BoundingBox)Serialization.gson().fromJson(json.get("value"), BoundingBox.class);
    }

    @Override
    public void check(ElementHandle.CheckOptions options) {
        if (options == null) {
            options = new ElementHandle.CheckOptions();
        }
        JsonObject params = Serialization.gson().toJsonTree((Object)options).getAsJsonObject();
        this.sendMessage("check", params, this.frame.timeout(options.timeout));
    }

    @Override
    public void click(ElementHandle.ClickOptions options) {
        if (options == null) {
            options = new ElementHandle.ClickOptions();
        }
        JsonObject params = Serialization.gson().toJsonTree((Object)options).getAsJsonObject();
        this.sendMessage("click", params, this.frame.timeout(options.timeout));
    }

    @Override
    public Frame contentFrame() {
        JsonObject json = this.sendMessage("contentFrame").getAsJsonObject();
        if (!json.has("frame")) {
            return null;
        }
        return (Frame)this.connection.getExistingObject(json.getAsJsonObject("frame").get("guid").getAsString());
    }

    @Override
    public void dblclick(ElementHandle.DblclickOptions options) {
        if (options == null) {
            options = new ElementHandle.DblclickOptions();
        }
        JsonObject params = Serialization.gson().toJsonTree((Object)options).getAsJsonObject();
        this.sendMessage("dblclick", params, this.frame.timeout(options.timeout));
    }

    @Override
    public void dispatchEvent(String type, Object eventInit) {
        JsonObject params = new JsonObject();
        params.addProperty("type", type);
        params.add("eventInit", Serialization.gson().toJsonTree((Object)Serialization.serializeArgument(eventInit)));
        this.sendMessage("dispatchEvent", params, NO_TIMEOUT);
    }

    @Override
    public void fill(String value, ElementHandle.FillOptions options) {
        if (options == null) {
            options = new ElementHandle.FillOptions();
        }
        JsonObject params = Serialization.gson().toJsonTree((Object)options).getAsJsonObject();
        params.addProperty("value", value);
        this.sendMessage("fill", params, this.frame.timeout(options.timeout));
    }

    @Override
    public void focus() {
        this.sendMessage("focus");
    }

    @Override
    public String getAttribute(String name) {
        JsonObject params = new JsonObject();
        params.addProperty("name", name);
        JsonObject json = this.sendMessage("getAttribute", params, NO_TIMEOUT).getAsJsonObject();
        return json.has("value") ? json.get("value").getAsString() : null;
    }

    @Override
    public void hover(ElementHandle.HoverOptions options) {
        if (options == null) {
            options = new ElementHandle.HoverOptions();
        }
        JsonObject params = Serialization.gson().toJsonTree((Object)options).getAsJsonObject();
        this.sendMessage("hover", params, this.frame.timeout(options.timeout));
    }

    @Override
    public String innerHTML() {
        JsonObject json = this.sendMessage("innerHTML").getAsJsonObject();
        return json.get("value").getAsString();
    }

    @Override
    public String innerText() {
        JsonObject json = this.sendMessage("innerText").getAsJsonObject();
        return json.get("value").getAsString();
    }

    @Override
    public String inputValue(ElementHandle.InputValueOptions options) {
        if (options == null) {
            options = new ElementHandle.InputValueOptions();
        }
        JsonObject params = Serialization.gson().toJsonTree((Object)options).getAsJsonObject();
        JsonObject json = this.sendMessage("inputValue", params, NO_TIMEOUT).getAsJsonObject();
        return json.get("value").getAsString();
    }

    @Override
    public boolean isChecked() {
        JsonObject json = this.sendMessage("isChecked").getAsJsonObject();
        return json.get("value").getAsBoolean();
    }

    @Override
    public boolean isDisabled() {
        JsonObject json = this.sendMessage("isDisabled").getAsJsonObject();
        return json.get("value").getAsBoolean();
    }

    @Override
    public boolean isEditable() {
        JsonObject json = this.sendMessage("isEditable").getAsJsonObject();
        return json.get("value").getAsBoolean();
    }

    @Override
    public boolean isEnabled() {
        JsonObject json = this.sendMessage("isEnabled").getAsJsonObject();
        return json.get("value").getAsBoolean();
    }

    @Override
    public boolean isHidden() {
        JsonObject json = this.sendMessage("isHidden").getAsJsonObject();
        return json.get("value").getAsBoolean();
    }

    @Override
    public boolean isVisible() {
        JsonObject json = this.sendMessage("isVisible").getAsJsonObject();
        return json.get("value").getAsBoolean();
    }

    @Override
    public FrameImpl ownerFrame() {
        JsonObject json = this.sendMessage("ownerFrame").getAsJsonObject();
        if (!json.has("frame")) {
            return null;
        }
        return (FrameImpl)this.connection.getExistingObject(json.getAsJsonObject("frame").get("guid").getAsString());
    }

    @Override
    public void press(String key, ElementHandle.PressOptions options) {
        if (options == null) {
            options = new ElementHandle.PressOptions();
        }
        JsonObject params = Serialization.gson().toJsonTree((Object)options).getAsJsonObject();
        params.addProperty("key", key);
        this.sendMessage("press", params, this.frame.timeout(options.timeout));
    }

    @Override
    public byte[] screenshot(ElementHandle.ScreenshotOptions options) {
        if (options == null) {
            options = new ElementHandle.ScreenshotOptions();
        }
        if (options.type == null) {
            String extension;
            String fileName;
            int extStart;
            options.type = ScreenshotType.PNG;
            if (options.path != null && (extStart = (fileName = options.path.getFileName().toString()).lastIndexOf(46)) != -1 && (".jpeg".equals(extension = fileName.substring(extStart).toLowerCase()) || ".jpg".equals(extension))) {
                options.type = ScreenshotType.JPEG;
            }
        }
        JsonObject params = Serialization.gson().toJsonTree((Object)options).getAsJsonObject();
        params.remove("path");
        JsonObject json = this.sendMessage("screenshot", params, this.frame.timeout(options.timeout)).getAsJsonObject();
        byte[] buffer = Base64.getDecoder().decode(json.get("binary").getAsString());
        if (options.path != null) {
            Utils.writeToFile(buffer, options.path);
        }
        return buffer;
    }

    @Override
    public void scrollIntoViewIfNeeded(ElementHandle.ScrollIntoViewIfNeededOptions options) {
        if (options == null) {
            options = new ElementHandle.ScrollIntoViewIfNeededOptions();
        }
        JsonObject params = Serialization.gson().toJsonTree((Object)options).getAsJsonObject();
        this.sendMessage("scrollIntoViewIfNeeded", params, this.frame.timeout(options.timeout));
    }

    @Override
    public List<String> selectOption(String value, ElementHandle.SelectOptionOptions options) {
        String[] stringArray;
        if (value == null) {
            stringArray = null;
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = value;
        }
        String[] values = stringArray;
        return this.selectOption(values, options);
    }

    @Override
    public List<String> selectOption(ElementHandle value, ElementHandle.SelectOptionOptions options) {
        ElementHandle[] elementHandleArray;
        if (value == null) {
            elementHandleArray = null;
        } else {
            ElementHandle[] elementHandleArray2 = new ElementHandle[1];
            elementHandleArray = elementHandleArray2;
            elementHandleArray2[0] = value;
        }
        ElementHandle[] values = elementHandleArray;
        return this.selectOption(values, options);
    }

    @Override
    public List<String> selectOption(String[] values, ElementHandle.SelectOptionOptions options) {
        if (options == null) {
            options = new ElementHandle.SelectOptionOptions();
        }
        JsonObject params = Serialization.gson().toJsonTree((Object)options).getAsJsonObject();
        if (values != null) {
            params.add("options", (JsonElement)Serialization.toSelectValueOrLabel(values));
        }
        return this.selectOption(params, options.timeout);
    }

    @Override
    public List<String> selectOption(SelectOption value, ElementHandle.SelectOptionOptions options) {
        SelectOption[] selectOptionArray;
        if (value == null) {
            selectOptionArray = null;
        } else {
            SelectOption[] selectOptionArray2 = new SelectOption[1];
            selectOptionArray = selectOptionArray2;
            selectOptionArray2[0] = value;
        }
        SelectOption[] values = selectOptionArray;
        return this.selectOption(values, options);
    }

    @Override
    public List<String> selectOption(SelectOption[] values, ElementHandle.SelectOptionOptions options) {
        if (options == null) {
            options = new ElementHandle.SelectOptionOptions();
        }
        JsonObject params = Serialization.gson().toJsonTree((Object)options).getAsJsonObject();
        if (values != null) {
            params.add("options", Serialization.gson().toJsonTree((Object)values));
        }
        return this.selectOption(params, options.timeout);
    }

    @Override
    public List<String> selectOption(ElementHandle[] values, ElementHandle.SelectOptionOptions options) {
        if (options == null) {
            options = new ElementHandle.SelectOptionOptions();
        }
        JsonObject params = Serialization.gson().toJsonTree((Object)options).getAsJsonObject();
        if (values != null) {
            params.add("elements", (JsonElement)Serialization.toProtocol(values));
        }
        return this.selectOption(params, options.timeout);
    }

    private List<String> selectOption(JsonObject params, Double timeout) {
        JsonObject json = this.sendMessage("selectOption", params, this.frame.timeout(timeout)).getAsJsonObject();
        return Serialization.parseStringList(json.getAsJsonArray("values"));
    }

    @Override
    public void selectText(ElementHandle.SelectTextOptions options) {
        if (options == null) {
            options = new ElementHandle.SelectTextOptions();
        }
        JsonObject params = Serialization.gson().toJsonTree((Object)options).getAsJsonObject();
        this.sendMessage("selectText", params, this.frame.timeout(options.timeout));
    }

    @Override
    public void setChecked(boolean checked, ElementHandle.SetCheckedOptions options) {
        if (checked) {
            this.check(Utils.convertType(options, ElementHandle.CheckOptions.class));
        } else {
            this.uncheck(Utils.convertType(options, ElementHandle.UncheckOptions.class));
        }
    }

    @Override
    public void setInputFiles(Path files, ElementHandle.SetInputFilesOptions options) {
        this.setInputFiles(new Path[]{files}, options);
    }

    @Override
    public void setInputFiles(Path[] files, ElementHandle.SetInputFilesOptions options) {
        FrameImpl frame = this.ownerFrame();
        if (frame == null) {
            throw new Error("Cannot set input files to detached element");
        }
        if (options == null) {
            options = new ElementHandle.SetInputFilesOptions();
        }
        JsonObject params = Serialization.gson().toJsonTree((Object)options).getAsJsonObject();
        Utils.addFilePathUploadParams(files, params, frame.page().context());
        this.sendMessage("setInputFiles", params, frame.timeout(options.timeout));
    }

    @Override
    public void setInputFiles(FilePayload files, ElementHandle.SetInputFilesOptions options) {
        this.setInputFiles(new FilePayload[]{files}, options);
    }

    @Override
    public void setInputFiles(FilePayload[] files, ElementHandle.SetInputFilesOptions options) {
        Utils.checkFilePayloadSize(files);
        if (options == null) {
            options = new ElementHandle.SetInputFilesOptions();
        }
        JsonObject params = Serialization.gson().toJsonTree((Object)options).getAsJsonObject();
        params.add("payloads", (JsonElement)Serialization.toJsonArray(files));
        this.sendMessage("setInputFiles", params, this.frame.timeout(options.timeout));
    }

    @Override
    public void tap(ElementHandle.TapOptions options) {
        if (options == null) {
            options = new ElementHandle.TapOptions();
        }
        JsonObject params = Serialization.gson().toJsonTree((Object)options).getAsJsonObject();
        this.sendMessage("tap", params, this.frame.timeout(options.timeout));
    }

    @Override
    public String textContent() {
        JsonObject json = this.sendMessage("textContent").getAsJsonObject();
        return json.has("value") ? json.get("value").getAsString() : null;
    }

    @Override
    public void type(String text, ElementHandle.TypeOptions options) {
        if (options == null) {
            options = new ElementHandle.TypeOptions();
        }
        JsonObject params = Serialization.gson().toJsonTree((Object)options).getAsJsonObject();
        params.addProperty("text", text);
        this.sendMessage("type", params, this.frame.timeout(options.timeout));
    }

    @Override
    public void uncheck(ElementHandle.UncheckOptions options) {
        if (options == null) {
            options = new ElementHandle.UncheckOptions();
        }
        JsonObject params = Serialization.gson().toJsonTree((Object)options).getAsJsonObject();
        this.sendMessage("uncheck", params, this.frame.timeout(options.timeout));
    }

    @Override
    public void waitForElementState(ElementState state, ElementHandle.WaitForElementStateOptions options) {
        if (options == null) {
            options = new ElementHandle.WaitForElementStateOptions();
        }
        if (state == null) {
            throw new IllegalArgumentException("State cannot be null");
        }
        JsonObject params = Serialization.gson().toJsonTree((Object)options).getAsJsonObject();
        params.addProperty("state", ElementHandleImpl.toProtocol(state));
        this.sendMessage("waitForElementState", params, this.frame.timeout(options.timeout));
    }

    private static String toProtocol(ElementState state) {
        return state.toString().toLowerCase();
    }

    @Override
    public ElementHandle waitForSelector(String selector, ElementHandle.WaitForSelectorOptions options) {
        if (options == null) {
            options = new ElementHandle.WaitForSelectorOptions();
        }
        JsonObject params = Serialization.gson().toJsonTree((Object)options).getAsJsonObject();
        params.addProperty("selector", selector);
        JsonObject json = this.sendMessage("waitForSelector", params, this.frame.timeout(options.timeout)).getAsJsonObject();
        JsonObject element = json.getAsJsonObject().getAsJsonObject("element");
        if (element == null) {
            return null;
        }
        return (ElementHandle)this.connection.getExistingObject(element.get("guid").getAsString());
    }
}

