/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.storage.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.management.storage.implementation.PrivateLinkResourceListResultInner;
import com.microsoft.azure.management.storage.implementation.StorageManagementClientImpl;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import java.io.IOException;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.Path;
import retrofit2.http.Query;
import rx.Observable;
import rx.functions.Func1;

public class PrivateLinkResourcesInner {
    private PrivateLinkResourcesService service;
    private StorageManagementClientImpl client;

    public PrivateLinkResourcesInner(Retrofit retrofit, StorageManagementClientImpl client) {
        this.service = (PrivateLinkResourcesService)retrofit.create(PrivateLinkResourcesService.class);
        this.client = client;
    }

    public PrivateLinkResourceListResultInner listByStorageAccount(String resourceGroupName, String accountName) {
        return (PrivateLinkResourceListResultInner)((ServiceResponse)this.listByStorageAccountWithServiceResponseAsync(resourceGroupName, accountName).toBlocking().single()).body();
    }

    public ServiceFuture<PrivateLinkResourceListResultInner> listByStorageAccountAsync(String resourceGroupName, String accountName, ServiceCallback<PrivateLinkResourceListResultInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.listByStorageAccountWithServiceResponseAsync(resourceGroupName, accountName), serviceCallback);
    }

    public Observable<PrivateLinkResourceListResultInner> listByStorageAccountAsync(String resourceGroupName, String accountName) {
        return this.listByStorageAccountWithServiceResponseAsync(resourceGroupName, accountName).map((Func1)new Func1<ServiceResponse<PrivateLinkResourceListResultInner>, PrivateLinkResourceListResultInner>(){

            public PrivateLinkResourceListResultInner call(ServiceResponse<PrivateLinkResourceListResultInner> response) {
                return (PrivateLinkResourceListResultInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<PrivateLinkResourceListResultInner>> listByStorageAccountWithServiceResponseAsync(String resourceGroupName, String accountName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.listByStorageAccount(resourceGroupName, accountName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<PrivateLinkResourceListResultInner>>>(){

            public Observable<ServiceResponse<PrivateLinkResourceListResultInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = PrivateLinkResourcesInner.this.listByStorageAccountDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PrivateLinkResourceListResultInner> listByStorageAccountDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PrivateLinkResourceListResultInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    static interface PrivateLinkResourcesService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.storage.PrivateLinkResources listByStorageAccount"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Storage/storageAccounts/{accountName}/privateLinkResources")
        public Observable<Response<ResponseBody>> listByStorageAccount(@Path(value="resourceGroupName") String var1, @Path(value="accountName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);
    }
}

