package com.libawall.util.httpclient;

import org.apache.http.HttpStatus;
import org.apache.http.HttpVersion;
import org.apache.http.StatusLine;
import org.apache.http.client.CookieStore;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.cookie.ClientCookie;
import org.apache.http.entity.ContentType;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.cookie.BasicClientCookie;
import org.apache.http.message.BasicStatusLine;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;

/**
 * @author shichao
 */
public class HttpResult {

    private static final Charset DEFAULT_CHARSET = StandardCharsets.UTF_8;

    private CookieStore cookieStore = new BasicCookieStore();

    private HttpClientContext httpClientContext;

    private Map<String, String> headers = new HashMap<String, String>();

    private StatusLine statusLine;

    private byte[] bytes;

    private String context;

    private String errMsg;

    private Charset charset = DEFAULT_CHARSET;

    public HttpResult(String errMsg) {
        this.errMsg = errMsg;
        this.statusLine = new BasicStatusLine(HttpVersion.HTTP_1_1, HttpStatus.SC_NOT_FOUND, null);
    }

    public HttpResult(byte[] bytes) {
        this.bytes = bytes;
    }

    public HttpResult(byte[] bytes, String charset) {
        this.bytes = bytes;
        this.charset = Charset.forName(charset);
    }

    public HttpResult(byte[] bytes, ContentType contentType) {
        this.bytes = bytes;
        this.charset = contentType.getCharset();
    }

    public String getErrMsg() {
        return errMsg;
    }

    public void setErrMsg(String errMsg) {
        this.errMsg = errMsg;
    }

    public boolean isSuccess() {
        if (statusLine != null && statusLine.getStatusCode() == HttpStatus.SC_OK) {
            return true;
        } else {
            return false;
        }
    }

    public HttpClientContext getHttpClientContext() {
        return httpClientContext;
    }

    public void setHttpClientContext(HttpClientContext httpClientContext) {
        this.httpClientContext = httpClientContext;
    }

    public CookieStore getCookieStore() {
        return cookieStore;
    }

    public void setCookieStore(CookieStore cookieStore) {
        this.cookieStore = cookieStore;
    }

    public void addCookie(String name, String value) {
        addCookie(name, value, null, null);
    }

    public void addCookie(String name, String value, String domain, String path) {
        BasicClientCookie cookie = new BasicClientCookie(name, value);
        cookie.setDomain(domain);
        cookie.setPath(path);
        cookie.setVersion(0);

        // Set attributes EXACTLY as sent by the server
        cookie.setAttribute(ClientCookie.VERSION_ATTR, "0");
        cookie.setAttribute(ClientCookie.DOMAIN_ATTR, domain);
        cookie.setAttribute(ClientCookie.PORT_ATTR, "80,8080");
        cookieStore.addCookie(cookie);
    }

    public Map<String, String> getHeaders() {
        return headers;
    }

    public void setHeaders(Map<String, String> headers) {
        this.headers = headers;
    }

    public void addHeader(String key, String value) {
        headers.put(key, value);
    }

    public StatusLine getStatusLine() {
        return statusLine;
    }

    public void setStatusLine(StatusLine statusLine) {
        this.statusLine = statusLine;
    }

    public String getContext() {
        return getContext(charset);
    }

    public String getContext(String charset) {
        return getContext(Charset.forName(charset));
    }

    public String getContext(Charset charset) {
        if (bytes == null) {
            return null;
        }

        if (charset != null) {
            return new String(bytes, charset);
        } else {
            return new String(bytes);
        }
    }

    public byte[] getBytes() {
        return bytes;
    }
}
