package com.libawall.api.util;

import com.libawall.api.util.exception.DefaultResultCode;
import com.libawall.api.util.exception.WebException;

import java.io.Serializable;
import java.util.List;

public class PaginationQuery implements Serializable {

    /**
     * 当前页码
     */
    private int pageIndex = 1;

    /**
     * 分页数量
     */
    private int pageSize = 20;

    private int offset;
    /**
     * 设置当前页
     *
     * @param pageIndex 当前页
     */
    public void setPageIndex(int pageIndex) {
        if (pageIndex <= 0) {
            throw new WebException(DefaultResultCode.ILLEGAL_ARGUMENT);
        }
        this.pageIndex = pageIndex;
    }

    /**
     * 设置分页数量
     *
     * @param pageSize 分页数量
     */
    public void setPageSize(int pageSize) {
        if (pageSize <= 0) {
            throw new WebException(DefaultResultCode.ILLEGAL_ARGUMENT);
        }
        this.pageSize = pageSize;
    }

    /**
     * mysql startRow begin 0!
     */
    public int getStartRow() {
        return pageSize * (pageIndex - 1) + offset;
    }

    /**
     * 修复in时, list为空数组报错的问题,
     * 传空数组理论上是无法查出数据的, 添加一个null即可
     *
     * @param list 原数组
     * @param <T>  泛型
     * @return 修复后的数组
     */
    public static <T> List<T> repairIn(List<T> list) {
        if (list != null && list.isEmpty()) {
            list.add(null);
        }

        return list;
    }
}
