package com.libawall.api.util;

import org.apache.commons.lang3.ArrayUtils;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;

/**
 * Created by shichao on 2017/3/16.
 */
public class ClassGenricTypeBeanUtils {
    private static final Map<String, Type> CACHE_CLASS = new HashMap<>(8);

    public static Type getInterfacesGenricType(final Class clazz, Class interfaces, final int index) {
        String name = clazz.getName() + interfaces.getName() + index;

        return CACHE_CLASS.computeIfAbsent(name, k -> {
            //返回表示此 Class 所表示的实体（类、接口、基本类型或 void）的直接超类的 Type。
            Type[] types = clazz.getGenericInterfaces();

            types = ArrayUtils.add(types, clazz.getGenericSuperclass());
            Type resultClass;

            if (types.length > 0) {
                for (Type type : types) {
                    if (type instanceof ParameterizedType && ((ParameterizedType) type).getRawType() instanceof Class && interfaces.isAssignableFrom((Class) ((ParameterizedType) type).getRawType())) {
                        resultClass = getGenricType((ParameterizedType) type, index);
                        return resultClass;
                    } else if (type instanceof Class && interfaces.isAssignableFrom((Class) type)) {
                        resultClass = getInterfacesGenricType((Class) type, interfaces, index);
                        return resultClass;
                    }
                }
            }
            return null;
        });
    }

    private static Type getGenricType(ParameterizedType genType, int index) {
        //返回表示此类型实际类型参数的 Type 对象的数组。
        Type[] params = genType.getActualTypeArguments();

        if (index >= params.length || index < 0) {
            return null;
        }
        if (params[index] != null) {
            return params[index];
        }

        return null;
    }
}
