package com.libawall.api.user.request;


import com.libawall.api.user.response.UserResponse;
import com.libawall.api.util.BaseResponse;
import com.libawall.api.util.PageResponse;
import com.libawall.api.util.PaginationQuery;
import com.libawall.api.util.SdkRequest;
import com.libawall.util.httpclient.RequestMethod;

import java.util.List;

/**
 * 用户查询
 */
public class UserQueryInfoRequest  implements SdkRequest<BaseResponse<UserResponse>> {


    /**
     * 用户id
     */
    private final transient Long staffId;


    public UserQueryInfoRequest(Long staffId){
        this.staffId =staffId;
    }
    /**
     * 请求路径
     */
    @Override
    public String getUrl() {
        return "api/user/"+staffId;
    }

    /**
     * 请求方式
     */
    @Override
    public RequestMethod getMethod() {
        return RequestMethod.GET;
    }
}
