package com.libawall.api.user.request;

import com.libawall.api.util.BaseResponse;
import com.libawall.api.util.SdkRequest;
import com.libawall.util.httpclient.RequestMethod;

/**
 * 用户删除
 */
public class UserDeleteRequest implements SdkRequest<BaseResponse<Boolean>> {

    /**
     * 用户id
     */
    private final transient Long staffId;

    public UserDeleteRequest(Long staffId){
        this.staffId =staffId;
    }

    /**
     * 请求路径
     */
    @Override
    public String getUrl() {
        return "api/user/"+ staffId;
    }

    /**
     * 请求方式
     */
    @Override
    public RequestMethod getMethod() {
        return RequestMethod.DELETE;
    }
}
