package com.libawall.api.user.request;

import com.libawall.api.user.response.UserIdResponse;
import com.libawall.api.util.BaseResponse;
import com.libawall.api.util.MuiltSdkRequest;
import com.libawall.util.httpclient.RequestMethod;

import java.util.List;

/**
 * 用户批量新增
 */
public class UserBatchAddRequest implements MuiltSdkRequest<BaseResponse<List<UserIdResponse>>,UserBatchInfo> {


    private List<UserBatchInfo> userBatchInfos;

    public List<UserBatchInfo> getUserBatchInfos() {
        return userBatchInfos;
    }

    public void setUserBatchInfos(List<UserBatchInfo> userBatchInfos) {
        this.userBatchInfos = userBatchInfos;
    }

    /**
     * 请求路径
     */
    @Override
    public String getUrl() {
        return "api/user/batch";
    }

    /**
     * 请求方式
     */
    @Override
    public RequestMethod getMethod() {
        return RequestMethod.POST;
    }

    @Override
    public List<UserBatchInfo> getMulitList() {
        return userBatchInfos;
    }
}
