package com.libawall.api.seal.request;

import com.libawall.api.util.JsonSdkRequest;

import com.libawall.api.util.BaseResponse;
import com.libawall.api.util.SdkRequest;
import com.libawall.util.httpclient.RequestMethod;

import java.util.List;

/**
 * 更新印章
 * yda_seal
 * @author
 */
public class SealUpdateRequest implements JsonSdkRequest<BaseResponse<Boolean>> {

    /**
     * 印章id
     */
    private Long sealId;

    /**
     * 保管人Id 集合
     */
    private List<Long> custodianIdList;


    /**
     * 印章类型（1、沾墨 2、非沾墨）
     */
    private Integer type;

    /**
     * 印章特权人集合
     */
    private List<Long> sealStaffList;

    /**
     * 印章数据查看人集合
     */
    private List<Long> custodianList;


    public Long getSealId() {
        return sealId;
    }

    public void setSealId(Long sealId) {
        this.sealId = sealId;
    }

    public List<Long> getSealStaffList() {
        return sealStaffList;
    }

    public void setSealStaffList(List<Long> sealStaffList) {
        this.sealStaffList = sealStaffList;
    }

    public List<Long> getCustodianList() {
        return custodianList;
    }

    public void setCustodianList(List<Long> custodianList) {
        this.custodianList = custodianList;
    }

    public List<Long> getCustodianIdList() {
        return custodianIdList;
    }

    public void setCustodianIdList(List<Long> custodianIdList) {
        this.custodianIdList = custodianIdList;
    }

    public Integer getType() {
        return type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    /**
     * 请求路径
     */
    @Override
    public String getUrl() {
        return "api/seal";
    }

    /**
     * 请求方式
     */
    @Override
    public RequestMethod getMethod() {
        return RequestMethod.PUT;
    }
}
