package com.libawall.api.seal.request;


import com.libawall.api.util.JsonSdkRequest;

import com.libawall.api.util.BaseResponse;
import com.libawall.api.util.SdkRequest;
import com.libawall.util.httpclient.RequestMethod;

/**
 * 印章围栏修改
 */
public class SealRailUpdateRequest implements JsonSdkRequest<BaseResponse<Boolean>> {
    /**
     * 围栏id
     */
    private Long railId;

    /**
     * 印章id
     */
    private Long sealId;

    /**
     * 围栏名称
     */
    private String railName;

    /**
     * 围栏半径
     */
    private String railRadius;

    /**
     *  围栏中心点 经度
     */
    private String lon;

    /**
     * 围栏中心点 纬度
     */
    private String lat;

    /**
     * 围栏中心点位置信息
     */
    private String railAddress;

    public Long getRailId() {
        return railId;
    }

    public void setRailId(Long railId) {
        this.railId = railId;
    }

    public Long getSealId() {
        return sealId;
    }

    public void setSealId(Long sealId) {
        this.sealId = sealId;
    }

    public String getRailName() {
        return railName;
    }

    public void setRailName(String railName) {
        this.railName = railName;
    }

    public String getRailRadius() {
        return railRadius;
    }

    public void setRailRadius(String railRadius) {
        this.railRadius = railRadius;
    }

    public String getLon() {
        return lon;
    }

    public void setLon(String lon) {
        this.lon = lon;
    }

    public String getLat() {
        return lat;
    }

    public void setLat(String lat) {
        this.lat = lat;
    }

    public String getRailAddress() {
        return railAddress;
    }

    public void setRailAddress(String railAddress) {
        this.railAddress = railAddress;
    }

    /**
     * 请求路径
     */
    @Override
    public String getUrl() {
        return "api/seal/rail";
    }


    /**
     * 请求方式
     */
    @Override
    public RequestMethod getMethod() {
        return RequestMethod.PUT;
    }
}
