package com.libawall.api.seal.request;


import com.libawall.api.seal.response.SealRailResponse;
import com.libawall.api.util.PageResponse;
import com.libawall.api.util.PaginationQuery;
import com.libawall.api.util.SdkRequest;
import com.libawall.util.httpclient.RequestMethod;

/**
 * 分页电子围栏
 */
public class SealRailQuerRequest extends PaginationQuery implements SdkRequest<PageResponse<SealRailResponse>> {

    /**
     * 印章id
     */
    private Long sealId;

    /**
     * 围栏类型（1、无电子围栏，2、围栏范围内，3、已超出）
     */
    private Integer railType;

    public Long getSealId() {
        return sealId;
    }

    public void setSealId(Long sealId) {
        this.sealId = sealId;
    }

    public Integer getRailType() {
        return railType;
    }

    public void setRailType(Integer railType) {
        this.railType = railType;
    }

    /**
     * 请求路径
     */
    @Override
    public String getUrl() {
        return "api/seal/rail";
    }

    /**
     * 请求方式
     */
    @Override
    public RequestMethod getMethod() {
        return RequestMethod.GET;
    }
}
