package com.libawall.api.seal.request;


import com.libawall.api.seal.response.SealPageResponse;
import com.libawall.api.util.PageResponse;
import com.libawall.api.util.PaginationQuery;
import com.libawall.api.util.SdkRequest;
import com.libawall.util.httpclient.RequestMethod;

/**
 * 印章分页查询
 */
public class SealQueryRequest extends PaginationQuery implements SdkRequest<PageResponse<SealPageResponse>> {
    /**
     * 印章名称
     */
    private String searchName;
    /**
     * 访问人id
     */
    private Long staffId;

    /**
     * 根据创建时间排序
     */
    private Boolean orderByCreateTime;

    /**
     * 设备在线状态
     */
    private Integer deviceState;

    public String getSearchName() {
        return searchName;
    }

    public void setSearchName(String searchName) {
        this.searchName = searchName;
    }

    public Long getStaffId() {
        return staffId;
    }

    public void setStaffId(Long staffId) {
        this.staffId = staffId;
    }

    public Boolean getOrderByCreateTime() {
        return orderByCreateTime;
    }

    public void setOrderByCreateTime(Boolean orderByCreateTime) {
        this.orderByCreateTime = orderByCreateTime;
    }

    public Integer getDeviceState() {
        return deviceState;
    }

    public void setDeviceState(Integer deviceState) {
        this.deviceState = deviceState;
    }

    /**
     * 请求路径
     */
    @Override
    public String getUrl() {
        return "api/seal";
    }

    /**
     * 请求方式
     */
    @Override
    public RequestMethod getMethod() {
        return RequestMethod.GET;
    }
}
