package com.libawall.api.seal.request;


import com.libawall.api.seal.response.SealPageResponse;
import com.libawall.api.util.BaseResponse;
import com.libawall.api.util.SdkRequest;
import com.libawall.util.httpclient.RequestMethod;

/**
 * 根据印得安第三方印章唯一标识查询印章详情
 */
public class SealDetailsGovSealRequest implements SdkRequest<BaseResponse<SealPageResponse>> {
    /**
     * 印章id
     */
    private String govSeal;

    public String getGovSeal() {
        return govSeal;
    }

    public void setGovSeal(String govSeal) {
        this.govSeal = govSeal;
    }

    /**
     * 请求路径
     */
    @Override
    public String getUrl() {
        return "api/seal/getSealInfoByGovSeal";
    }

    /**
     * 请求方式
     */
    @Override
    public RequestMethod getMethod() {
        return RequestMethod.GET;
    }
}
