package com.libawall.api.seal.request;

import com.libawall.api.util.JsonSdkRequest;

import com.libawall.api.seal.response.SealIdResponse;
import com.libawall.api.util.BaseResponse;
import com.libawall.api.util.SdkRequest;
import com.libawall.util.httpclient.RequestMethod;

import java.util.List;

/**
 * 添加印章
 * yda_seal
 * @author
 */
public class SealAddRequest implements JsonSdkRequest<BaseResponse<SealIdResponse>> {
    /**
     * 印章名称
     */
    private String sealName;

    /**
     * 保管人Id 集合
     */
    private List<Long> custodianIdList;

    /**
     * 印章类型（1、沾墨 2、非沾墨）
     */
    private Integer type;

    /**
     * 印章特权人集合
     */
    private List<Long> sealStaffList;

    /**
     * 印章数据查看人集合
     */
    private List<Long> custodianList;

    /**
     * 印得安第三方印章唯一标识
     */
    private String govSeal;

    public String getSealName() {
        return sealName;
    }

    public void setSealName(String sealName) {
        this.sealName = sealName;
    }

    public Integer getType() {
        return type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public List<Long> getSealStaffList() {
        return sealStaffList;
    }

    public void setSealStaffList(List<Long> sealStaffList) {
        this.sealStaffList = sealStaffList;
    }

    public List<Long> getCustodianList() {
        return custodianList;
    }

    public void setCustodianList(List<Long> custodianList) {
        this.custodianList = custodianList;
    }

    public List<Long> getCustodianIdList() {
        return custodianIdList;
    }

    public void setCustodianIdList(List<Long> custodianIdList) {
        this.custodianIdList = custodianIdList;
    }

    public String getGovSeal() {
        return govSeal;
    }

    public void setGovSeal(String govSeal) {
        this.govSeal = govSeal;
    }

    /**
     * 请求路径
     */
    @Override
    public String getUrl() {
        return "api/seal";
    }

    /**
     * 请求方式
     */
    @Override
    public RequestMethod getMethod() {
        return RequestMethod.POST;
    }
}
