package com.libawall.api.firmware.request;


import com.libawall.api.firmware.response.FirmwareUpgradeResponse;
import com.libawall.api.util.BaseResponse;
import com.libawall.api.util.SdkRequest;
import com.libawall.util.httpclient.RequestMethod;

/**
 * 获取固件更新包
 */
public class FirmwareUpgradeRequest implements SdkRequest<BaseResponse<FirmwareUpgradeResponse>> {
    /**
     * 设备序列号
     */
    private String number;

    public String getNumber() {
        return number;
    }

    public void setNumber(String number) {
        this.number = number;
    }

    /**
     * 请求路径
     */
    @Override
    public String getUrl() {
        return "api/firmware/upgrade";
    }

    /**
     * 请求方式
     */
    @Override
    public RequestMethod getMethod() {
        return RequestMethod.GET;
    }
}
