package com.libawall.api.fingerprint.request;


import com.libawall.api.fingerprint.response.FingerprintStaffResponse;
import com.libawall.api.util.BaseResponse;
import com.libawall.api.util.SdkRequest;
import com.libawall.util.httpclient.RequestMethod;

import java.util.List;

/**
 * 指纹录入选择用户页面
 */
public class FingerprintStaffShowRequest implements SdkRequest<BaseResponse<List<FingerprintStaffResponse>>> {
    /**
     * 搜索用户名
     */
    private String searchName;

    /**
     * 用户id
     */
    private Long staffId;

    public String getSearchName() {
        return searchName;
    }

    public void setSearchName(String searchName) {
        this.searchName = searchName;
    }

    public Long getStaffId() {
        return staffId;
    }

    public void setStaffId(Long staffId) {
        this.staffId = staffId;
    }

    /**
     * 请求路径
     */
    @Override
    public String getUrl() {
        return "api/fingerprint/staff/show";
    }

    /**
     * 请求方式
     */
    @Override
    public RequestMethod getMethod() {
        return RequestMethod.GET;
    }
}
