package com.libawall.api.fingerprint.request;


import com.libawall.api.fingerprint.response.FingerprintShowResponse;
import com.libawall.api.util.PageResponse;
import com.libawall.api.util.PaginationQuery;
import com.libawall.api.util.SdkRequest;
import com.libawall.util.httpclient.RequestMethod;

/**
 * 指纹列表
 */
public class FingerprintShowRequest extends PaginationQuery implements SdkRequest<PageResponse<FingerprintShowResponse>> {
    /**
     * 访问者 用户id
     */
    private Long staffId;

    /**
     * 用户名模糊查询
     */
    private String searchName;

    public Long getStaffId() {
        return staffId;
    }

    public void setStaffId(Long staffId) {
        this.staffId = staffId;
    }

    public String getSearchName() {
        return searchName;
    }

    public void setSearchName(String searchName) {
        this.searchName = searchName;
    }

    /**
     * 请求路径
     */
    @Override
    public String getUrl() {
        return "api/fingerprint/show";
    }

    /**
     * 请求方式
     */
    @Override
    public RequestMethod getMethod() {
        return RequestMethod.GET;
    }
}
