package com.libawall.api.fingerprint.request;

import com.libawall.api.util.JsonSdkRequest;

import com.libawall.api.util.BaseResponse;
import com.libawall.api.util.SdkRequest;
import com.libawall.util.httpclient.RequestMethod;

/**
 * 指纹录入
 *
 * 返回:指纹录入 1、可以操作 2、用户指纹已满 3、设备指纹已满 4、操作太频繁，请三分钟后重试
 */
public class FingerprintInstallRequest  implements JsonSdkRequest<BaseResponse<Integer>> {
    /**
     * 设备编号
     */
    private String number;


    /**
     * 用户id
     */
    private Long staffId;


    public String getNumber() {
        return number;
    }

    public void setNumber(String number) {
        this.number = number;
    }

    public Long getStaffId() {
        return staffId;
    }

    public void setStaffId(Long staffId) {
        this.staffId = staffId;
    }

    /**
     * 请求路径
     */
    @Override
    public String getUrl() {
        return "api/fingerprint";
    }

    /**
     * 请求方式
     */
    @Override
    public RequestMethod getMethod() {
        return RequestMethod.PUT;
    }
}
