package com.libawall.api.equipment.request;


import com.libawall.api.equipment.response.MonitoringResponse;
import com.libawall.api.util.BaseResponse;
import com.libawall.api.util.SdkRequest;
import com.libawall.util.httpclient.RequestMethod;

/**
 * 设备监控主页面展示
 */
public class EquipmentShowRequest implements SdkRequest<BaseResponse<MonitoringResponse>> {
    /**
     * 用户id
     */
    private final transient Long staffId;

    public EquipmentShowRequest(Long staffId){
        this.staffId=staffId;
    }
    /**
     * 请求路径
     */
    @Override
    public String getUrl() {
        return "api/equipment/show?staffId="+staffId;
    }

    /**
     * 请求方式
     */
    @Override
    public RequestMethod getMethod() {
        return RequestMethod.GET;
    }
}
